/*
 * Decompiled with CFR 0.152.
 */
package chameleon.playlist.kpl;

import chameleon.content.Content;
import chameleon.playlist.AbstractPlaylistComponent;
import chameleon.playlist.Media;
import chameleon.playlist.Playlist;
import chameleon.playlist.SpecificPlaylist;
import chameleon.playlist.SpecificPlaylistProvider;
import chameleon.playlist.kpl.Entry;
import chameleon.playlist.kpl.Info;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Xml
implements SpecificPlaylist {
    private transient SpecificPlaylistProvider _provider = null;
    private final List<Entry> _entries = new ArrayList<Entry>();
    private final Info _info = new Info();

    public void setProvider(SpecificPlaylistProvider provider) {
        this._provider = provider;
    }

    public SpecificPlaylistProvider getProvider() {
        return this._provider;
    }

    public void writeTo(OutputStream out, String encoding) throws Exception {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.newDocument();
        document.setStrictErrorChecking(false);
        Element xmlElement = document.createElement("xml");
        document.appendChild(xmlElement);
        int nb = 0;
        for (Entry entry : this._entries) {
            if (entry.getFilename() == null) continue;
            Element element = document.createElement(Integer.toString(nb));
            element.setAttribute("filename", entry.getFilename());
            xmlElement.appendChild(element);
            if (entry.getTag() != null) {
                Element tagElement = document.createElement("tag");
                tagElement.setAttribute("artist", entry.getTag().getArtist());
                tagElement.setAttribute("album", entry.getTag().getAlbum());
                tagElement.setAttribute("title", entry.getTag().getTitle());
                tagElement.setAttribute("year", entry.getTag().getYear());
                tagElement.setAttribute("comment", entry.getTag().getComment());
                tagElement.setAttribute("genre", entry.getTag().getGenre());
                tagElement.setAttribute("track", entry.getTag().getTrack());
                tagElement.setAttribute("gid", entry.getTag().getGid());
                tagElement.setAttribute("has_tag", entry.getTag().getHasTag());
                element.appendChild(tagElement);
            }
            ++nb;
        }
        Element infoElement = document.createElement("info");
        infoElement.setAttribute("creation_day", this._info.getCreationDayString());
        infoElement.setAttribute("modified_day", this._info.getModifiedDayString());
        infoElement.setAttribute("author", this._info.getAuthor());
        infoElement.setAttribute("player", this._info.getPlayer());
        infoElement.setAttribute("player_version", this._info.getPlayerVersion());
        infoElement.setAttribute("kpl_version", this._info.getKplVersion());
        xmlElement.appendChild(infoElement);
        DOMSource source = new DOMSource(document);
        StreamResult result = new StreamResult(out);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        transformer.setOutputProperty("indent", "yes");
        if (encoding != null) {
            transformer.setOutputProperty("encoding", encoding);
        }
        transformer.transform(source, result);
        out.flush();
    }

    public Playlist toPlaylist() {
        Playlist ret = new Playlist();
        for (Entry entry : this._entries) {
            if (entry.getFilename() == null) continue;
            Media media = new Media();
            Content content = new Content(entry.getFilename());
            media.setSource(content);
            ret.getRootSequence().addComponent((AbstractPlaylistComponent)media);
        }
        ret.normalize();
        return ret;
    }

    public List<Entry> getEntries() {
        return this._entries;
    }

    public Info getInfo() {
        return this._info;
    }
}

