/*
 * Decompiled with CFR 0.152.
 */
package chameleon.playlist.m3u;

import chameleon.content.type.ContentType;
import chameleon.player.PlayerSupport;
import chameleon.playlist.AbstractPlaylistComponent;
import chameleon.playlist.Media;
import chameleon.playlist.Parallel;
import chameleon.playlist.Playlist;
import chameleon.playlist.Sequence;
import chameleon.playlist.SpecificPlaylist;
import chameleon.playlist.SpecificPlaylistProvider;
import chameleon.playlist.m3u.M3U;
import chameleon.playlist.m3u.Resource;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import java.util.Locale;
import org.apache.commons.logging.Log;

public class M3UProvider
implements SpecificPlaylistProvider {
    private static final ContentType[] FILETYPES = new ContentType[]{new ContentType(new String[]{".m3u"}, new String[]{"audio/x-mpegurl", "audio/mpegurl"}, new PlayerSupport[]{new PlayerSupport(PlayerSupport.Player.WINAMP, true, null), new PlayerSupport(PlayerSupport.Player.VLC_MEDIA_PLAYER, true, null), new PlayerSupport(PlayerSupport.Player.WINDOWS_MEDIA_PLAYER, true, null), new PlayerSupport(PlayerSupport.Player.MEDIA_PLAYER_CLASSIC, true, null), new PlayerSupport(PlayerSupport.Player.FOOBAR2000, true, null), new PlayerSupport(PlayerSupport.Player.MPLAYER, true, null), new PlayerSupport(PlayerSupport.Player.QUICKTIME, true, null), new PlayerSupport(PlayerSupport.Player.ITUNES, true, null), new PlayerSupport(PlayerSupport.Player.REALPLAYER, false, null)}, "Winamp M3U"), new ContentType(new String[]{".m3u8"}, new String[]{"audio/x-mpegurl", "audio/mpegurl"}, new PlayerSupport[]{new PlayerSupport(PlayerSupport.Player.WINAMP, true, null), new PlayerSupport(PlayerSupport.Player.FOOBAR2000, true, null)}, "Winamp M3U8"), new ContentType(new String[]{".m4u"}, new String[]{"video/x-mpegurl"}, new PlayerSupport[0], "M4U Playlist"), new ContentType(new String[]{".ram"}, new String[]{"audio/vnd.rn-realaudio", "audio/x-pn-realaudio"}, new PlayerSupport[]{new PlayerSupport(PlayerSupport.Player.MEDIA_PLAYER_CLASSIC, false, null), new PlayerSupport(PlayerSupport.Player.REALPLAYER, false, null)}, "Real Audio Metadata (RAM)")};

    public String getId() {
        return "m3u";
    }

    public ContentType[] getContentTypes() {
        return (ContentType[])FILETYPES.clone();
    }

    public SpecificPlaylist readFrom(InputStream in, String encoding, Log logger) throws Exception {
        String line;
        String enc = encoding;
        if (enc == null) {
            enc = "UTF-8";
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(in, enc));
        M3U ret = new M3U();
        ret.setProvider(this);
        String songName = null;
        String songLength = null;
        while ((line = reader.readLine()) != null) {
            if ((line = line.trim()).length() <= 0) continue;
            char firstChar = line.charAt(0);
            if (firstChar == '<' || firstChar == '[') {
                throw new IllegalArgumentException("Doesn't seem to be a M3U playlist (and related ones)");
            }
            if (firstChar == '#') {
                int indB;
                if (!line.toUpperCase(Locale.ENGLISH).startsWith("#EXTINF")) continue;
                int indA = line.indexOf(44, 0);
                if (indA >= 0) {
                    songName = line.substring(indA + 1, line.length());
                }
                if ((indB = line.indexOf(58, 0)) < 0 || indB >= indA) continue;
                songLength = line.substring(indB + 1, indA).trim();
                continue;
            }
            Resource resource = new Resource();
            resource.setLocation(line);
            resource.setName(songName);
            if (songLength != null) {
                resource.setLength(Long.parseLong(songLength));
            }
            ret.getResources().add(resource);
            songName = null;
            songLength = null;
        }
        return ret;
    }

    public SpecificPlaylist toSpecificPlaylist(Playlist playlist) throws Exception {
        M3U ret = new M3U();
        ret.setProvider(this);
        this.addToPlaylist(ret.getResources(), (AbstractPlaylistComponent)playlist.getRootSequence());
        return ret;
    }

    private void addToPlaylist(List<Resource> resources, AbstractPlaylistComponent component) throws Exception {
        block10: {
            block9: {
                if (!(component instanceof Sequence)) break block9;
                Sequence seq = (Sequence)component;
                if (seq.getRepeatCount() < 0) {
                    throw new IllegalArgumentException("A M3U playlist cannot handle a sequence repeated indefinitely");
                }
                AbstractPlaylistComponent[] components = seq.getComponents();
                for (int iter = 0; iter < seq.getRepeatCount(); ++iter) {
                    for (AbstractPlaylistComponent c : components) {
                        this.addToPlaylist(resources, c);
                    }
                }
                break block10;
            }
            if (component instanceof Parallel) {
                throw new IllegalArgumentException("A parallel time container is incompatible with a M3U playlist");
            }
            if (!(component instanceof Media)) break block10;
            Media media = (Media)component;
            if (media.getDuration() != null) {
                throw new IllegalArgumentException("A M3U playlist cannot handle a timed media");
            }
            if (media.getRepeatCount() < 0) {
                throw new IllegalArgumentException("A M3U playlist cannot handle a media repeated indefinitely");
            }
            if (media.getSource() != null) {
                for (int iter = 0; iter < media.getRepeatCount(); ++iter) {
                    Resource resource = new Resource();
                    resource.setLocation(media.getSource().toString());
                    if (media.getSource().getDuration() >= 0L) {
                        resource.setLength((media.getSource().getDuration() + 999L) / 1000L);
                    }
                    resources.add(resource);
                }
            }
        }
    }
}

