/*
 * Decompiled with CFR 0.152.
 */
package chameleon.playlist.plist;

import chameleon.content.type.ContentType;
import chameleon.io.IOUtils;
import chameleon.player.PlayerSupport;
import chameleon.playlist.AbstractPlaylistComponent;
import chameleon.playlist.Media;
import chameleon.playlist.Parallel;
import chameleon.playlist.Playlist;
import chameleon.playlist.Sequence;
import chameleon.playlist.SpecificPlaylist;
import chameleon.playlist.SpecificPlaylistProvider;
import chameleon.playlist.plist.PlistPlaylist;
import chameleon.plist.Array;
import chameleon.plist.Date;
import chameleon.plist.Dict;
import chameleon.plist.Integer;
import chameleon.plist.Plist;
import chameleon.plist.PlistObject;
import chameleon.plist.String;
import chameleon.plist.True;
import chameleon.xml.Version;
import chameleon.xml.XmlSerializer;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import org.apache.commons.logging.Log;

public class PlistProvider
implements SpecificPlaylistProvider {
    private static final ContentType[] FILETYPES = new ContentType[]{new ContentType(new java.lang.String[]{".plist", ".xml"}, new java.lang.String[]{"text/xml"}, new PlayerSupport[]{new PlayerSupport(PlayerSupport.Player.ITUNES, true, null)}, "iTunes Library File")};

    public java.lang.String getId() {
        return "plist";
    }

    public ContentType[] getContentTypes() {
        return (ContentType[])FILETYPES.clone();
    }

    public SpecificPlaylist readFrom(InputStream in, java.lang.String encoding, Log logger) throws Exception {
        java.lang.String enc = encoding;
        if (enc == null) {
            enc = "UTF-8";
        }
        java.lang.String str = IOUtils.toString((InputStream)in, (java.lang.String)enc);
        str = str.replace("&", "&amp;");
        str = str.replaceAll("&amp;([a-zA-Z0-9#]+;)", "&$1");
        XmlSerializer serializer = XmlSerializer.getMapping((java.lang.String)"chameleon/plist");
        serializer.getUnmarshaller().setIgnoreExtraElements(false);
        StringReader reader = new StringReader(str);
        Plist plist = (Plist)serializer.unmarshal((Reader)reader);
        PlistPlaylist ret = new PlistPlaylist();
        ret.setProvider(this);
        ret.setPlist(plist);
        return ret;
    }

    public SpecificPlaylist toSpecificPlaylist(Playlist playlist) throws Exception {
        PlistPlaylist ret = new PlistPlaylist();
        ret.setProvider(this);
        Dict rootDict = new Dict();
        ret.getPlist().setPlistObject(rootDict);
        Dict tracks = new Dict();
        rootDict.put("Tracks", (PlistObject)tracks);
        Array playlists = new Array();
        rootDict.put("Playlists", (PlistObject)playlists);
        Dict playlistDict = new Dict();
        playlists.addPlistObject(playlistDict);
        playlistDict.put("Name", (PlistObject)new String("Playlist generated by Chameleon v" + Version.CURRENT));
        playlistDict.put("Playlist ID", (PlistObject)new Integer(System.identityHashCode(playlist.getRootSequence())));
        playlistDict.put("All Items", (PlistObject)new True());
        Array playlistArray = new Array();
        playlistDict.put("Playlist Items", (PlistObject)playlistArray);
        this.addToPlaylist(tracks, playlistArray, (AbstractPlaylistComponent)playlist.getRootSequence());
        return ret;
    }

    private void addToPlaylist(Dict tracks, Array playlist, AbstractPlaylistComponent component) throws Exception {
        block12: {
            block11: {
                if (!(component instanceof Sequence)) break block11;
                Sequence sequence = (Sequence)component;
                if (sequence.getRepeatCount() < 0) {
                    throw new IllegalArgumentException("A PLIST playlist cannot handle a sequence repeated indefinitely");
                }
                AbstractPlaylistComponent[] components = sequence.getComponents();
                for (int iter = 0; iter < sequence.getRepeatCount(); ++iter) {
                    for (AbstractPlaylistComponent c : components) {
                        this.addToPlaylist(tracks, playlist, c);
                    }
                }
                break block12;
            }
            if (component instanceof Parallel) {
                throw new IllegalArgumentException("A PLIST playlist cannot play different media at the same time");
            }
            if (!(component instanceof Media)) break block12;
            Media media = (Media)component;
            if (media.getDuration() != null) {
                throw new IllegalArgumentException("A PLIST playlist cannot handle a timed media");
            }
            if (media.getRepeatCount() < 0) {
                throw new IllegalArgumentException("A PLIST playlist cannot handle a media repeated indefinitely");
            }
            if (media.getSource() != null) {
                for (int iter = 0; iter < media.getRepeatCount(); ++iter) {
                    Dict entry = new Dict();
                    entry.put("Track ID", (PlistObject)new Integer(System.identityHashCode(media.getSource())));
                    playlist.addPlistObject(entry);
                    Dict track = new Dict();
                    tracks.put(java.lang.Integer.toString(System.identityHashCode(media.getSource())), (PlistObject)track);
                    track.put("Track ID", (PlistObject)new Integer(System.identityHashCode(media.getSource())));
                    if (media.getSource().getLength() >= 0L) {
                        track.put("Size", (PlistObject)new Integer((int)media.getSource().getLength()));
                    }
                    if (media.getSource().getDuration() >= 0L) {
                        track.put("Total Time", (PlistObject)new Integer((int)media.getSource().getDuration()));
                    }
                    if (media.getSource().getLastModified() > 0L) {
                        track.put("Date Modified", (PlistObject)new Date(new java.util.Date(media.getSource().getLastModified())));
                    }
                    track.put("Location", (PlistObject)new String(media.getSource().toString()));
                }
            }
        }
    }
}

