/*
 * Decompiled with CFR 0.152.
 */
package chameleon.playlist.plp;

import chameleon.content.type.ContentType;
import chameleon.player.PlayerSupport;
import chameleon.playlist.AbstractPlaylistComponent;
import chameleon.playlist.Media;
import chameleon.playlist.Parallel;
import chameleon.playlist.Playlist;
import chameleon.playlist.Sequence;
import chameleon.playlist.SpecificPlaylist;
import chameleon.playlist.SpecificPlaylistProvider;
import chameleon.playlist.plp.PLP;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import org.apache.commons.logging.Log;

public class PLPProvider
implements SpecificPlaylistProvider {
    private static final ContentType[] FILETYPES = new ContentType[]{new ContentType(new String[]{".plp"}, new String[]{"text/plain"}, new PlayerSupport[0], "Sansa Playlist File")};

    public String getId() {
        return "plp";
    }

    public ContentType[] getContentTypes() {
        return (ContentType[])FILETYPES.clone();
    }

    public SpecificPlaylist readFrom(InputStream in, String encoding, Log logger) throws Exception {
        String line;
        String enc = encoding;
        if (enc == null) {
            enc = "UTF-16LE";
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(in, enc));
        PLP ret = new PLP();
        ret.setProvider(this);
        boolean magic1Found = false;
        boolean magic2Found = false;
        String disk = null;
        while ((line = reader.readLine()) != null) {
            if ((line = line.trim()).length() <= 0) continue;
            if (!magic1Found) {
                if (!"PLP PLAYLIST".equals(line)) {
                    throw new IllegalArgumentException("Not a PLP playlist format");
                }
                magic1Found = true;
                continue;
            }
            if (!magic2Found) {
                if (!"VERSION 1.20".equals(line)) {
                    logger.error((Object)"Malformed PLP playlist (no version information)");
                    ret = null;
                    break;
                }
                magic2Found = true;
                continue;
            }
            int idx = line.indexOf(44);
            if (idx <= 0) {
                logger.error((Object)"Malformed PLP playlist (playlist entry line format)");
                ret = null;
                break;
            }
            String tmpDisk = line.substring(0, idx).trim();
            if (disk == null) {
                disk = tmpDisk;
            } else if (!disk.equals(tmpDisk)) {
                logger.error((Object)"Malformed PLP playlist (inconsistent disk specifier)");
                ret = null;
                break;
            }
            ret.getFilenames().add(line.substring(idx + 1).trim());
        }
        if (ret != null && disk != null) {
            ret.setDiskSpecifier(disk);
        }
        return ret;
    }

    public SpecificPlaylist toSpecificPlaylist(Playlist playlist) throws Exception {
        PLP ret = new PLP();
        ret.setProvider(this);
        this.addToPlaylist(ret.getFilenames(), (AbstractPlaylistComponent)playlist.getRootSequence());
        return ret;
    }

    private void addToPlaylist(List<String> filenames, AbstractPlaylistComponent component) throws Exception {
        block9: {
            block8: {
                if (!(component instanceof Sequence)) break block8;
                Sequence seq = (Sequence)component;
                if (seq.getRepeatCount() < 0) {
                    throw new IllegalArgumentException("A PLP playlist cannot handle a sequence repeated indefinitely");
                }
                AbstractPlaylistComponent[] components = seq.getComponents();
                for (int iter = 0; iter < seq.getRepeatCount(); ++iter) {
                    for (AbstractPlaylistComponent c : components) {
                        this.addToPlaylist(filenames, c);
                    }
                }
                break block9;
            }
            if (component instanceof Parallel) {
                throw new IllegalArgumentException("A parallel time container is incompatible with a PLP playlist");
            }
            if (!(component instanceof Media)) break block9;
            Media media = (Media)component;
            if (media.getDuration() != null) {
                throw new IllegalArgumentException("A PLP playlist cannot handle a timed media");
            }
            if (media.getRepeatCount() < 0) {
                throw new IllegalArgumentException("A PLP playlist cannot handle a media repeated indefinitely");
            }
            if (media.getSource() != null) {
                for (int iter = 0; iter < media.getRepeatCount(); ++iter) {
                    filenames.add(media.getSource().toString());
                }
            }
        }
    }
}

