/*
 * Decompiled with CFR 0.152.
 */
package chameleon.playlist.rmp;

import chameleon.lang.StringUtils;
import chameleon.playlist.rmp.Tracklist;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

@XmlRootElement(name="TRACK")
public class Track {
    private String _id = null;
    private String _url = null;
    private String _title = null;
    private String _album = null;
    private String _artist = null;
    private String _genre = null;
    private String _fileName = null;
    private Long _size = null;
    private String _format = null;
    private Integer _quality = null;
    private Integer _channels = null;
    private Integer _duration = null;
    private String _contextInfoUrl = null;
    private Integer _contextInfoWidth = null;
    private Integer _contextInfoHeight = null;
    private boolean _isStreaming = false;
    private transient Tracklist _parent = null;

    void setParent(Tracklist parent) {
        this._parent = parent;
    }

    public Tracklist getParent() {
        return this._parent;
    }

    @XmlElement(name="TRACKID")
    public String getId() {
        return this._id;
    }

    public void setId(String id) {
        this._id = StringUtils.normalize((String)id);
    }

    @XmlElement(name="URL")
    public String getUrlString() {
        return this._url;
    }

    public void setUrlString(String url) {
        this._url = StringUtils.normalize((String)url);
    }

    @XmlElement(name="TITLE")
    public String getTitle() {
        return this._title;
    }

    public void setTitle(String title) {
        this._title = StringUtils.normalize((String)title);
    }

    @XmlElement(name="ALBUM")
    public String getAlbum() {
        return this._album;
    }

    public void setAlbum(String album) {
        this._album = StringUtils.normalize((String)album);
    }

    @XmlElement(name="ARTIST")
    public String getArtist() {
        return this._artist;
    }

    public void setArtist(String artist) {
        this._artist = StringUtils.normalize((String)artist);
    }

    @XmlElement(name="GENRE")
    public String getGenre() {
        return this._genre;
    }

    public void setGenre(String genre) {
        this._genre = StringUtils.normalize((String)genre);
    }

    @XmlElement(name="FILENAME")
    public String getFileName() {
        return this._fileName;
    }

    public void setFileName(String fileName) {
        this._fileName = StringUtils.normalize((String)fileName);
    }

    @XmlElement(name="SIZE")
    public Long getSize() {
        return this._size;
    }

    public void setSize(Long size) {
        if (size != null && size.intValue() < 0) {
            throw new IllegalArgumentException("Negative size");
        }
        this._size = size;
    }

    public void setSize(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("Negative size");
        }
        this._size = size;
    }

    @XmlElement(name="FORMAT")
    public String getFormat() {
        return this._format;
    }

    public void setFormat(String format) {
        this._format = StringUtils.normalize((String)format);
    }

    @XmlElement(name="QUALITY")
    public Integer getQuality() {
        return this._quality;
    }

    public void setQuality(Integer quality) {
        if (quality != null && quality < 0) {
            throw new IllegalArgumentException("Negative quality");
        }
        this._quality = quality;
    }

    public void setQuality(int quality) {
        if (quality < 0) {
            throw new IllegalArgumentException("Negative quality");
        }
        this._quality = quality;
    }

    @XmlElement(name="CHANNELS")
    public Integer getChannels() {
        return this._channels;
    }

    public void setChannels(Integer channels) {
        if (channels != null && channels < 0) {
            throw new IllegalArgumentException("Negative number of channels");
        }
        this._channels = channels;
    }

    public void setChannels(int channels) {
        if (channels < 0) {
            throw new IllegalArgumentException("Negative number of channels");
        }
        this._channels = channels;
    }

    @XmlElement(name="DURATION")
    public Integer getDuration() {
        return this._duration;
    }

    public void setDuration(Integer duration) {
        if (duration != null && duration < 0) {
            throw new IllegalArgumentException("Negative duration");
        }
        this._duration = duration;
    }

    public void setDuration(int duration) {
        if (duration < 0) {
            throw new IllegalArgumentException("Negative duration");
        }
        this._duration = duration;
    }

    @XmlElement(name="CONTEXTINFO_URL")
    public String getContextInfoUrlString() {
        return this._contextInfoUrl;
    }

    public void setContextInfoUrlString(String url) {
        this._contextInfoUrl = StringUtils.normalize((String)url);
    }

    @XmlElement(name="CONTEXTINFO_WIDTH")
    public Integer getContextInfoWidth() {
        return this._contextInfoWidth;
    }

    public void setContextInfoWidth(Integer width) {
        if (width != null && width < 0) {
            throw new IllegalArgumentException("Negative context info width");
        }
        this._contextInfoWidth = width;
    }

    public void setContextInfoWidth(int width) {
        if (width < 0) {
            throw new IllegalArgumentException("Negative context info width");
        }
        this._contextInfoWidth = width;
    }

    @XmlElement(name="CONTEXTINFO_HEIGHT")
    public Integer getContextInfoHeight() {
        return this._contextInfoHeight;
    }

    public void setContextInfoHeight(Integer height) {
        if (height != null && height < 0) {
            throw new IllegalArgumentException("Negative context info height");
        }
        this._contextInfoHeight = height;
    }

    public void setContextInfoHeight(int height) {
        if (height < 0) {
            throw new IllegalArgumentException("Negative context info height");
        }
        this._contextInfoHeight = height;
    }

    @XmlElement(name="IS_STREAMING")
    public String getIsStreamingString() {
        String ret = null;
        if (this._isStreaming) {
            ret = "1";
        }
        return ret;
    }

    public void setIsStreamingString(String isStreaming) {
        this._isStreaming = "1".equals(isStreaming);
    }

    @XmlTransient
    public boolean isStreaming() {
        return this._isStreaming;
    }

    public void setIsStreaming(boolean isStreaming) {
        this._isStreaming = isStreaming;
    }
}

