/*
 * Decompiled with CFR 0.152.
 */
package chameleon.playlist.rmp;

import chameleon.lang.StringUtils;
import chameleon.playlist.rmp.Package;
import chameleon.playlist.rmp.Track;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="TRACKLIST")
public class Tracklist {
    private String _id = null;
    private final List<Track> _tracks = new ArrayList<Track>();
    private transient Package _parent = null;

    void setParent(Package parent) {
        this._parent = parent;
    }

    public Package getParent() {
        return this._parent;
    }

    @XmlElement(name="LISTID")
    public String getId() {
        return this._id;
    }

    public void setId(String id) {
        this._id = StringUtils.normalize((String)id);
    }

    public void addTrack(Track track) {
        track.setParent(this);
        this._tracks.add(track);
    }

    @XmlElement(name="TRACK", type=Track.class)
    public List<Track> getTracks() {
        return this._tracks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTracks(List<Track> tracks) {
        List<Track> list = this._tracks;
        synchronized (list) {
            this._tracks.clear();
            for (Track track : tracks) {
                this.addTrack(track);
            }
        }
    }
}

