/*
 * Decompiled with CFR 0.152.
 */
package chameleon.playlist.rss;

import chameleon.playlist.AbstractPlaylistComponent;
import chameleon.playlist.Media;
import chameleon.playlist.Playlist;
import chameleon.playlist.Sequence;
import chameleon.playlist.SpecificPlaylist;
import chameleon.playlist.SpecificPlaylistProvider;
import chameleon.rss.Enclosure;
import chameleon.rss.Item;
import chameleon.rss.RSS;
import chameleon.rss.media.Content;
import chameleon.rss.media.Group;
import chameleon.xml.XmlSerializer;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;

public class RSSPlaylist
implements SpecificPlaylist {
    private transient SpecificPlaylistProvider _provider = null;
    private RSS _rss = new RSS();

    public void setProvider(SpecificPlaylistProvider provider) {
        this._provider = provider;
    }

    public SpecificPlaylistProvider getProvider() {
        return this._provider;
    }

    public void writeTo(OutputStream out, String encoding) throws Exception {
        StringWriter writer = new StringWriter();
        XmlSerializer serializer = XmlSerializer.getMapping((String)"chameleon/rss");
        serializer.getMarshaller().setProperty("org.exolab.castor.indent", "true");
        serializer.getMarshaller().setNamespaceMapping("media", "http://search.yahoo.com/mrss/");
        serializer.marshal((Object)this._rss, (Writer)writer, false);
        String enc = encoding;
        if (enc == null) {
            enc = "UTF-8";
        }
        byte[] bytes = writer.toString().getBytes(enc);
        out.write(bytes);
        out.flush();
    }

    public Playlist toPlaylist() {
        Playlist ret = new Playlist();
        for (Item item : this._rss.getChannel().getItems()) {
            Enclosure enclosure = item.getEnclosure();
            if (enclosure == null || enclosure.getURL() == null) {
                block1: for (Group mediaGroup : item.getMediaGroups()) {
                    boolean foundOne = false;
                    for (Content mediaContent : mediaGroup.getMediaContents()) {
                        if (!mediaContent.isDefault() || !this.addMediaContent(mediaContent, ret.getRootSequence())) continue;
                        foundOne = true;
                        break;
                    }
                    if (foundOne) continue;
                    for (Content mediaContent : mediaGroup.getMediaContents()) {
                        if (!this.addMediaContent(mediaContent, ret.getRootSequence())) continue;
                        foundOne = true;
                        continue block1;
                    }
                }
                for (Content mediaContent : item.getMediaContents()) {
                    this.addMediaContent(mediaContent, ret.getRootSequence());
                }
                continue;
            }
            Media media = new Media();
            chameleon.content.Content content = new chameleon.content.Content(enclosure.getURL());
            content.setLength(enclosure.getLength());
            content.setType(enclosure.getType());
            media.setSource(content);
            ret.getRootSequence().addComponent((AbstractPlaylistComponent)media);
        }
        ret.normalize();
        return ret;
    }

    private boolean addMediaContent(Content mediaContent, Sequence sequence) {
        boolean ret = false;
        if (mediaContent.getURL() != null) {
            Media media = new Media();
            chameleon.content.Content content = new chameleon.content.Content(mediaContent.getURL());
            content.setType(mediaContent.getType());
            if (mediaContent.getFileSize() != null) {
                content.setLength(mediaContent.getFileSize().longValue());
            }
            if (mediaContent.getDuration() != null) {
                content.setDuration(mediaContent.getDuration().longValue() * 1000L);
            }
            if (mediaContent.getWidth() != null) {
                content.setWidth(mediaContent.getWidth().intValue());
            }
            if (mediaContent.getHeight() != null) {
                content.setHeight(mediaContent.getHeight().intValue());
            }
            media.setSource(content);
            sequence.addComponent((AbstractPlaylistComponent)media);
            ret = true;
        } else if (mediaContent.getMediaPlayer() != null && mediaContent.getMediaPlayer().getURL() != null) {
            Media media = new Media();
            chameleon.content.Content content = new chameleon.content.Content(mediaContent.getMediaPlayer().getURL());
            content.setType(mediaContent.getType());
            if (mediaContent.getFileSize() != null) {
                content.setLength(mediaContent.getFileSize().longValue());
            }
            if (mediaContent.getDuration() != null) {
                content.setDuration(mediaContent.getDuration().longValue() * 1000L);
            }
            media.setSource(content);
            sequence.addComponent((AbstractPlaylistComponent)media);
            ret = true;
        }
        return ret;
    }

    public RSS getRSS() {
        return this._rss;
    }

    public void setRSS(RSS rss) {
        if (rss == null) {
            throw new NullPointerException("No RSS document");
        }
        this._rss = rss;
    }
}

