/*
 * Decompiled with CFR 0.152.
 */
package chameleon.rss;

import chameleon.rss.Category;
import chameleon.rss.Channel;
import chameleon.rss.Enclosure;
import chameleon.rss.GUID;
import chameleon.rss.RFC822;
import chameleon.rss.Source;
import chameleon.rss.media.BaseMedia;
import chameleon.rss.media.Content;
import chameleon.rss.media.Group;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class Item
extends BaseMedia {
    private String _title = null;
    private URI _link = null;
    private String _description = null;
    private String _author = null;
    private final List<Category> _categories = new ArrayList<Category>();
    private String _comments = null;
    private Enclosure _enclosure = null;
    private GUID _guid = null;
    private Date _pubDate = null;
    private Source _source = null;
    private final List<Content> _mediaContents = new ArrayList<Content>();
    private final List<Group> _mediaGroups = new ArrayList<Group>();
    private transient Channel _channel = null;

    public String getTitle() {
        return this._title;
    }

    public void setTitle(String title) {
        this._title = title;
    }

    public void setLinkString(String link) throws URISyntaxException {
        this._link = new URI(link);
    }

    public String getLinkString() {
        String ret = null;
        if (this._link != null) {
            ret = this._link.toString();
        }
        return ret;
    }

    public void setLink(URI link) {
        this._link = link;
    }

    public URI getLink() {
        return this._link;
    }

    public String getDescription() {
        return this._description;
    }

    public void setDescription(String description) {
        this._description = description;
    }

    public String getAuthor() {
        return this._author;
    }

    public void setAuthor(String author) {
        this._author = author;
    }

    public List<Category> getCategories() {
        return this._categories;
    }

    public void addCategory(Category category) {
        if (category == null) {
            throw new NullPointerException("no category");
        }
        this._categories.add(category);
    }

    public String getComments() {
        return this._comments;
    }

    public void setComments(String comments) {
        this._comments = comments;
    }

    public Enclosure getEnclosure() {
        return this._enclosure;
    }

    public void setEnclosure(Enclosure enclosure) {
        this._enclosure = enclosure;
    }

    public GUID getGuid() {
        return this._guid;
    }

    public void setGuid(GUID guid) {
        this._guid = guid;
    }

    public void setPubDateString(String pubDate) {
        this._pubDate = RFC822.valueOf(pubDate);
    }

    public String getPubDateString() {
        String ret = null;
        if (this._pubDate != null) {
            ret = RFC822.toString(this._pubDate);
        }
        return ret;
    }

    public Date getPubDate() {
        return this._pubDate;
    }

    public void setPubDate(Date pubDate) {
        this._pubDate = pubDate;
    }

    public Source getSource() {
        return this._source;
    }

    public void setSource(Source source) {
        this._source = source;
    }

    public void addMediaContent(Content mediaContent) {
        if (mediaContent == null) {
            throw new NullPointerException("no media content");
        }
        this._mediaContents.add(mediaContent);
    }

    public List<Content> getMediaContents() {
        return this._mediaContents;
    }

    public List<Group> getMediaGroups() {
        return this._mediaGroups;
    }

    public void addMediaGroup(Group mediaGroup) {
        if (mediaGroup == null) {
            throw new NullPointerException("no media group");
        }
        this._mediaGroups.add(mediaGroup);
    }

    void setChannel(Channel channel) {
        this._channel = channel;
    }

    public Channel getChannel() {
        return this._channel;
    }
}

