/*
 * Decompiled with CFR 0.152.
 */
package chameleon.playlist.smil;

import chameleon.lang.StringUtils;
import chameleon.playlist.smil.Core;
import chameleon.playlist.smil.SmilVisitor;

public abstract class AbstractSmilElement
extends Core {
    private static final String INDEFINITE = "indefinite";
    private transient AbstractSmilElement _parent = null;
    private String _begin = null;
    private String _end = null;
    private Long _duration = null;
    private Float _repeatCount = null;
    private String _repeatDuration = null;
    private String _min = null;
    private String _max = null;
    private String _region = null;

    public AbstractSmilElement getParent() {
        return this._parent;
    }

    void setParent(AbstractSmilElement parent) {
        this._parent = parent;
    }

    public String getRegionString() {
        String ret = null;
        if (this._region != null) {
            ret = this._region;
        } else if (this._parent != null) {
            ret = this._parent.getRegionString();
        }
        return ret;
    }

    public void setRegionString(String region) {
        this._region = StringUtils.normalize((String)region);
    }

    public String getRepeatCountString() {
        String ret = null;
        if (this._repeatCount != null) {
            ret = this._repeatCount.intValue() < 0 ? INDEFINITE : this._repeatCount.toString();
        }
        return ret;
    }

    public void setRepeatCountString(String repeatCount) {
        if (repeatCount == null) {
            this._repeatCount = null;
        } else {
            String str = repeatCount.trim();
            if (INDEFINITE.equalsIgnoreCase(str)) {
                this._repeatCount = Float.valueOf(-1.0f);
            } else {
                this.setRepeatCount(Float.valueOf(str));
            }
        }
    }

    public Float getRepeatCount() {
        return this._repeatCount;
    }

    public void setRepeatCount(Float repeatCount) {
        int i;
        this._repeatCount = repeatCount == null ? null : ((i = repeatCount.intValue()) == 1 ? null : (i < 0 ? Float.valueOf(-1.0f) : repeatCount));
    }

    public String getRepeatDuration() {
        return this._repeatDuration;
    }

    public void setRepeatDuration(String duration) {
        this._repeatDuration = StringUtils.normalize((String)duration);
    }

    public Long getDuration() {
        return this._duration;
    }

    public void setDuration(Long duration) {
        if (duration != null && duration < 0L) {
            throw new IllegalArgumentException("Negative duration");
        }
        this._duration = duration;
    }

    public String getDurationString() {
        String ret = null;
        if (this._duration != null) {
            if (this._duration.equals(Long.MAX_VALUE)) {
                ret = INDEFINITE;
            } else {
                String suffix;
                StringBuilder sb = new StringBuilder();
                long millis = this._duration;
                long i = millis / 3600000L;
                if (i > 0L) {
                    sb.append(StringUtils.toString((long)i, (int)2));
                    sb.append(':');
                    millis -= i * 60L * 60L * 1000L;
                }
                if ((i = millis / 60000L) > 0L) {
                    sb.append(StringUtils.toString((long)i, (int)2));
                    sb.append(':');
                    millis -= i * 60L * 1000L;
                }
                i = millis / 1000L;
                if (sb.length() <= 0) {
                    sb.append(i);
                    suffix = "s";
                } else {
                    sb.append(StringUtils.toString((long)i, (int)2));
                    suffix = "";
                }
                if ((millis -= i * 1000L) > 0L) {
                    sb.append('.');
                    sb.append(StringUtils.toString((long)millis, (int)3));
                }
                sb.append(suffix);
                ret = sb.toString();
            }
        }
        return ret;
    }

    public void setDurationString(String duration) {
        if (duration == null) {
            this._duration = null;
        } else {
            String str = duration.trim();
            if (str.equalsIgnoreCase("media")) {
                this._duration = null;
            } else if (INDEFINITE.equalsIgnoreCase(str)) {
                this._duration = Long.MAX_VALUE;
            } else {
                long hours = 0L;
                long minutes = 0L;
                long seconds = 0L;
                long millis = 0L;
                String[] array = str.split(":");
                switch (array.length) {
                    case 3: {
                        hours = Long.parseLong(array[0]);
                        if (hours < 0L) {
                            throw new IllegalArgumentException("Negative hours");
                        }
                        minutes = Long.parseLong(array[1]);
                        if (minutes < 0L || minutes > 59L) {
                            throw new IllegalArgumentException("Invalid minutes");
                        }
                        String[] subArray = array[2].split("\\.");
                        if (subArray.length > 2) {
                            throw new IllegalArgumentException("Invalid duration format " + str);
                        }
                        seconds = Long.parseLong(subArray[0]);
                        if (seconds < 0L || seconds > 59L) {
                            throw new IllegalArgumentException("Invalid seconds");
                        }
                        if (subArray.length <= 1) break;
                        StringBuilder sb = new StringBuilder(subArray[1]);
                        switch (sb.length()) {
                            case 1: {
                                sb.append("00");
                                break;
                            }
                            case 2: {
                                sb.append('0');
                                break;
                            }
                            case 3: {
                                break;
                            }
                            default: {
                                sb.delete(3, sb.length());
                            }
                        }
                        millis = Long.parseLong(sb.toString());
                        if (millis >= 0L) break;
                        throw new IllegalArgumentException("Negative milliseconds");
                    }
                    case 2: {
                        minutes = Long.parseLong(array[0]);
                        if (minutes < 0L || minutes > 59L) {
                            throw new IllegalArgumentException("Invalid minutes");
                        }
                        String[] subArray = array[1].split("\\.");
                        if (subArray.length > 2) {
                            throw new IllegalArgumentException("Invalid duration format " + str);
                        }
                        seconds = Long.parseLong(subArray[0]);
                        if (seconds < 0L || seconds > 59L) {
                            throw new IllegalArgumentException("Invalid seconds");
                        }
                        if (subArray.length <= 1) break;
                        StringBuilder sb = new StringBuilder(subArray[1]);
                        switch (sb.length()) {
                            case 1: {
                                sb.append("00");
                                break;
                            }
                            case 2: {
                                sb.append('0');
                                break;
                            }
                            case 3: {
                                break;
                            }
                            default: {
                                sb.delete(3, sb.length());
                            }
                        }
                        millis = Long.parseLong(sb.toString());
                        if (millis >= 0L) break;
                        throw new IllegalArgumentException("Negative milliseconds");
                    }
                    case 1: {
                        String input = array[0].toLowerCase();
                        float multiplier = 1000.0f;
                        if (input.endsWith("h")) {
                            input = input.substring(0, input.length() - 1);
                            multiplier = 3600000.0f;
                        } else if (input.endsWith("min")) {
                            input = input.substring(0, input.length() - 3);
                            multiplier = 60000.0f;
                        } else if (input.endsWith("ms")) {
                            input = input.substring(0, input.length() - 2);
                            multiplier = 1.0f;
                        } else if (input.endsWith("s")) {
                            input = input.substring(0, input.length() - 1);
                        }
                        float f = Float.parseFloat(input);
                        millis = (long)(f *= multiplier);
                        if (millis >= 0L) break;
                        throw new IllegalArgumentException("Negative time");
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid SMIL duration format " + str);
                    }
                }
                this._duration = hours * 60L * 60L * 1000L + minutes * 60L * 1000L + seconds * 1000L + millis;
            }
        }
    }

    public String getBeginString() {
        return this._begin;
    }

    public void setBeginString(String begin) {
        this._begin = StringUtils.normalize((String)begin);
    }

    public String getEnd() {
        return this._end;
    }

    public void setEnd(String end) {
        this._end = StringUtils.normalize((String)end);
    }

    public String getMin() {
        return this._min;
    }

    public void setMin(String min) {
        this._min = StringUtils.normalize((String)min);
    }

    public String getMax() {
        return this._max;
    }

    public void setMax(String max) {
        this._max = StringUtils.normalize((String)max);
    }

    public abstract void acceptDown(SmilVisitor var1);
}

