/*
 * Decompiled with CFR 0.152.
 */
package chameleon.playlist.xspf;

import chameleon.lang.StringUtils;
import chameleon.playlist.xspf.Attribution;
import chameleon.playlist.xspf.Link;
import chameleon.playlist.xspf.Meta;
import java.util.ArrayList;
import java.util.List;
import org.exolab.castor.types.AnyNode;

public class Track
extends Attribution {
    private String _title = null;
    private String _creator = null;
    private String _annotation = null;
    private String _info = null;
    private String _image = null;
    private String _album = null;
    private Integer _trackNum = null;
    private Integer _duration = null;
    private final List<Link> _links = new ArrayList<Link>();
    private final List<Meta> _metas = new ArrayList<Meta>();
    private final List<AnyNode> _extensions = new ArrayList<AnyNode>();

    public String getTitle() {
        return this._title;
    }

    public void setTitle(String title) {
        this._title = StringUtils.normalize((String)title);
    }

    public String getCreator() {
        return this._creator;
    }

    public void setCreator(String creator) {
        this._creator = StringUtils.normalize((String)creator);
    }

    public String getAnnotation() {
        return this._annotation;
    }

    public void setAnnotation(String annotation) {
        this._annotation = StringUtils.normalize((String)annotation);
    }

    public String getInfo() {
        return this._info;
    }

    public void setInfo(String info) {
        this._info = StringUtils.normalize((String)info);
    }

    public String getImage() {
        return this._image;
    }

    public void setImage(String image) {
        this._image = StringUtils.normalize((String)image);
    }

    public String getAlbum() {
        return this._album;
    }

    public void setAlbum(String album) {
        this._album = StringUtils.normalize((String)album);
    }

    public Integer getTrackNumber() {
        return this._trackNum;
    }

    public void setTrackNumber(Integer trackNum) {
        if (trackNum != null && trackNum <= 0) {
            throw new IllegalArgumentException("Negative or null track number");
        }
        this._trackNum = trackNum;
    }

    public Integer getDuration() {
        return this._duration;
    }

    public void setDuration(Integer duration) {
        if (duration != null && duration <= 0) {
            throw new IllegalArgumentException("Negative or null duration");
        }
        this._duration = duration;
    }

    public void setDuration(int duration) {
        if (duration <= 0) {
            throw new IllegalArgumentException("Negative or null duration");
        }
        this._duration = duration;
    }

    public List<AnyNode> getExtensions() {
        return this._extensions;
    }

    public void addExtension(Object extension) {
        if (!(extension instanceof AnyNode)) {
            throw new IllegalArgumentException(AnyNode.class + " expected");
        }
        AnyNode anyNode = (AnyNode)extension;
        AnyNode attr = anyNode.getFirstAttribute();
        if (attr == null) {
            throw new IllegalArgumentException("No application attribute");
        }
        if (!"application".equals(attr.getLocalName())) {
            throw new IllegalArgumentException("Unknown attribute");
        }
        this._extensions.add(anyNode);
    }

    public void addLink(Link link) {
        if (link == null) {
            throw new NullPointerException("no link");
        }
        this._links.add(link);
    }

    public List<Link> getLinks() {
        return this._links;
    }

    public void addMeta(Meta meta) {
        if (meta == null) {
            throw new NullPointerException("no meta");
        }
        this._metas.add(meta);
    }

    public List<Meta> getMetas() {
        return this._metas;
    }
}

