/*
 * Decompiled with CFR 0.152.
 */
package chameleon.playlist.xspf;

import chameleon.content.type.ContentType;
import chameleon.io.IOUtils;
import chameleon.player.PlayerSupport;
import chameleon.playlist.AbstractPlaylistComponent;
import chameleon.playlist.Media;
import chameleon.playlist.Parallel;
import chameleon.playlist.Playlist;
import chameleon.playlist.Sequence;
import chameleon.playlist.SpecificPlaylist;
import chameleon.playlist.SpecificPlaylistProvider;
import chameleon.playlist.xspf.Location;
import chameleon.playlist.xspf.Track;
import chameleon.xml.XmlSerializer;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import org.apache.commons.logging.Log;

public class XspfProvider
implements SpecificPlaylistProvider {
    private static final ContentType[] FILETYPES = new ContentType[]{new ContentType(new String[]{".xspf"}, new String[]{"application/xspf+xml"}, new PlayerSupport[]{new PlayerSupport(PlayerSupport.Player.VLC_MEDIA_PLAYER, true, null)}, "XML Shareable Playlist Format (XSPF)")};

    public String getId() {
        return "xspf";
    }

    public ContentType[] getContentTypes() {
        return (ContentType[])FILETYPES.clone();
    }

    public SpecificPlaylist readFrom(InputStream in, String encoding, Log logger) throws Exception {
        String enc = encoding;
        if (enc == null) {
            enc = "UTF-8";
        }
        String str = IOUtils.toString((InputStream)in, (String)enc);
        str = str.replace("&", "&amp;");
        str = str.replaceAll("&amp;([a-zA-Z0-9#]+;)", "&$1");
        XmlSerializer serializer = XmlSerializer.getMapping((String)"chameleon/playlist/xspf");
        serializer.getUnmarshaller().setIgnoreExtraElements(true);
        StringReader reader = new StringReader(str);
        SpecificPlaylist ret = (SpecificPlaylist)serializer.unmarshal((Reader)reader);
        ret.setProvider((SpecificPlaylistProvider)this);
        return ret;
    }

    public SpecificPlaylist toSpecificPlaylist(Playlist playlist) throws Exception {
        chameleon.playlist.xspf.Playlist ret = new chameleon.playlist.xspf.Playlist();
        ret.setProvider(this);
        this.addToPlaylist(ret, (AbstractPlaylistComponent)playlist.getRootSequence());
        return ret;
    }

    private void addToPlaylist(chameleon.playlist.xspf.Playlist playlist, AbstractPlaylistComponent component) throws Exception {
        block10: {
            block9: {
                if (!(component instanceof Sequence)) break block9;
                Sequence sequence = (Sequence)component;
                if (sequence.getRepeatCount() < 0) {
                    throw new IllegalArgumentException("An XSPF playlist cannot handle a sequence repeated indefinitely");
                }
                AbstractPlaylistComponent[] components = sequence.getComponents();
                for (int iter = 0; iter < sequence.getRepeatCount(); ++iter) {
                    for (AbstractPlaylistComponent c : components) {
                        this.addToPlaylist(playlist, c);
                    }
                }
                break block10;
            }
            if (component instanceof Parallel) {
                throw new IllegalArgumentException("An XSPF playlist cannot play different media at the same time");
            }
            if (!(component instanceof Media)) break block10;
            Media media = (Media)component;
            if (media.getDuration() != null) {
                throw new IllegalArgumentException("An XSPF playlist cannot handle a timed media");
            }
            if (media.getRepeatCount() < 0) {
                throw new IllegalArgumentException("An XSPF playlist cannot handle a media repeated indefinitely");
            }
            if (media.getSource() != null) {
                for (int iter = 0; iter < media.getRepeatCount(); ++iter) {
                    Track track = new Track();
                    Location location = new Location();
                    location.setText(media.getSource().toString());
                    track.addStringContainer(location);
                    if (media.getSource().getDuration() > 0L) {
                        track.setDuration((int)media.getSource().getDuration());
                    }
                    playlist.addTrack(track);
                }
            }
        }
    }
}

