/*
 * This class file was automatically generated by ASN1bean (http://www.beanit.com)
 */

package com.beanit.iec61850bean.internal.mms.asn1;

import com.beanit.asn1bean.ber.BerLength;
import com.beanit.asn1bean.ber.BerTag;
import com.beanit.asn1bean.ber.ReverseByteArrayOutputStream;
import com.beanit.asn1bean.ber.types.BerType;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;

public class FileDirectoryRequest implements BerType, Serializable {

    public static final BerTag tag = new BerTag(BerTag.UNIVERSAL_CLASS, BerTag.CONSTRUCTED, 16);
    private static final long serialVersionUID = 1L;
    private byte[] code = null;
    private FileName fileSpecification = null;
    private FileName continueAfter = null;

    public FileDirectoryRequest() {
    }

    public FileDirectoryRequest(byte[] code) {
        this.code = code;
    }

    public FileName getFileSpecification() {
        return fileSpecification;
    }

    public void setFileSpecification(FileName fileSpecification) {
        this.fileSpecification = fileSpecification;
    }

    public FileName getContinueAfter() {
        return continueAfter;
    }

    public void setContinueAfter(FileName continueAfter) {
        this.continueAfter = continueAfter;
    }

    @Override
    public int encode(OutputStream reverseOS) throws IOException {
        return encode(reverseOS, true);
    }

    public int encode(OutputStream reverseOS, boolean withTag) throws IOException {

        if (code != null) {
            reverseOS.write(code);
            if (withTag) {
                return tag.encode(reverseOS) + code.length;
            }
            return code.length;
        }

        int codeLength = 0;
        if (continueAfter != null) {
            codeLength += continueAfter.encode(reverseOS, false);
            // write tag: CONTEXT_CLASS, CONSTRUCTED, 1
            reverseOS.write(0xA1);
            codeLength += 1;
        }

        if (fileSpecification != null) {
            codeLength += fileSpecification.encode(reverseOS, false);
            // write tag: CONTEXT_CLASS, CONSTRUCTED, 0
            reverseOS.write(0xA0);
            codeLength += 1;
        }

        codeLength += BerLength.encodeLength(reverseOS, codeLength);

        if (withTag) {
            codeLength += tag.encode(reverseOS);
        }

        return codeLength;
    }

    @Override
    public int decode(InputStream is) throws IOException {
        return decode(is, true);
    }

    public int decode(InputStream is, boolean withTag) throws IOException {
        int tlByteCount = 0;
        int vByteCount = 0;
        BerTag berTag = new BerTag();

        if (withTag) {
            tlByteCount += tag.decodeAndCheck(is);
        }

        BerLength length = new BerLength();
        tlByteCount += length.decode(is);
        int lengthVal = length.val;
        if (lengthVal == 0) {
            return tlByteCount;
        }
        vByteCount += berTag.decode(is);

        if (berTag.equals(BerTag.CONTEXT_CLASS, BerTag.CONSTRUCTED, 0)) {
            fileSpecification = new FileName();
            vByteCount += fileSpecification.decode(is, false);
            if (lengthVal >= 0 && vByteCount == lengthVal) {
                return tlByteCount + vByteCount;
            }
            vByteCount += berTag.decode(is);
        }

        if (berTag.equals(BerTag.CONTEXT_CLASS, BerTag.CONSTRUCTED, 1)) {
            continueAfter = new FileName();
            vByteCount += continueAfter.decode(is, false);
            if (lengthVal >= 0 && vByteCount == lengthVal) {
                return tlByteCount + vByteCount;
            }
            vByteCount += berTag.decode(is);
        }

        if (lengthVal < 0) {
            if (!berTag.equals(0, 0, 0)) {
                throw new IOException("Decoded sequence has wrong end of contents octets");
            }
            vByteCount += BerLength.readEocByte(is);
            return tlByteCount + vByteCount;
        }

        throw new IOException(
                "Unexpected end of sequence, length tag: " + lengthVal + ", bytes decoded: " + vByteCount);
    }

    public void encodeAndSave(int encodingSizeGuess) throws IOException {
        ReverseByteArrayOutputStream reverseOS = new ReverseByteArrayOutputStream(encodingSizeGuess);
        encode(reverseOS, false);
        code = reverseOS.getArray();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        appendAsString(sb, 0);
        return sb.toString();
    }

    public void appendAsString(StringBuilder sb, int indentLevel) {

        sb.append("{");
        boolean firstSelectedElement = true;
        if (fileSpecification != null) {
            sb.append("\n");
            for (int i = 0; i < indentLevel + 1; i++) {
                sb.append("\t");
            }
            sb.append("fileSpecification: ");
            fileSpecification.appendAsString(sb, indentLevel + 1);
            firstSelectedElement = false;
        }

        if (continueAfter != null) {
            if (!firstSelectedElement) {
                sb.append(",\n");
            }
            for (int i = 0; i < indentLevel + 1; i++) {
                sb.append("\t");
            }
            sb.append("continueAfter: ");
            continueAfter.appendAsString(sb, indentLevel + 1);
            firstSelectedElement = false;
        }

        sb.append("\n");
        for (int i = 0; i < indentLevel; i++) {
            sb.append("\t");
        }
        sb.append("}");
    }
}
