/*
 * This class file was automatically generated by ASN1bean (http://www.beanit.com)
 */

package com.beanit.iec61850bean.internal.mms.asn1;

import com.beanit.asn1bean.ber.BerLength;
import com.beanit.asn1bean.ber.BerTag;
import com.beanit.asn1bean.ber.ReverseByteArrayOutputStream;
import com.beanit.asn1bean.ber.types.BerType;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;

public class GetVariableAccessAttributesRequest implements BerType, Serializable {

    private static final long serialVersionUID = 1L;

    private byte[] code = null;
    private ObjectName name = null;

    public GetVariableAccessAttributesRequest() {
    }

    public GetVariableAccessAttributesRequest(byte[] code) {
        this.code = code;
    }

    public ObjectName getName() {
        return name;
    }

    public void setName(ObjectName name) {
        this.name = name;
    }

    @Override
    public int encode(OutputStream reverseOS) throws IOException {

        if (code != null) {
            reverseOS.write(code);
            return code.length;
        }

        int codeLength = 0;
        int sublength;

        if (name != null) {
            sublength = name.encode(reverseOS);
            codeLength += sublength;
            codeLength += BerLength.encodeLength(reverseOS, sublength);
            // write tag: CONTEXT_CLASS, CONSTRUCTED, 0
            reverseOS.write(0xA0);
            codeLength += 1;
            return codeLength;
        }

        throw new IOException("Error encoding CHOICE: No element of CHOICE was selected.");
    }

    @Override
    public int decode(InputStream is) throws IOException {
        return decode(is, null);
    }

    public int decode(InputStream is, BerTag berTag) throws IOException {

        int tlvByteCount = 0;
        boolean tagWasPassed = (berTag != null);

        if (berTag == null) {
            berTag = new BerTag();
            tlvByteCount += berTag.decode(is);
        }

        if (berTag.equals(BerTag.CONTEXT_CLASS, BerTag.CONSTRUCTED, 0)) {
            BerLength length = new BerLength();
            tlvByteCount += length.decode(is);
            name = new ObjectName();
            tlvByteCount += name.decode(is, null);
            tlvByteCount += length.readEocIfIndefinite(is);
            return tlvByteCount;
        }

        if (tagWasPassed) {
            return 0;
        }

        throw new IOException("Error decoding CHOICE: Tag " + berTag + " matched to no item.");
    }

    public void encodeAndSave(int encodingSizeGuess) throws IOException {
        ReverseByteArrayOutputStream reverseOS = new ReverseByteArrayOutputStream(encodingSizeGuess);
        encode(reverseOS);
        code = reverseOS.getArray();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        appendAsString(sb, 0);
        return sb.toString();
    }

    public void appendAsString(StringBuilder sb, int indentLevel) {

        if (name != null) {
            sb.append("name: ");
            name.appendAsString(sb, indentLevel + 1);
            return;
        }

        sb.append("<none>");
    }
}
