/*
 * This class file was automatically generated by ASN1bean (http://www.beanit.com)
 */

package com.beanit.iec61850bean.internal.mms.asn1;

import com.beanit.asn1bean.ber.BerLength;
import com.beanit.asn1bean.ber.BerTag;
import com.beanit.asn1bean.ber.ReverseByteArrayOutputStream;
import com.beanit.asn1bean.ber.types.BerType;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;

public class InitiateRequestPDU implements BerType, Serializable {

    public static final BerTag tag = new BerTag(BerTag.UNIVERSAL_CLASS, BerTag.CONSTRUCTED, 16);
    private static final long serialVersionUID = 1L;
    private byte[] code = null;
    private Integer32 localDetailCalling = null;
    private Integer16 proposedMaxServOutstandingCalling = null;
    private Integer16 proposedMaxServOutstandingCalled = null;
    private Integer8 proposedDataStructureNestingLevel = null;
    private InitRequestDetail initRequestDetail = null;

    public InitiateRequestPDU() {
    }

    public InitiateRequestPDU(byte[] code) {
        this.code = code;
    }

    public Integer32 getLocalDetailCalling() {
        return localDetailCalling;
    }

    public void setLocalDetailCalling(Integer32 localDetailCalling) {
        this.localDetailCalling = localDetailCalling;
    }

    public Integer16 getProposedMaxServOutstandingCalling() {
        return proposedMaxServOutstandingCalling;
    }

    public void setProposedMaxServOutstandingCalling(Integer16 proposedMaxServOutstandingCalling) {
        this.proposedMaxServOutstandingCalling = proposedMaxServOutstandingCalling;
    }

    public Integer16 getProposedMaxServOutstandingCalled() {
        return proposedMaxServOutstandingCalled;
    }

    public void setProposedMaxServOutstandingCalled(Integer16 proposedMaxServOutstandingCalled) {
        this.proposedMaxServOutstandingCalled = proposedMaxServOutstandingCalled;
    }

    public Integer8 getProposedDataStructureNestingLevel() {
        return proposedDataStructureNestingLevel;
    }

    public void setProposedDataStructureNestingLevel(Integer8 proposedDataStructureNestingLevel) {
        this.proposedDataStructureNestingLevel = proposedDataStructureNestingLevel;
    }

    public InitRequestDetail getInitRequestDetail() {
        return initRequestDetail;
    }

    public void setInitRequestDetail(InitRequestDetail initRequestDetail) {
        this.initRequestDetail = initRequestDetail;
    }

    @Override
    public int encode(OutputStream reverseOS) throws IOException {
        return encode(reverseOS, true);
    }

    public int encode(OutputStream reverseOS, boolean withTag) throws IOException {

        if (code != null) {
            reverseOS.write(code);
            if (withTag) {
                return tag.encode(reverseOS) + code.length;
            }
            return code.length;
        }

        int codeLength = 0;
        codeLength += initRequestDetail.encode(reverseOS, false);
        // write tag: CONTEXT_CLASS, CONSTRUCTED, 4
        reverseOS.write(0xA4);
        codeLength += 1;

        if (proposedDataStructureNestingLevel != null) {
            codeLength += proposedDataStructureNestingLevel.encode(reverseOS, false);
            // write tag: CONTEXT_CLASS, PRIMITIVE, 3
            reverseOS.write(0x83);
            codeLength += 1;
        }

        codeLength += proposedMaxServOutstandingCalled.encode(reverseOS, false);
        // write tag: CONTEXT_CLASS, PRIMITIVE, 2
        reverseOS.write(0x82);
        codeLength += 1;

        codeLength += proposedMaxServOutstandingCalling.encode(reverseOS, false);
        // write tag: CONTEXT_CLASS, PRIMITIVE, 1
        reverseOS.write(0x81);
        codeLength += 1;

        if (localDetailCalling != null) {
            codeLength += localDetailCalling.encode(reverseOS, false);
            // write tag: CONTEXT_CLASS, PRIMITIVE, 0
            reverseOS.write(0x80);
            codeLength += 1;
        }

        codeLength += BerLength.encodeLength(reverseOS, codeLength);

        if (withTag) {
            codeLength += tag.encode(reverseOS);
        }

        return codeLength;
    }

    @Override
    public int decode(InputStream is) throws IOException {
        return decode(is, true);
    }

    public int decode(InputStream is, boolean withTag) throws IOException {
        int tlByteCount = 0;
        int vByteCount = 0;
        BerTag berTag = new BerTag();

        if (withTag) {
            tlByteCount += tag.decodeAndCheck(is);
        }

        BerLength length = new BerLength();
        tlByteCount += length.decode(is);
        int lengthVal = length.val;
        vByteCount += berTag.decode(is);

        if (berTag.equals(BerTag.CONTEXT_CLASS, BerTag.PRIMITIVE, 0)) {
            localDetailCalling = new Integer32();
            vByteCount += localDetailCalling.decode(is, false);
            vByteCount += berTag.decode(is);
        }

        if (berTag.equals(BerTag.CONTEXT_CLASS, BerTag.PRIMITIVE, 1)) {
            proposedMaxServOutstandingCalling = new Integer16();
            vByteCount += proposedMaxServOutstandingCalling.decode(is, false);
            vByteCount += berTag.decode(is);
        } else {
            throw new IOException("Tag does not match mandatory sequence component.");
        }

        if (berTag.equals(BerTag.CONTEXT_CLASS, BerTag.PRIMITIVE, 2)) {
            proposedMaxServOutstandingCalled = new Integer16();
            vByteCount += proposedMaxServOutstandingCalled.decode(is, false);
            vByteCount += berTag.decode(is);
        } else {
            throw new IOException("Tag does not match mandatory sequence component.");
        }

        if (berTag.equals(BerTag.CONTEXT_CLASS, BerTag.PRIMITIVE, 3)) {
            proposedDataStructureNestingLevel = new Integer8();
            vByteCount += proposedDataStructureNestingLevel.decode(is, false);
            vByteCount += berTag.decode(is);
        }

        if (berTag.equals(BerTag.CONTEXT_CLASS, BerTag.CONSTRUCTED, 4)) {
            initRequestDetail = new InitRequestDetail();
            vByteCount += initRequestDetail.decode(is, false);
            if (lengthVal >= 0 && vByteCount == lengthVal) {
                return tlByteCount + vByteCount;
            }
            vByteCount += berTag.decode(is);
        } else {
            throw new IOException("Tag does not match mandatory sequence component.");
        }

        if (lengthVal < 0) {
            if (!berTag.equals(0, 0, 0)) {
                throw new IOException("Decoded sequence has wrong end of contents octets");
            }
            vByteCount += BerLength.readEocByte(is);
            return tlByteCount + vByteCount;
        }

        throw new IOException(
                "Unexpected end of sequence, length tag: " + lengthVal + ", bytes decoded: " + vByteCount);
    }

    public void encodeAndSave(int encodingSizeGuess) throws IOException {
        ReverseByteArrayOutputStream reverseOS = new ReverseByteArrayOutputStream(encodingSizeGuess);
        encode(reverseOS, false);
        code = reverseOS.getArray();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        appendAsString(sb, 0);
        return sb.toString();
    }

    public void appendAsString(StringBuilder sb, int indentLevel) {

        sb.append("{");
        boolean firstSelectedElement = true;
        if (localDetailCalling != null) {
            sb.append("\n");
            for (int i = 0; i < indentLevel + 1; i++) {
                sb.append("\t");
            }
            sb.append("localDetailCalling: ").append(localDetailCalling);
            firstSelectedElement = false;
        }

        if (!firstSelectedElement) {
            sb.append(",\n");
        }
        for (int i = 0; i < indentLevel + 1; i++) {
            sb.append("\t");
        }
        if (proposedMaxServOutstandingCalling != null) {
            sb.append("proposedMaxServOutstandingCalling: ").append(proposedMaxServOutstandingCalling);
        } else {
            sb.append("proposedMaxServOutstandingCalling: <empty-required-field>");
        }

        sb.append(",\n");
        for (int i = 0; i < indentLevel + 1; i++) {
            sb.append("\t");
        }
        if (proposedMaxServOutstandingCalled != null) {
            sb.append("proposedMaxServOutstandingCalled: ").append(proposedMaxServOutstandingCalled);
        } else {
            sb.append("proposedMaxServOutstandingCalled: <empty-required-field>");
        }

        if (proposedDataStructureNestingLevel != null) {
            sb.append(",\n");
            for (int i = 0; i < indentLevel + 1; i++) {
                sb.append("\t");
            }
            sb.append("proposedDataStructureNestingLevel: ").append(proposedDataStructureNestingLevel);
        }

        sb.append(",\n");
        for (int i = 0; i < indentLevel + 1; i++) {
            sb.append("\t");
        }
        if (initRequestDetail != null) {
            sb.append("initRequestDetail: ");
            initRequestDetail.appendAsString(sb, indentLevel + 1);
        } else {
            sb.append("initRequestDetail: <empty-required-field>");
        }

        sb.append("\n");
        for (int i = 0; i < indentLevel; i++) {
            sb.append("\t");
        }
        sb.append("}");
    }

    public static class InitRequestDetail implements BerType, Serializable {

        public static final BerTag tag = new BerTag(BerTag.UNIVERSAL_CLASS, BerTag.CONSTRUCTED, 16);
        private static final long serialVersionUID = 1L;
        private byte[] code = null;
        private Integer16 proposedVersionNumber = null;
        private ParameterSupportOptions proposedParameterCBB = null;
        private ServiceSupportOptions servicesSupportedCalling = null;

        public InitRequestDetail() {
        }

        public InitRequestDetail(byte[] code) {
            this.code = code;
        }

        public Integer16 getProposedVersionNumber() {
            return proposedVersionNumber;
        }

        public void setProposedVersionNumber(Integer16 proposedVersionNumber) {
            this.proposedVersionNumber = proposedVersionNumber;
        }

        public ParameterSupportOptions getProposedParameterCBB() {
            return proposedParameterCBB;
        }

        public void setProposedParameterCBB(ParameterSupportOptions proposedParameterCBB) {
            this.proposedParameterCBB = proposedParameterCBB;
        }

        public ServiceSupportOptions getServicesSupportedCalling() {
            return servicesSupportedCalling;
        }

        public void setServicesSupportedCalling(ServiceSupportOptions servicesSupportedCalling) {
            this.servicesSupportedCalling = servicesSupportedCalling;
        }

        @Override
        public int encode(OutputStream reverseOS) throws IOException {
            return encode(reverseOS, true);
        }

        public int encode(OutputStream reverseOS, boolean withTag) throws IOException {

            if (code != null) {
                reverseOS.write(code);
                if (withTag) {
                    return tag.encode(reverseOS) + code.length;
                }
                return code.length;
            }

            int codeLength = 0;
            codeLength += servicesSupportedCalling.encode(reverseOS, false);
            // write tag: CONTEXT_CLASS, PRIMITIVE, 2
            reverseOS.write(0x82);
            codeLength += 1;

            codeLength += proposedParameterCBB.encode(reverseOS, false);
            // write tag: CONTEXT_CLASS, PRIMITIVE, 1
            reverseOS.write(0x81);
            codeLength += 1;

            codeLength += proposedVersionNumber.encode(reverseOS, false);
            // write tag: CONTEXT_CLASS, PRIMITIVE, 0
            reverseOS.write(0x80);
            codeLength += 1;

            codeLength += BerLength.encodeLength(reverseOS, codeLength);

            if (withTag) {
                codeLength += tag.encode(reverseOS);
            }

            return codeLength;
        }

        @Override
        public int decode(InputStream is) throws IOException {
            return decode(is, true);
        }

        public int decode(InputStream is, boolean withTag) throws IOException {
            int tlByteCount = 0;
            int vByteCount = 0;
            BerTag berTag = new BerTag();

            if (withTag) {
                tlByteCount += tag.decodeAndCheck(is);
            }

            BerLength length = new BerLength();
            tlByteCount += length.decode(is);
            int lengthVal = length.val;
            vByteCount += berTag.decode(is);

            if (berTag.equals(BerTag.CONTEXT_CLASS, BerTag.PRIMITIVE, 0)) {
                proposedVersionNumber = new Integer16();
                vByteCount += proposedVersionNumber.decode(is, false);
                vByteCount += berTag.decode(is);
            } else {
                throw new IOException("Tag does not match mandatory sequence component.");
            }

            if (berTag.equals(BerTag.CONTEXT_CLASS, BerTag.PRIMITIVE, 1)) {
                proposedParameterCBB = new ParameterSupportOptions();
                vByteCount += proposedParameterCBB.decode(is, false);
                vByteCount += berTag.decode(is);
            } else {
                throw new IOException("Tag does not match mandatory sequence component.");
            }

            if (berTag.equals(BerTag.CONTEXT_CLASS, BerTag.PRIMITIVE, 2)) {
                servicesSupportedCalling = new ServiceSupportOptions();
                vByteCount += servicesSupportedCalling.decode(is, false);
                if (lengthVal >= 0 && vByteCount == lengthVal) {
                    return tlByteCount + vByteCount;
                }
                vByteCount += berTag.decode(is);
            } else {
                throw new IOException("Tag does not match mandatory sequence component.");
            }

            if (lengthVal < 0) {
                if (!berTag.equals(0, 0, 0)) {
                    throw new IOException("Decoded sequence has wrong end of contents octets");
                }
                vByteCount += BerLength.readEocByte(is);
                return tlByteCount + vByteCount;
            }

            throw new IOException(
                    "Unexpected end of sequence, length tag: "
                            + lengthVal
                            + ", bytes decoded: "
                            + vByteCount);
        }

        public void encodeAndSave(int encodingSizeGuess) throws IOException {
            ReverseByteArrayOutputStream reverseOS = new ReverseByteArrayOutputStream(encodingSizeGuess);
            encode(reverseOS, false);
            code = reverseOS.getArray();
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            appendAsString(sb, 0);
            return sb.toString();
        }

        public void appendAsString(StringBuilder sb, int indentLevel) {

            sb.append("{");
            sb.append("\n");
            for (int i = 0; i < indentLevel + 1; i++) {
                sb.append("\t");
            }
            if (proposedVersionNumber != null) {
                sb.append("proposedVersionNumber: ").append(proposedVersionNumber);
            } else {
                sb.append("proposedVersionNumber: <empty-required-field>");
            }

            sb.append(",\n");
            for (int i = 0; i < indentLevel + 1; i++) {
                sb.append("\t");
            }
            if (proposedParameterCBB != null) {
                sb.append("proposedParameterCBB: ").append(proposedParameterCBB);
            } else {
                sb.append("proposedParameterCBB: <empty-required-field>");
            }

            sb.append(",\n");
            for (int i = 0; i < indentLevel + 1; i++) {
                sb.append("\t");
            }
            if (servicesSupportedCalling != null) {
                sb.append("servicesSupportedCalling: ").append(servicesSupportedCalling);
            } else {
                sb.append("servicesSupportedCalling: <empty-required-field>");
            }

            sb.append("\n");
            for (int i = 0; i < indentLevel; i++) {
                sb.append("\t");
            }
            sb.append("}");
        }
    }
}
