/*
 * This class file was automatically generated by ASN1bean (http://www.beanit.com)
 */

package com.beanit.iec61850bean.internal.mms.asn1;

import com.beanit.asn1bean.ber.BerLength;
import com.beanit.asn1bean.ber.BerTag;
import com.beanit.asn1bean.ber.ReverseByteArrayOutputStream;
import com.beanit.asn1bean.ber.types.BerType;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;

public class InitiateResponsePDU implements BerType, Serializable {

    public static final BerTag tag = new BerTag(BerTag.UNIVERSAL_CLASS, BerTag.CONSTRUCTED, 16);
    private static final long serialVersionUID = 1L;
    private byte[] code = null;
    private Integer32 localDetailCalled = null;
    private Integer16 negotiatedMaxServOutstandingCalling = null;
    private Integer16 negotiatedMaxServOutstandingCalled = null;
    private Integer8 negotiatedDataStructureNestingLevel = null;
    private InitResponseDetail initResponseDetail = null;

    public InitiateResponsePDU() {
    }

    public InitiateResponsePDU(byte[] code) {
        this.code = code;
    }

    public Integer32 getLocalDetailCalled() {
        return localDetailCalled;
    }

    public void setLocalDetailCalled(Integer32 localDetailCalled) {
        this.localDetailCalled = localDetailCalled;
    }

    public Integer16 getNegotiatedMaxServOutstandingCalling() {
        return negotiatedMaxServOutstandingCalling;
    }

    public void setNegotiatedMaxServOutstandingCalling(
            Integer16 negotiatedMaxServOutstandingCalling) {
        this.negotiatedMaxServOutstandingCalling = negotiatedMaxServOutstandingCalling;
    }

    public Integer16 getNegotiatedMaxServOutstandingCalled() {
        return negotiatedMaxServOutstandingCalled;
    }

    public void setNegotiatedMaxServOutstandingCalled(Integer16 negotiatedMaxServOutstandingCalled) {
        this.negotiatedMaxServOutstandingCalled = negotiatedMaxServOutstandingCalled;
    }

    public Integer8 getNegotiatedDataStructureNestingLevel() {
        return negotiatedDataStructureNestingLevel;
    }

    public void setNegotiatedDataStructureNestingLevel(Integer8 negotiatedDataStructureNestingLevel) {
        this.negotiatedDataStructureNestingLevel = negotiatedDataStructureNestingLevel;
    }

    public InitResponseDetail getInitResponseDetail() {
        return initResponseDetail;
    }

    public void setInitResponseDetail(InitResponseDetail initResponseDetail) {
        this.initResponseDetail = initResponseDetail;
    }

    @Override
    public int encode(OutputStream reverseOS) throws IOException {
        return encode(reverseOS, true);
    }

    public int encode(OutputStream reverseOS, boolean withTag) throws IOException {

        if (code != null) {
            reverseOS.write(code);
            if (withTag) {
                return tag.encode(reverseOS) + code.length;
            }
            return code.length;
        }

        int codeLength = 0;
        codeLength += initResponseDetail.encode(reverseOS, false);
        // write tag: CONTEXT_CLASS, CONSTRUCTED, 4
        reverseOS.write(0xA4);
        codeLength += 1;

        if (negotiatedDataStructureNestingLevel != null) {
            codeLength += negotiatedDataStructureNestingLevel.encode(reverseOS, false);
            // write tag: CONTEXT_CLASS, PRIMITIVE, 3
            reverseOS.write(0x83);
            codeLength += 1;
        }

        codeLength += negotiatedMaxServOutstandingCalled.encode(reverseOS, false);
        // write tag: CONTEXT_CLASS, PRIMITIVE, 2
        reverseOS.write(0x82);
        codeLength += 1;

        codeLength += negotiatedMaxServOutstandingCalling.encode(reverseOS, false);
        // write tag: CONTEXT_CLASS, PRIMITIVE, 1
        reverseOS.write(0x81);
        codeLength += 1;

        if (localDetailCalled != null) {
            codeLength += localDetailCalled.encode(reverseOS, false);
            // write tag: CONTEXT_CLASS, PRIMITIVE, 0
            reverseOS.write(0x80);
            codeLength += 1;
        }

        codeLength += BerLength.encodeLength(reverseOS, codeLength);

        if (withTag) {
            codeLength += tag.encode(reverseOS);
        }

        return codeLength;
    }

    @Override
    public int decode(InputStream is) throws IOException {
        return decode(is, true);
    }

    public int decode(InputStream is, boolean withTag) throws IOException {
        int tlByteCount = 0;
        int vByteCount = 0;
        BerTag berTag = new BerTag();

        if (withTag) {
            tlByteCount += tag.decodeAndCheck(is);
        }

        BerLength length = new BerLength();
        tlByteCount += length.decode(is);
        int lengthVal = length.val;
        vByteCount += berTag.decode(is);

        if (berTag.equals(BerTag.CONTEXT_CLASS, BerTag.PRIMITIVE, 0)) {
            localDetailCalled = new Integer32();
            vByteCount += localDetailCalled.decode(is, false);
            vByteCount += berTag.decode(is);
        }

        if (berTag.equals(BerTag.CONTEXT_CLASS, BerTag.PRIMITIVE, 1)) {
            negotiatedMaxServOutstandingCalling = new Integer16();
            vByteCount += negotiatedMaxServOutstandingCalling.decode(is, false);
            vByteCount += berTag.decode(is);
        } else {
            throw new IOException("Tag does not match mandatory sequence component.");
        }

        if (berTag.equals(BerTag.CONTEXT_CLASS, BerTag.PRIMITIVE, 2)) {
            negotiatedMaxServOutstandingCalled = new Integer16();
            vByteCount += negotiatedMaxServOutstandingCalled.decode(is, false);
            vByteCount += berTag.decode(is);
        } else {
            throw new IOException("Tag does not match mandatory sequence component.");
        }

        if (berTag.equals(BerTag.CONTEXT_CLASS, BerTag.PRIMITIVE, 3)) {
            negotiatedDataStructureNestingLevel = new Integer8();
            vByteCount += negotiatedDataStructureNestingLevel.decode(is, false);
            vByteCount += berTag.decode(is);
        }

        if (berTag.equals(BerTag.CONTEXT_CLASS, BerTag.CONSTRUCTED, 4)) {
            initResponseDetail = new InitResponseDetail();
            vByteCount += initResponseDetail.decode(is, false);
            if (lengthVal >= 0 && vByteCount == lengthVal) {
                return tlByteCount + vByteCount;
            }
            vByteCount += berTag.decode(is);
        } else {
            throw new IOException("Tag does not match mandatory sequence component.");
        }

        if (lengthVal < 0) {
            if (!berTag.equals(0, 0, 0)) {
                throw new IOException("Decoded sequence has wrong end of contents octets");
            }
            vByteCount += BerLength.readEocByte(is);
            return tlByteCount + vByteCount;
        }

        throw new IOException(
                "Unexpected end of sequence, length tag: " + lengthVal + ", bytes decoded: " + vByteCount);
    }

    public void encodeAndSave(int encodingSizeGuess) throws IOException {
        ReverseByteArrayOutputStream reverseOS = new ReverseByteArrayOutputStream(encodingSizeGuess);
        encode(reverseOS, false);
        code = reverseOS.getArray();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        appendAsString(sb, 0);
        return sb.toString();
    }

    public void appendAsString(StringBuilder sb, int indentLevel) {

        sb.append("{");
        boolean firstSelectedElement = true;
        if (localDetailCalled != null) {
            sb.append("\n");
            for (int i = 0; i < indentLevel + 1; i++) {
                sb.append("\t");
            }
            sb.append("localDetailCalled: ").append(localDetailCalled);
            firstSelectedElement = false;
        }

        if (!firstSelectedElement) {
            sb.append(",\n");
        }
        for (int i = 0; i < indentLevel + 1; i++) {
            sb.append("\t");
        }
        if (negotiatedMaxServOutstandingCalling != null) {
            sb.append("negotiatedMaxServOutstandingCalling: ")
                    .append(negotiatedMaxServOutstandingCalling);
        } else {
            sb.append("negotiatedMaxServOutstandingCalling: <empty-required-field>");
        }

        sb.append(",\n");
        for (int i = 0; i < indentLevel + 1; i++) {
            sb.append("\t");
        }
        if (negotiatedMaxServOutstandingCalled != null) {
            sb.append("negotiatedMaxServOutstandingCalled: ").append(negotiatedMaxServOutstandingCalled);
        } else {
            sb.append("negotiatedMaxServOutstandingCalled: <empty-required-field>");
        }

        if (negotiatedDataStructureNestingLevel != null) {
            sb.append(",\n");
            for (int i = 0; i < indentLevel + 1; i++) {
                sb.append("\t");
            }
            sb.append("negotiatedDataStructureNestingLevel: ")
                    .append(negotiatedDataStructureNestingLevel);
        }

        sb.append(",\n");
        for (int i = 0; i < indentLevel + 1; i++) {
            sb.append("\t");
        }
        if (initResponseDetail != null) {
            sb.append("initResponseDetail: ");
            initResponseDetail.appendAsString(sb, indentLevel + 1);
        } else {
            sb.append("initResponseDetail: <empty-required-field>");
        }

        sb.append("\n");
        for (int i = 0; i < indentLevel; i++) {
            sb.append("\t");
        }
        sb.append("}");
    }

    public static class InitResponseDetail implements BerType, Serializable {

        public static final BerTag tag = new BerTag(BerTag.UNIVERSAL_CLASS, BerTag.CONSTRUCTED, 16);
        private static final long serialVersionUID = 1L;
        private byte[] code = null;
        private Integer16 negotiatedVersionNumber = null;
        private ParameterSupportOptions negotiatedParameterCBB = null;
        private ServiceSupportOptions servicesSupportedCalled = null;

        public InitResponseDetail() {
        }

        public InitResponseDetail(byte[] code) {
            this.code = code;
        }

        public Integer16 getNegotiatedVersionNumber() {
            return negotiatedVersionNumber;
        }

        public void setNegotiatedVersionNumber(Integer16 negotiatedVersionNumber) {
            this.negotiatedVersionNumber = negotiatedVersionNumber;
        }

        public ParameterSupportOptions getNegotiatedParameterCBB() {
            return negotiatedParameterCBB;
        }

        public void setNegotiatedParameterCBB(ParameterSupportOptions negotiatedParameterCBB) {
            this.negotiatedParameterCBB = negotiatedParameterCBB;
        }

        public ServiceSupportOptions getServicesSupportedCalled() {
            return servicesSupportedCalled;
        }

        public void setServicesSupportedCalled(ServiceSupportOptions servicesSupportedCalled) {
            this.servicesSupportedCalled = servicesSupportedCalled;
        }

        @Override
        public int encode(OutputStream reverseOS) throws IOException {
            return encode(reverseOS, true);
        }

        public int encode(OutputStream reverseOS, boolean withTag) throws IOException {

            if (code != null) {
                reverseOS.write(code);
                if (withTag) {
                    return tag.encode(reverseOS) + code.length;
                }
                return code.length;
            }

            int codeLength = 0;
            codeLength += servicesSupportedCalled.encode(reverseOS, false);
            // write tag: CONTEXT_CLASS, PRIMITIVE, 2
            reverseOS.write(0x82);
            codeLength += 1;

            codeLength += negotiatedParameterCBB.encode(reverseOS, false);
            // write tag: CONTEXT_CLASS, PRIMITIVE, 1
            reverseOS.write(0x81);
            codeLength += 1;

            codeLength += negotiatedVersionNumber.encode(reverseOS, false);
            // write tag: CONTEXT_CLASS, PRIMITIVE, 0
            reverseOS.write(0x80);
            codeLength += 1;

            codeLength += BerLength.encodeLength(reverseOS, codeLength);

            if (withTag) {
                codeLength += tag.encode(reverseOS);
            }

            return codeLength;
        }

        @Override
        public int decode(InputStream is) throws IOException {
            return decode(is, true);
        }

        public int decode(InputStream is, boolean withTag) throws IOException {
            int tlByteCount = 0;
            int vByteCount = 0;
            BerTag berTag = new BerTag();

            if (withTag) {
                tlByteCount += tag.decodeAndCheck(is);
            }

            BerLength length = new BerLength();
            tlByteCount += length.decode(is);
            int lengthVal = length.val;
            vByteCount += berTag.decode(is);

            if (berTag.equals(BerTag.CONTEXT_CLASS, BerTag.PRIMITIVE, 0)) {
                negotiatedVersionNumber = new Integer16();
                vByteCount += negotiatedVersionNumber.decode(is, false);
                vByteCount += berTag.decode(is);
            } else {
                throw new IOException("Tag does not match mandatory sequence component.");
            }

            if (berTag.equals(BerTag.CONTEXT_CLASS, BerTag.PRIMITIVE, 1)) {
                negotiatedParameterCBB = new ParameterSupportOptions();
                vByteCount += negotiatedParameterCBB.decode(is, false);
                vByteCount += berTag.decode(is);
            } else {
                throw new IOException("Tag does not match mandatory sequence component.");
            }

            if (berTag.equals(BerTag.CONTEXT_CLASS, BerTag.PRIMITIVE, 2)) {
                servicesSupportedCalled = new ServiceSupportOptions();
                vByteCount += servicesSupportedCalled.decode(is, false);
                if (lengthVal >= 0 && vByteCount == lengthVal) {
                    return tlByteCount + vByteCount;
                }
                vByteCount += berTag.decode(is);
            } else {
                throw new IOException("Tag does not match mandatory sequence component.");
            }

            if (lengthVal < 0) {
                if (!berTag.equals(0, 0, 0)) {
                    throw new IOException("Decoded sequence has wrong end of contents octets");
                }
                vByteCount += BerLength.readEocByte(is);
                return tlByteCount + vByteCount;
            }

            throw new IOException(
                    "Unexpected end of sequence, length tag: "
                            + lengthVal
                            + ", bytes decoded: "
                            + vByteCount);
        }

        public void encodeAndSave(int encodingSizeGuess) throws IOException {
            ReverseByteArrayOutputStream reverseOS = new ReverseByteArrayOutputStream(encodingSizeGuess);
            encode(reverseOS, false);
            code = reverseOS.getArray();
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            appendAsString(sb, 0);
            return sb.toString();
        }

        public void appendAsString(StringBuilder sb, int indentLevel) {

            sb.append("{");
            sb.append("\n");
            for (int i = 0; i < indentLevel + 1; i++) {
                sb.append("\t");
            }
            if (negotiatedVersionNumber != null) {
                sb.append("negotiatedVersionNumber: ").append(negotiatedVersionNumber);
            } else {
                sb.append("negotiatedVersionNumber: <empty-required-field>");
            }

            sb.append(",\n");
            for (int i = 0; i < indentLevel + 1; i++) {
                sb.append("\t");
            }
            if (negotiatedParameterCBB != null) {
                sb.append("negotiatedParameterCBB: ").append(negotiatedParameterCBB);
            } else {
                sb.append("negotiatedParameterCBB: <empty-required-field>");
            }

            sb.append(",\n");
            for (int i = 0; i < indentLevel + 1; i++) {
                sb.append("\t");
            }
            if (servicesSupportedCalled != null) {
                sb.append("servicesSupportedCalled: ").append(servicesSupportedCalled);
            } else {
                sb.append("servicesSupportedCalled: <empty-required-field>");
            }

            sb.append("\n");
            for (int i = 0; i < indentLevel; i++) {
                sb.append("\t");
            }
            sb.append("}");
        }
    }
}
