/*
 * This class file was automatically generated by ASN1bean (http://www.beanit.com)
 */

package com.beanit.iec61850bean.internal.mms.asn1;

import com.beanit.asn1bean.ber.BerLength;
import com.beanit.asn1bean.ber.BerTag;
import com.beanit.asn1bean.ber.ReverseByteArrayOutputStream;
import com.beanit.asn1bean.ber.types.BerType;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;

public class ObjectName implements BerType, Serializable {

    private static final long serialVersionUID = 1L;

    private byte[] code = null;
    private Identifier vmdSpecific = null;
    private DomainSpecific domainSpecific = null;
    private Identifier aaSpecific = null;

    public ObjectName() {
    }

    public ObjectName(byte[] code) {
        this.code = code;
    }

    public Identifier getVmdSpecific() {
        return vmdSpecific;
    }

    public void setVmdSpecific(Identifier vmdSpecific) {
        this.vmdSpecific = vmdSpecific;
    }

    public DomainSpecific getDomainSpecific() {
        return domainSpecific;
    }

    public void setDomainSpecific(DomainSpecific domainSpecific) {
        this.domainSpecific = domainSpecific;
    }

    public Identifier getAaSpecific() {
        return aaSpecific;
    }

    public void setAaSpecific(Identifier aaSpecific) {
        this.aaSpecific = aaSpecific;
    }

    @Override
    public int encode(OutputStream reverseOS) throws IOException {

        if (code != null) {
            reverseOS.write(code);
            return code.length;
        }

        int codeLength = 0;
        if (aaSpecific != null) {
            codeLength += aaSpecific.encode(reverseOS, false);
            // write tag: CONTEXT_CLASS, PRIMITIVE, 2
            reverseOS.write(0x82);
            codeLength += 1;
            return codeLength;
        }

        if (domainSpecific != null) {
            codeLength += domainSpecific.encode(reverseOS, false);
            // write tag: CONTEXT_CLASS, CONSTRUCTED, 1
            reverseOS.write(0xA1);
            codeLength += 1;
            return codeLength;
        }

        if (vmdSpecific != null) {
            codeLength += vmdSpecific.encode(reverseOS, false);
            // write tag: CONTEXT_CLASS, PRIMITIVE, 0
            reverseOS.write(0x80);
            codeLength += 1;
            return codeLength;
        }

        throw new IOException("Error encoding CHOICE: No element of CHOICE was selected.");
    }

    @Override
    public int decode(InputStream is) throws IOException {
        return decode(is, null);
    }

    public int decode(InputStream is, BerTag berTag) throws IOException {

        int tlvByteCount = 0;
        boolean tagWasPassed = (berTag != null);

        if (berTag == null) {
            berTag = new BerTag();
            tlvByteCount += berTag.decode(is);
        }

        if (berTag.equals(BerTag.CONTEXT_CLASS, BerTag.PRIMITIVE, 0)) {
            vmdSpecific = new Identifier();
            tlvByteCount += vmdSpecific.decode(is, false);
            return tlvByteCount;
        }

        if (berTag.equals(BerTag.CONTEXT_CLASS, BerTag.CONSTRUCTED, 1)) {
            domainSpecific = new DomainSpecific();
            tlvByteCount += domainSpecific.decode(is, false);
            return tlvByteCount;
        }

        if (berTag.equals(BerTag.CONTEXT_CLASS, BerTag.PRIMITIVE, 2)) {
            aaSpecific = new Identifier();
            tlvByteCount += aaSpecific.decode(is, false);
            return tlvByteCount;
        }

        if (tagWasPassed) {
            return 0;
        }

        throw new IOException("Error decoding CHOICE: Tag " + berTag + " matched to no item.");
    }

    public void encodeAndSave(int encodingSizeGuess) throws IOException {
        ReverseByteArrayOutputStream reverseOS = new ReverseByteArrayOutputStream(encodingSizeGuess);
        encode(reverseOS);
        code = reverseOS.getArray();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        appendAsString(sb, 0);
        return sb.toString();
    }

    public void appendAsString(StringBuilder sb, int indentLevel) {

        if (vmdSpecific != null) {
            sb.append("vmdSpecific: ").append(vmdSpecific);
            return;
        }

        if (domainSpecific != null) {
            sb.append("domainSpecific: ");
            domainSpecific.appendAsString(sb, indentLevel + 1);
            return;
        }

        if (aaSpecific != null) {
            sb.append("aaSpecific: ").append(aaSpecific);
            return;
        }

        sb.append("<none>");
    }

    public static class DomainSpecific implements BerType, Serializable {

        public static final BerTag tag = new BerTag(BerTag.UNIVERSAL_CLASS, BerTag.CONSTRUCTED, 16);
        private static final long serialVersionUID = 1L;
        private byte[] code = null;
        private Identifier domainID = null;
        private Identifier itemID = null;

        public DomainSpecific() {
        }

        public DomainSpecific(byte[] code) {
            this.code = code;
        }

        public Identifier getDomainID() {
            return domainID;
        }

        public void setDomainID(Identifier domainID) {
            this.domainID = domainID;
        }

        public Identifier getItemID() {
            return itemID;
        }

        public void setItemID(Identifier itemID) {
            this.itemID = itemID;
        }

        @Override
        public int encode(OutputStream reverseOS) throws IOException {
            return encode(reverseOS, true);
        }

        public int encode(OutputStream reverseOS, boolean withTag) throws IOException {

            if (code != null) {
                reverseOS.write(code);
                if (withTag) {
                    return tag.encode(reverseOS) + code.length;
                }
                return code.length;
            }

            int codeLength = 0;
            codeLength += itemID.encode(reverseOS, true);

            codeLength += domainID.encode(reverseOS, true);

            codeLength += BerLength.encodeLength(reverseOS, codeLength);

            if (withTag) {
                codeLength += tag.encode(reverseOS);
            }

            return codeLength;
        }

        @Override
        public int decode(InputStream is) throws IOException {
            return decode(is, true);
        }

        public int decode(InputStream is, boolean withTag) throws IOException {
            int tlByteCount = 0;
            int vByteCount = 0;
            BerTag berTag = new BerTag();

            if (withTag) {
                tlByteCount += tag.decodeAndCheck(is);
            }

            BerLength length = new BerLength();
            tlByteCount += length.decode(is);
            int lengthVal = length.val;
            vByteCount += berTag.decode(is);

            if (berTag.equals(Identifier.tag)) {
                domainID = new Identifier();
                vByteCount += domainID.decode(is, false);
                vByteCount += berTag.decode(is);
            } else {
                throw new IOException("Tag does not match mandatory sequence component.");
            }

            if (berTag.equals(Identifier.tag)) {
                itemID = new Identifier();
                vByteCount += itemID.decode(is, false);
                if (lengthVal >= 0 && vByteCount == lengthVal) {
                    return tlByteCount + vByteCount;
                }
                vByteCount += berTag.decode(is);
            } else {
                throw new IOException("Tag does not match mandatory sequence component.");
            }

            if (lengthVal < 0) {
                if (!berTag.equals(0, 0, 0)) {
                    throw new IOException("Decoded sequence has wrong end of contents octets");
                }
                vByteCount += BerLength.readEocByte(is);
                return tlByteCount + vByteCount;
            }

            throw new IOException(
                    "Unexpected end of sequence, length tag: "
                            + lengthVal
                            + ", bytes decoded: "
                            + vByteCount);
        }

        public void encodeAndSave(int encodingSizeGuess) throws IOException {
            ReverseByteArrayOutputStream reverseOS = new ReverseByteArrayOutputStream(encodingSizeGuess);
            encode(reverseOS, false);
            code = reverseOS.getArray();
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            appendAsString(sb, 0);
            return sb.toString();
        }

        public void appendAsString(StringBuilder sb, int indentLevel) {

            sb.append("{");
            sb.append("\n");
            for (int i = 0; i < indentLevel + 1; i++) {
                sb.append("\t");
            }
            if (domainID != null) {
                sb.append("domainID: ").append(domainID);
            } else {
                sb.append("domainID: <empty-required-field>");
            }

            sb.append(",\n");
            for (int i = 0; i < indentLevel + 1; i++) {
                sb.append("\t");
            }
            if (itemID != null) {
                sb.append("itemID: ").append(itemID);
            } else {
                sb.append("itemID: <empty-required-field>");
            }

            sb.append("\n");
            for (int i = 0; i < indentLevel; i++) {
                sb.append("\t");
            }
            sb.append("}");
        }
    }
}
