/*
 * This class file was automatically generated by ASN1bean (http://www.beanit.com)
 */

package com.beanit.iec61850bean.internal.mms.asn1;

import com.beanit.asn1bean.ber.BerLength;
import com.beanit.asn1bean.ber.BerTag;
import com.beanit.asn1bean.ber.ReverseByteArrayOutputStream;
import com.beanit.asn1bean.ber.types.BerType;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ReadResponse implements BerType, Serializable {

    public static final BerTag tag = new BerTag(BerTag.UNIVERSAL_CLASS, BerTag.CONSTRUCTED, 16);
    private static final long serialVersionUID = 1L;
    private byte[] code = null;
    private VariableAccessSpecification variableAccessSpecification = null;
    private ListOfAccessResult listOfAccessResult = null;

    public ReadResponse() {
    }

    public ReadResponse(byte[] code) {
        this.code = code;
    }

    public VariableAccessSpecification getVariableAccessSpecification() {
        return variableAccessSpecification;
    }

    public void setVariableAccessSpecification(
            VariableAccessSpecification variableAccessSpecification) {
        this.variableAccessSpecification = variableAccessSpecification;
    }

    public ListOfAccessResult getListOfAccessResult() {
        return listOfAccessResult;
    }

    public void setListOfAccessResult(ListOfAccessResult listOfAccessResult) {
        this.listOfAccessResult = listOfAccessResult;
    }

    @Override
    public int encode(OutputStream reverseOS) throws IOException {
        return encode(reverseOS, true);
    }

    public int encode(OutputStream reverseOS, boolean withTag) throws IOException {

        if (code != null) {
            reverseOS.write(code);
            if (withTag) {
                return tag.encode(reverseOS) + code.length;
            }
            return code.length;
        }

        int codeLength = 0;
        int sublength;

        codeLength += listOfAccessResult.encode(reverseOS, false);
        // write tag: CONTEXT_CLASS, CONSTRUCTED, 1
        reverseOS.write(0xA1);
        codeLength += 1;

        if (variableAccessSpecification != null) {
            sublength = variableAccessSpecification.encode(reverseOS);
            codeLength += sublength;
            codeLength += BerLength.encodeLength(reverseOS, sublength);
            // write tag: CONTEXT_CLASS, CONSTRUCTED, 0
            reverseOS.write(0xA0);
            codeLength += 1;
        }

        codeLength += BerLength.encodeLength(reverseOS, codeLength);

        if (withTag) {
            codeLength += tag.encode(reverseOS);
        }

        return codeLength;
    }

    @Override
    public int decode(InputStream is) throws IOException {
        return decode(is, true);
    }

    public int decode(InputStream is, boolean withTag) throws IOException {
        int tlByteCount = 0;
        int vByteCount = 0;
        BerTag berTag = new BerTag();

        if (withTag) {
            tlByteCount += tag.decodeAndCheck(is);
        }

        BerLength length = new BerLength();
        tlByteCount += length.decode(is);
        int lengthVal = length.val;
        vByteCount += berTag.decode(is);

        if (berTag.equals(BerTag.CONTEXT_CLASS, BerTag.CONSTRUCTED, 0)) {
            vByteCount += length.decode(is);
            variableAccessSpecification = new VariableAccessSpecification();
            vByteCount += variableAccessSpecification.decode(is, null);
            vByteCount += length.readEocIfIndefinite(is);
            vByteCount += berTag.decode(is);
        }

        if (berTag.equals(BerTag.CONTEXT_CLASS, BerTag.CONSTRUCTED, 1)) {
            listOfAccessResult = new ListOfAccessResult();
            vByteCount += listOfAccessResult.decode(is, false);
            if (lengthVal >= 0 && vByteCount == lengthVal) {
                return tlByteCount + vByteCount;
            }
            vByteCount += berTag.decode(is);
        } else {
            throw new IOException("Tag does not match mandatory sequence component.");
        }

        if (lengthVal < 0) {
            if (!berTag.equals(0, 0, 0)) {
                throw new IOException("Decoded sequence has wrong end of contents octets");
            }
            vByteCount += BerLength.readEocByte(is);
            return tlByteCount + vByteCount;
        }

        throw new IOException(
                "Unexpected end of sequence, length tag: " + lengthVal + ", bytes decoded: " + vByteCount);
    }

    public void encodeAndSave(int encodingSizeGuess) throws IOException {
        ReverseByteArrayOutputStream reverseOS = new ReverseByteArrayOutputStream(encodingSizeGuess);
        encode(reverseOS, false);
        code = reverseOS.getArray();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        appendAsString(sb, 0);
        return sb.toString();
    }

    public void appendAsString(StringBuilder sb, int indentLevel) {

        sb.append("{");
        boolean firstSelectedElement = true;
        if (variableAccessSpecification != null) {
            sb.append("\n");
            for (int i = 0; i < indentLevel + 1; i++) {
                sb.append("\t");
            }
            sb.append("variableAccessSpecification: ");
            variableAccessSpecification.appendAsString(sb, indentLevel + 1);
            firstSelectedElement = false;
        }

        if (!firstSelectedElement) {
            sb.append(",\n");
        }
        for (int i = 0; i < indentLevel + 1; i++) {
            sb.append("\t");
        }
        if (listOfAccessResult != null) {
            sb.append("listOfAccessResult: ");
            listOfAccessResult.appendAsString(sb, indentLevel + 1);
        } else {
            sb.append("listOfAccessResult: <empty-required-field>");
        }

        sb.append("\n");
        for (int i = 0; i < indentLevel; i++) {
            sb.append("\t");
        }
        sb.append("}");
    }

    public static class ListOfAccessResult implements BerType, Serializable {

        public static final BerTag tag = new BerTag(BerTag.UNIVERSAL_CLASS, BerTag.CONSTRUCTED, 16);
        private static final long serialVersionUID = 1L;
        private byte[] code = null;
        private List<AccessResult> seqOf = null;

        public ListOfAccessResult() {
            seqOf = new ArrayList<AccessResult>();
        }

        public ListOfAccessResult(byte[] code) {
            this.code = code;
        }

        public List<AccessResult> getAccessResult() {
            if (seqOf == null) {
                seqOf = new ArrayList<AccessResult>();
            }
            return seqOf;
        }

        @Override
        public int encode(OutputStream reverseOS) throws IOException {
            return encode(reverseOS, true);
        }

        public int encode(OutputStream reverseOS, boolean withTag) throws IOException {

            if (code != null) {
                reverseOS.write(code);
                if (withTag) {
                    return tag.encode(reverseOS) + code.length;
                }
                return code.length;
            }

            int codeLength = 0;
            for (int i = (seqOf.size() - 1); i >= 0; i--) {
                codeLength += seqOf.get(i).encode(reverseOS);
            }

            codeLength += BerLength.encodeLength(reverseOS, codeLength);

            if (withTag) {
                codeLength += tag.encode(reverseOS);
            }

            return codeLength;
        }

        @Override
        public int decode(InputStream is) throws IOException {
            return decode(is, true);
        }

        public int decode(InputStream is, boolean withTag) throws IOException {
            int tlByteCount = 0;
            int vByteCount = 0;
            int numDecodedBytes;
            BerTag berTag = new BerTag();
            if (withTag) {
                tlByteCount += tag.decodeAndCheck(is);
            }

            BerLength length = new BerLength();
            tlByteCount += length.decode(is);
            int lengthVal = length.val;

            while (vByteCount < lengthVal || lengthVal < 0) {
                vByteCount += berTag.decode(is);

                if (lengthVal < 0 && berTag.equals(0, 0, 0)) {
                    vByteCount += BerLength.readEocByte(is);
                    break;
                }

                AccessResult element = new AccessResult();
                numDecodedBytes = element.decode(is, berTag);
                if (numDecodedBytes == 0) {
                    throw new IOException("Tag did not match");
                }
                vByteCount += numDecodedBytes;
                seqOf.add(element);
            }
            if (lengthVal >= 0 && vByteCount != lengthVal) {
                throw new IOException(
                        "Decoded SequenceOf or SetOf has wrong length. Expected "
                                + lengthVal
                                + " but has "
                                + vByteCount);
            }
            return tlByteCount + vByteCount;
        }

        public void encodeAndSave(int encodingSizeGuess) throws IOException {
            ReverseByteArrayOutputStream reverseOS = new ReverseByteArrayOutputStream(encodingSizeGuess);
            encode(reverseOS, false);
            code = reverseOS.getArray();
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            appendAsString(sb, 0);
            return sb.toString();
        }

        public void appendAsString(StringBuilder sb, int indentLevel) {

            sb.append("{\n");
            for (int i = 0; i < indentLevel + 1; i++) {
                sb.append("\t");
            }
            if (seqOf == null) {
                sb.append("null");
            } else {
                Iterator<AccessResult> it = seqOf.iterator();
                if (it.hasNext()) {
                    it.next().appendAsString(sb, indentLevel + 1);
                    while (it.hasNext()) {
                        sb.append(",\n");
                        for (int i = 0; i < indentLevel + 1; i++) {
                            sb.append("\t");
                        }
                        it.next().appendAsString(sb, indentLevel + 1);
                    }
                }
            }

            sb.append("\n");
            for (int i = 0; i < indentLevel; i++) {
                sb.append("\t");
            }
            sb.append("}");
        }
    }
}
