/*
 * Decompiled with CFR 0.152.
 */
package com.github.mdr.ascii.layout.drawing;

import com.github.mdr.ascii.common.Region;
import com.github.mdr.ascii.layout.drawing.Drawing;
import com.github.mdr.ascii.layout.drawing.EdgeDrawingElement;
import com.github.mdr.ascii.layout.drawing.EdgeSegment;
import com.github.mdr.ascii.layout.drawing.EdgeSegmentInfo;
import com.github.mdr.ascii.util.QuadTree;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005ua\u0001B\f\u0019\u0001\u0015B\u0001\"\u0007\u0001\u0003\u0002\u0003\u0006I\u0001\f\u0005\u0006a\u0001!\t!\r\u0005\bi\u0001\u0011\r\u0011\"\u00036\u0011\u0019\u0011\u0005\u0001)A\u0005m!91\t\u0001b\u0001\n\u0013)\u0004B\u0002#\u0001A\u0003%a\u0007C\u0004F\u0001\t\u0007I\u0011\u0002$\t\rM\u0003\u0001\u0015!\u0003H\u0011\u001d!\u0006A1A\u0005\n\u0019Ca!\u0016\u0001!\u0002\u00139\u0005\"\u0002,\u0001\t\u00039\u0006\"\u00021\u0001\t\u0003\t\u0007\"B2\u0001\t\u0003!\u0007\"\u00026\u0001\t\u0003Y\u0007\"B7\u0001\t\u0003q\u0007\"\u00029\u0001\t\u0003\t\b\"B:\u0001\t\u0003!\b\"B=\u0001\t\u0003Q\b\"B:\u0001\t\u0013a\b\"B=\u0001\t\u0013y\bbBA\u0002\u0001\u0011\u0005\u0011Q\u0001\u0005\b\u0003\u0013\u0001A\u0011IA\u0006\u0005-)EmZ3Ue\u0006\u001c7.\u001a:\u000b\u0005eQ\u0012a\u00023sC^Lgn\u001a\u0006\u00037q\ta\u0001\\1z_V$(BA\u000f\u001f\u0003\u0015\t7oY5j\u0015\ty\u0002%A\u0002nIJT!!\t\u0012\u0002\r\u001dLG\u000f[;c\u0015\u0005\u0019\u0013aA2p[\u000e\u00011C\u0001\u0001'!\t9#&D\u0001)\u0015\u0005I\u0013!B:dC2\f\u0017BA\u0016)\u0005\u0019\te.\u001f*fMB\u0011QFL\u0007\u00021%\u0011q\u0006\u0007\u0002\b\tJ\fw/\u001b8h\u0003\u0019a\u0014N\\5u}Q\u0011!g\r\t\u0003[\u0001AQ!\u0007\u0002A\u00021\n!\u0003[8sSj|g\u000e^1m#V\fG\r\u0016:fKV\ta\u0007E\u00028uqj\u0011\u0001\u000f\u0006\u0003sq\tA!\u001e;jY&\u00111\b\u000f\u0002\t#V\fG\r\u0016:fKB\u0011Q\bQ\u0007\u0002})\u0011q\bH\u0001\u0007G>lWn\u001c8\n\u0005\u0005s$A\u0002*fO&|g.A\ni_JL'p\u001c8uC2\fV/\u00193Ue\u0016,\u0007%\u0001\twKJ$\u0018nY1m#V\fG\r\u0016:fK\u0006\tb/\u001a:uS\u000e\fG.U;bIR\u0013X-\u001a\u0011\u0002\u001bY,'\u000f^3y%\u0016<\u0017n\u001c8t+\u00059\u0005c\u0001%Qy9\u0011\u0011J\u0014\b\u0003\u00156k\u0011a\u0013\u0006\u0003\u0019\u0012\na\u0001\u0010:p_Rt\u0014\"A\u0015\n\u0005=C\u0013a\u00029bG.\fw-Z\u0005\u0003#J\u0013A\u0001T5ti*\u0011q\nK\u0001\u000fm\u0016\u0014H/\u001a=SK\u001eLwN\\:!\u00031\t'O]8x%\u0016<\u0017n\u001c8t\u00035\t'O]8x%\u0016<\u0017n\u001c8tA\u0005y\u0011\r\u001a3FI\u001e,7+Z4nK:$8\u000f\u0006\u0002Y7B\u0011q%W\u0005\u00035\"\u0012A!\u00168ji\")Al\u0003a\u0001;\u0006Y1/Z4nK:$\u0018J\u001c4p!\tic,\u0003\u0002`1\tyQ\tZ4f'\u0016<W.\u001a8u\u0013:4w.\u0001\nsK6|g/Z#eO\u0016\u001cVmZ7f]R\u001cHC\u0001-c\u0011\u0015aF\u00021\u0001^\u0003Q\tG\r\u001a%pe&TxN\u001c;bYN+w-\\3oiR\u0011\u0001,\u001a\u0005\u0006M6\u0001\raZ\u0001\fK\u0012<WmU3h[\u0016tG\u000f\u0005\u0002.Q&\u0011\u0011\u000e\u0007\u0002\f\u000b\u0012<WmU3h[\u0016tG/\u0001\nbI\u00124VM\u001d;jG\u0006d7+Z4nK:$HC\u0001-m\u0011\u00151g\u00021\u0001h\u0003]\u0011X-\\8wK\"{'/\u001b>p]R\fGnU3h[\u0016tG\u000f\u0006\u0002Y_\")am\u0004a\u0001O\u0006)\"/Z7pm\u00164VM\u001d;jG\u0006d7+Z4nK:$HC\u0001-s\u0011\u00151\u0007\u00031\u0001h\u0003I\u0019w\u000e\u001c7jI\u0016\u001c\bj\u001c:ju>tG/\u00197\u0015\u0005UD\bCA\u0014w\u0013\t9\bFA\u0004C_>dW-\u00198\t\u000b\u0019\f\u0002\u0019A4\u0002!\r|G\u000e\\5eKN4VM\u001d;jG\u0006dGCA;|\u0011\u00151'\u00031\u0001h)\t)X\u0010C\u0003\u007f'\u0001\u0007A(\u0001\u0004sK\u001eLwN\u001c\u000b\u0004k\u0006\u0005\u0001\"\u0002@\u0015\u0001\u0004a\u0014\u0001D2pY2LG-Z:XSRDGcA;\u0002\b!)A,\u0006a\u0001;\u0006AAo\\*ue&tw\r\u0006\u0002\u0002\u000eA!\u0011qBA\r\u001b\t\t\tB\u0003\u0003\u0002\u0014\u0005U\u0011\u0001\u00027b]\u001eT!!a\u0006\u0002\t)\fg/Y\u0005\u0005\u00037\t\tB\u0001\u0004TiJLgn\u001a")
public class EdgeTracker {
    private final QuadTree<Region> horizontalQuadTree;
    private final QuadTree<Region> verticalQuadTree;
    private final List<Region> vertexRegions;
    private final List<Region> arrowRegions;

    private QuadTree<Region> horizontalQuadTree() {
        return this.horizontalQuadTree;
    }

    private QuadTree<Region> verticalQuadTree() {
        return this.verticalQuadTree;
    }

    private List<Region> vertexRegions() {
        return this.vertexRegions;
    }

    private List<Region> arrowRegions() {
        return this.arrowRegions;
    }

    public void addEdgeSegments(EdgeSegmentInfo segmentInfo) {
        this.verticalQuadTree().add(segmentInfo.segment1().region());
        this.horizontalQuadTree().add(segmentInfo.segment2().region());
        this.verticalQuadTree().add(segmentInfo.segment3().region());
    }

    public void removeEdgeSegments(EdgeSegmentInfo segmentInfo) {
        this.verticalQuadTree().remove(segmentInfo.segment1().region());
        this.horizontalQuadTree().remove(segmentInfo.segment2().region());
        this.verticalQuadTree().remove(segmentInfo.segment3().region());
    }

    public void addHorizontalSegment(EdgeSegment edgeSegment) {
        this.horizontalQuadTree().add(edgeSegment.region());
    }

    public void addVerticalSegment(EdgeSegment edgeSegment) {
        this.verticalQuadTree().add(edgeSegment.region());
    }

    public void removeHorizontalSegment(EdgeSegment edgeSegment) {
        this.horizontalQuadTree().remove(edgeSegment.region());
    }

    public void removeVerticalSegment(EdgeSegment edgeSegment) {
        this.verticalQuadTree().remove(edgeSegment.region());
    }

    public boolean collidesHorizontal(EdgeSegment edgeSegment) {
        return this.collidesHorizontal(edgeSegment.region());
    }

    public boolean collidesVertical(EdgeSegment edgeSegment) {
        return this.collidesVertical(edgeSegment.region());
    }

    private boolean collidesHorizontal(Region region) {
        return this.horizontalQuadTree().collides(region);
    }

    private boolean collidesVertical(Region region) {
        return this.verticalQuadTree().collides(region);
    }

    public boolean collidesWith(EdgeSegmentInfo segmentInfo) {
        return this.collidesVertical(segmentInfo.segment1().region()) || this.collidesHorizontal(segmentInfo.segment2().region()) || this.collidesVertical(segmentInfo.segment3().region()) || this.collidesVertical(segmentInfo.segment2().region()) && this.collidesHorizontal(segmentInfo.segment3().region());
    }

    public String toString() {
        return new StringBuilder(0).append(Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd(this.horizontalQuadTree()), "\n------------------------------------------------------------\n")).append(this.verticalQuadTree()).toString();
    }

    public static final /* synthetic */ void $anonfun$new$1(EdgeTracker $this, Region t) {
        $this.horizontalQuadTree().add(t);
    }

    public static final /* synthetic */ void $anonfun$new$2(EdgeTracker $this, Region t) {
        $this.horizontalQuadTree().add(t);
    }

    public static final /* synthetic */ void $anonfun$new$3(EdgeTracker $this, Region t) {
        $this.verticalQuadTree().add(t);
    }

    public static final /* synthetic */ void $anonfun$new$5(EdgeTracker $this, EdgeSegment segment) {
        if (segment.direction().isHorizontal()) {
            $this.horizontalQuadTree().add(segment.region());
        } else {
            $this.verticalQuadTree().add(segment.region());
        }
    }

    public static final /* synthetic */ void $anonfun$new$4(EdgeTracker $this, EdgeDrawingElement edge) {
        edge.segments().foreach((Function1 & java.io.Serializable & Serializable)segment -> {
            EdgeTracker.$anonfun$new$5($this, segment);
            return BoxedUnit.UNIT;
        });
    }

    public EdgeTracker(Drawing drawing) {
        this.horizontalQuadTree = new QuadTree(drawing.dimension());
        this.verticalQuadTree = new QuadTree(drawing.dimension());
        this.vertexRegions = (List)drawing.vertexElements().map((Function1 & java.io.Serializable & Serializable)x$1 -> x$1.region(), List$.MODULE$.canBuildFrom());
        this.arrowRegions = (List)drawing.edgeElements().map((Function1 & java.io.Serializable & Serializable)edgeElement -> edgeElement.hasArrow1() ? edgeElement.startPoint().region() : edgeElement.finishPoint().region(), List$.MODULE$.canBuildFrom());
        this.arrowRegions().foreach((Function1 & java.io.Serializable & Serializable)t -> {
            EdgeTracker.$anonfun$new$1(this, t);
            return BoxedUnit.UNIT;
        });
        this.vertexRegions().foreach((Function1 & java.io.Serializable & Serializable)t -> {
            EdgeTracker.$anonfun$new$2(this, t);
            return BoxedUnit.UNIT;
        });
        this.vertexRegions().foreach((Function1 & java.io.Serializable & Serializable)t -> {
            EdgeTracker.$anonfun$new$3(this, t);
            return BoxedUnit.UNIT;
        });
        drawing.edgeElements().foreach((Function1 & java.io.Serializable & Serializable)edge -> {
            EdgeTracker.$anonfun$new$4(this, edge);
            return BoxedUnit.UNIT;
        });
    }
}

