/*
 * Decompiled with CFR 0.152.
 */
package com.emv.qrcode.core.model;

import com.emv.qrcode.core.model.BERTLV;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import lombok.Generated;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.StringUtils;

public class BERTLString
implements BERTLV<Integer, String> {
    private static final long serialVersionUID = -6482977134879939277L;
    private Integer tag;
    private String value;

    public BERTLString() {
    }

    public BERTLString(Integer tag, String value) {
        this.tag = tag;
        this.value = value;
    }

    @Override
    public Integer getLength() {
        return this.value.length();
    }

    @Override
    public byte[] getBytes() throws IOException {
        if (StringUtils.isBlank((CharSequence)this.value)) {
            return EMPTY_BYTES;
        }
        try (ByteArrayOutputStream stream = new ByteArrayOutputStream();){
            stream.write(this.getTag());
            stream.write(this.getLength());
            stream.write(this.getValue().getBytes(StandardCharsets.UTF_8));
            byte[] byArray = stream.toByteArray();
            return byArray;
        }
    }

    @Override
    public String toHex() throws IOException {
        return Hex.encodeHexString((byte[])this.getBytes(), (boolean)false);
    }

    @Override
    @Generated
    public Integer getTag() {
        return this.tag;
    }

    @Override
    @Generated
    public String getValue() {
        return this.value;
    }

    @Generated
    public void setTag(Integer tag) {
        this.tag = tag;
    }

    @Generated
    public void setValue(String value) {
        this.value = value;
    }
}

