/*
 * Decompiled with CFR 0.152.
 */
package com.emv.qrcode.decoder.cpm;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;

final class DecodeCpmIterator
implements Iterator<byte[]> {
    private static final Map<Byte, Integer> ID_WORD_COUNT = new ConcurrentHashMap<Byte, Integer>();
    public static final Integer VALUE_LENGTH_WORD_COUNT;
    private Integer current = 0;
    private final Integer max;
    private final byte[] source;

    public DecodeCpmIterator(byte[] source) {
        this.max = source.length;
        this.source = source;
    }

    private Byte valueLength() {
        Integer start = this.current + ID_WORD_COUNT.get(this.source[this.current]);
        Integer end = start + VALUE_LENGTH_WORD_COUNT;
        return this.source[end];
    }

    @Override
    public boolean hasNext() {
        return this.current < this.max && this.current + ID_WORD_COUNT.get(this.source[this.current]) + VALUE_LENGTH_WORD_COUNT + this.valueLength() <= this.max;
    }

    @Override
    public void forEachRemaining(Consumer<? super byte[]> action) {
        while (this.hasNext()) {
            action.accept((byte[])this.next());
        }
    }

    @Override
    public byte[] next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Integer valueLength = this.valueLength() + 1;
        byte[] value = Arrays.copyOfRange(this.source, (int)this.current, this.current + ID_WORD_COUNT.get(this.source[this.current]) + VALUE_LENGTH_WORD_COUNT + valueLength);
        this.current = this.current + (ID_WORD_COUNT.get(this.source[this.current]) + VALUE_LENGTH_WORD_COUNT + valueLength);
        return value;
    }

    static {
        ID_WORD_COUNT.put((byte)-123, 0);
        ID_WORD_COUNT.put((byte)97, 0);
        ID_WORD_COUNT.put((byte)98, 0);
        ID_WORD_COUNT.put((byte)99, 0);
        ID_WORD_COUNT.put((byte)100, 0);
        ID_WORD_COUNT.put((byte)79, 0);
        ID_WORD_COUNT.put((byte)80, 0);
        ID_WORD_COUNT.put((byte)87, 0);
        ID_WORD_COUNT.put((byte)90, 0);
        ID_WORD_COUNT.put((byte)95, 1);
        ID_WORD_COUNT.put((byte)-97, 1);
        VALUE_LENGTH_WORD_COUNT = 1;
    }
}

