/*
 * Decompiled with CFR 0.152.
 */
package com.emv.qrcode.decoder.cpm;

import com.emv.qrcode.core.configuration.DecodersCpmMap;
import com.emv.qrcode.decoder.cpm.DecodeCpmIterator;
import java.lang.reflect.Constructor;
import java.util.AbstractMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.BiConsumer;

public abstract class DecoderCpm<T> {
    protected final Iterator<byte[]> iterator;

    protected DecoderCpm(byte[] source) {
        this.iterator = new DecodeCpmIterator(source);
    }

    protected abstract T decode();

    protected static <C, T> Map.Entry<Class<?>, BiConsumer<C, ?>> consumerTagLengthValue(Class<T> clazz, BiConsumer<C, T> consumer) {
        return new AbstractMap.SimpleEntry(clazz, consumer);
    }

    public static <T> T decode(byte[] source, Class<T> clazz) {
        try {
            Class<DecoderCpm<?>> parserClass = DecodersCpmMap.getDecoder(clazz);
            Constructor<DecoderCpm<?>> ctor = parserClass.getConstructor(byte[].class);
            DecoderCpm<?> parser = ctor.newInstance(new Object[]{source});
            return clazz.cast(parser.decode());
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

