/*
 * Decompiled with CFR 0.152.
 */
package com.emv.qrcode.decoder.mpm;

import com.emv.qrcode.core.model.TagLengthString;
import com.emv.qrcode.decoder.mpm.DecodeMpmIterator;
import com.emv.qrcode.decoder.mpm.DecoderMpm;
import com.emv.qrcode.model.mpm.AdditionalDataField;
import com.emv.qrcode.model.mpm.PaymentSystemSpecificTemplate;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;

public final class AdditionalDataFieldDecoder
extends DecoderMpm<AdditionalDataField> {
    private static final Map<String, Map.Entry<Class<?>, BiConsumer<AdditionalDataField, ?>>> mapConsumers = new HashMap();

    public AdditionalDataFieldDecoder(String source) {
        super(source);
    }

    @Override
    protected AdditionalDataField decode() {
        AdditionalDataField result = new AdditionalDataField();
        this.iterator.forEachRemaining(value -> {
            String tag = this.derivateId(value.substring(0, DecodeMpmIterator.ID_WORD_COUNT));
            Map.Entry<Class<?>, BiConsumer<AdditionalDataField, ?>> entry = mapConsumers.get(tag);
            Class<?> clazz = entry.getKey();
            BiConsumer<AdditionalDataField, ?> consumer = entry.getValue();
            consumer.accept(result, DecoderMpm.decode(value, clazz));
        });
        return result;
    }

    private String derivateId(String id) {
        if (this.betweenPaymentSystemSpecificRange(id)) {
            return "50";
        }
        if (this.betweenRFUForEMVCORange(id)) {
            return "10";
        }
        return id;
    }

    private boolean betweenRFUForEMVCORange(String value) {
        return value.compareTo("10") >= 0 && value.compareTo("49") <= 0;
    }

    private boolean betweenPaymentSystemSpecificRange(String value) {
        return value.compareTo("50") >= 0 && value.compareTo("99") <= 0;
    }

    static {
        mapConsumers.put("01", AdditionalDataFieldDecoder.consumerTagLengthValue(String.class, AdditionalDataField::setBillNumber));
        mapConsumers.put("02", AdditionalDataFieldDecoder.consumerTagLengthValue(String.class, AdditionalDataField::setMobileNumber));
        mapConsumers.put("03", AdditionalDataFieldDecoder.consumerTagLengthValue(String.class, AdditionalDataField::setStoreLabel));
        mapConsumers.put("04", AdditionalDataFieldDecoder.consumerTagLengthValue(String.class, AdditionalDataField::setLoyaltyNumber));
        mapConsumers.put("05", AdditionalDataFieldDecoder.consumerTagLengthValue(String.class, AdditionalDataField::setReferenceLabel));
        mapConsumers.put("06", AdditionalDataFieldDecoder.consumerTagLengthValue(String.class, AdditionalDataField::setCustomerLabel));
        mapConsumers.put("07", AdditionalDataFieldDecoder.consumerTagLengthValue(String.class, AdditionalDataField::setTerminalLabel));
        mapConsumers.put("08", AdditionalDataFieldDecoder.consumerTagLengthValue(String.class, AdditionalDataField::setPurposeTransaction));
        mapConsumers.put("10", AdditionalDataFieldDecoder.consumerTagLengthValue(TagLengthString.class, AdditionalDataField::addRFUforEMVCo));
        mapConsumers.put("50", AdditionalDataFieldDecoder.consumerTagLengthValue(PaymentSystemSpecificTemplate.class, AdditionalDataField::addPaymentSystemSpecific));
        mapConsumers.put("09", AdditionalDataFieldDecoder.consumerTagLengthValue(String.class, AdditionalDataField::setAdditionalConsumerDataRequest));
    }
}

