/*
 * Decompiled with CFR 0.152.
 */
package com.emv.qrcode.decoder.mpm;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Consumer;

final class DecodeMpmIterator
implements Iterator<String> {
    public static final Integer ID_WORD_COUNT = 2;
    public static final Integer VALUE_LENGTH_WORD_COUNT = 2;
    private Integer current = 0;
    private final Integer max;
    private final String source;

    public DecodeMpmIterator(String source) {
        this.max = source.length();
        this.source = source;
    }

    private Integer valueLength() {
        Integer start = this.current + ID_WORD_COUNT;
        Integer end = start + VALUE_LENGTH_WORD_COUNT;
        return Integer.valueOf(this.source.substring(start, end));
    }

    @Override
    public boolean hasNext() {
        return this.current + ID_WORD_COUNT + VALUE_LENGTH_WORD_COUNT <= this.max && this.current + ID_WORD_COUNT + VALUE_LENGTH_WORD_COUNT + this.valueLength() <= this.max;
    }

    @Override
    public void forEachRemaining(Consumer<? super String> action) {
        while (this.hasNext()) {
            action.accept(this.next());
        }
    }

    @Override
    public String next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Integer valueLength = this.valueLength();
        String value = this.source.substring(this.current, this.current + ID_WORD_COUNT + VALUE_LENGTH_WORD_COUNT + valueLength);
        this.current = this.current + (ID_WORD_COUNT + VALUE_LENGTH_WORD_COUNT + valueLength);
        return value;
    }
}

