/*
 * Decompiled with CFR 0.152.
 */
package com.emv.qrcode.decoder.mpm;

import com.emv.qrcode.core.configuration.DecodersMpmMap;
import com.emv.qrcode.decoder.mpm.DecodeMpmIterator;
import java.lang.reflect.Constructor;
import java.util.AbstractMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.BiConsumer;

public abstract class DecoderMpm<T> {
    protected final Iterator<String> iterator;

    protected DecoderMpm(String source) {
        this.iterator = new DecodeMpmIterator(source);
    }

    protected abstract T decode();

    protected static <C, T> Map.Entry<Class<?>, BiConsumer<C, ?>> consumerTagLengthValue(Class<T> clazz, BiConsumer<C, T> consumer) {
        return new AbstractMap.SimpleEntry(clazz, consumer);
    }

    public static <T> T decode(String source, Class<T> clazz) {
        try {
            Class<DecoderMpm<?>> parserClass = DecodersMpmMap.getDecoder(clazz);
            Constructor<DecoderMpm<?>> ctor = parserClass.getConstructor(String.class);
            DecoderMpm<?> parser = ctor.newInstance(source);
            return clazz.cast(parser.decode());
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

