/*
 * Decompiled with CFR 0.152.
 */
package com.emv.qrcode.decoder.mpm;

import com.emv.qrcode.core.model.TagLengthString;
import com.emv.qrcode.decoder.mpm.DecodeMpmIterator;
import com.emv.qrcode.decoder.mpm.DecoderMpm;
import com.emv.qrcode.model.mpm.MerchantAccountInformation;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;

public final class MerchantAccountInformationDecoder
extends DecoderMpm<MerchantAccountInformation> {
    private static final Map<String, Map.Entry<Class<?>, BiConsumer<MerchantAccountInformation, ?>>> mapConsumers = new HashMap();

    public MerchantAccountInformationDecoder(String source) {
        super(source);
    }

    @Override
    protected MerchantAccountInformation decode() {
        MerchantAccountInformation result = new MerchantAccountInformation();
        this.iterator.forEachRemaining(value -> {
            String tag = this.derivateId(value.substring(0, DecodeMpmIterator.ID_WORD_COUNT));
            Map.Entry<Class<?>, BiConsumer<MerchantAccountInformation, ?>> entry = mapConsumers.get(tag);
            Class<?> clazz = entry.getKey();
            BiConsumer<MerchantAccountInformation, ?> consumer = entry.getValue();
            consumer.accept(result, DecoderMpm.decode(value, clazz));
        });
        return result;
    }

    private String derivateId(String id) {
        if (this.betweenPaymentNetworkSpecificRange(id)) {
            return "01";
        }
        return id;
    }

    private boolean betweenPaymentNetworkSpecificRange(String value) {
        return value.compareTo("01") >= 0 && value.compareTo("99") <= 0;
    }

    static {
        mapConsumers.put("00", MerchantAccountInformationDecoder.consumerTagLengthValue(String.class, MerchantAccountInformation::setGloballyUniqueIdentifier));
        mapConsumers.put("01", MerchantAccountInformationDecoder.consumerTagLengthValue(TagLengthString.class, MerchantAccountInformation::addPaymentNetworkSpecific));
    }
}

