/*
 * Decompiled with CFR 0.152.
 */
package com.emv.qrcode.decoder.mpm;

import com.emv.qrcode.core.model.TagLengthString;
import com.emv.qrcode.decoder.mpm.DecodeMpmIterator;
import com.emv.qrcode.decoder.mpm.DecoderMpm;
import com.emv.qrcode.model.mpm.MerchantInformationLanguage;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;

public final class MerchantInformationLanguageDecoder
extends DecoderMpm<MerchantInformationLanguage> {
    private static final Map<String, Map.Entry<Class<?>, BiConsumer<MerchantInformationLanguage, ?>>> mapConsumers = new HashMap();

    public MerchantInformationLanguageDecoder(String source) {
        super(source);
    }

    @Override
    protected MerchantInformationLanguage decode() {
        MerchantInformationLanguage result = new MerchantInformationLanguage();
        this.iterator.forEachRemaining(value -> {
            String tag = this.derivateId(value.substring(0, DecodeMpmIterator.ID_WORD_COUNT));
            Map.Entry<Class<?>, BiConsumer<MerchantInformationLanguage, ?>> entry = mapConsumers.get(tag);
            Class<?> clazz = entry.getKey();
            BiConsumer<MerchantInformationLanguage, ?> consumer = entry.getValue();
            consumer.accept(result, DecoderMpm.decode(value, clazz));
        });
        return result;
    }

    private String derivateId(String id) {
        if (this.betweenRFUForEMVCORange(id)) {
            return "03";
        }
        return id;
    }

    private boolean betweenRFUForEMVCORange(String value) {
        return value.compareTo("03") >= 0 && value.compareTo("99") <= 0;
    }

    static {
        mapConsumers.put("00", MerchantInformationLanguageDecoder.consumerTagLengthValue(String.class, MerchantInformationLanguage::setLanguagePreference));
        mapConsumers.put("01", MerchantInformationLanguageDecoder.consumerTagLengthValue(String.class, MerchantInformationLanguage::setMerchantName));
        mapConsumers.put("02", MerchantInformationLanguageDecoder.consumerTagLengthValue(String.class, MerchantInformationLanguage::setMerchantCity));
        mapConsumers.put("03", MerchantInformationLanguageDecoder.consumerTagLengthValue(TagLengthString.class, MerchantInformationLanguage::addRFUforEMVCo));
    }
}

