/*
 * Decompiled with CFR 0.152.
 */
package com.emv.qrcode.decoder.mpm;

import com.emv.qrcode.core.model.TagLengthString;
import com.emv.qrcode.decoder.mpm.DecodeMpmIterator;
import com.emv.qrcode.decoder.mpm.DecoderMpm;
import com.emv.qrcode.model.mpm.AdditionalDataFieldTemplate;
import com.emv.qrcode.model.mpm.MerchantAccountInformationTemplate;
import com.emv.qrcode.model.mpm.MerchantInformationLanguageTemplate;
import com.emv.qrcode.model.mpm.MerchantPresentedMode;
import com.emv.qrcode.model.mpm.UnreservedTemplate;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;

public final class MerchantPresentedModeDecoder
extends DecoderMpm<MerchantPresentedMode> {
    private static final Map<String, Map.Entry<Class<?>, BiConsumer<MerchantPresentedMode, ?>>> mapConsumers = new HashMap();

    public MerchantPresentedModeDecoder(String source) {
        super(source);
    }

    @Override
    protected MerchantPresentedMode decode() {
        MerchantPresentedMode result = new MerchantPresentedMode();
        result.setCRC("0000");
        this.iterator.forEachRemaining(value -> {
            String tag = this.derivateId(value.substring(0, DecodeMpmIterator.ID_WORD_COUNT));
            Map.Entry<Class<?>, BiConsumer<MerchantPresentedMode, ?>> entry = mapConsumers.get(tag);
            Class<?> clazz = entry.getKey();
            BiConsumer<MerchantPresentedMode, ?> consumer = entry.getValue();
            consumer.accept(result, DecoderMpm.decode(value, clazz));
        });
        return result;
    }

    private String derivateId(String id) {
        if (this.betweenAccountInformationRange(id)) {
            return "02";
        }
        if (this.betweenRFUForEMVCORange(id)) {
            return "65";
        }
        if (this.betweenUnreservedTemplatesRange(id)) {
            return "80";
        }
        return id;
    }

    private boolean betweenAccountInformationRange(String value) {
        return value.compareTo("02") >= 0 && value.compareTo("51") <= 0;
    }

    private boolean betweenRFUForEMVCORange(String value) {
        return value.compareTo("65") >= 0 && value.compareTo("79") <= 0;
    }

    private boolean betweenUnreservedTemplatesRange(String value) {
        return value.compareTo("80") >= 0 && value.compareTo("99") <= 0;
    }

    static {
        mapConsumers.put("00", MerchantPresentedModeDecoder.consumerTagLengthValue(String.class, MerchantPresentedMode::setPayloadFormatIndicator));
        mapConsumers.put("01", MerchantPresentedModeDecoder.consumerTagLengthValue(String.class, MerchantPresentedMode::setPointOfInitiationMethod));
        mapConsumers.put("52", MerchantPresentedModeDecoder.consumerTagLengthValue(String.class, MerchantPresentedMode::setMerchantCategoryCode));
        mapConsumers.put("53", MerchantPresentedModeDecoder.consumerTagLengthValue(String.class, MerchantPresentedMode::setTransactionCurrency));
        mapConsumers.put("54", MerchantPresentedModeDecoder.consumerTagLengthValue(String.class, MerchantPresentedMode::setTransactionAmount));
        mapConsumers.put("55", MerchantPresentedModeDecoder.consumerTagLengthValue(String.class, MerchantPresentedMode::setTipOrConvenienceIndicator));
        mapConsumers.put("56", MerchantPresentedModeDecoder.consumerTagLengthValue(String.class, MerchantPresentedMode::setValueOfConvenienceFeeFixed));
        mapConsumers.put("57", MerchantPresentedModeDecoder.consumerTagLengthValue(String.class, MerchantPresentedMode::setValueOfConvenienceFeePercentage));
        mapConsumers.put("58", MerchantPresentedModeDecoder.consumerTagLengthValue(String.class, MerchantPresentedMode::setCountryCode));
        mapConsumers.put("59", MerchantPresentedModeDecoder.consumerTagLengthValue(String.class, MerchantPresentedMode::setMerchantName));
        mapConsumers.put("60", MerchantPresentedModeDecoder.consumerTagLengthValue(String.class, MerchantPresentedMode::setMerchantCity));
        mapConsumers.put("61", MerchantPresentedModeDecoder.consumerTagLengthValue(String.class, MerchantPresentedMode::setPostalCode));
        mapConsumers.put("63", MerchantPresentedModeDecoder.consumerTagLengthValue(String.class, MerchantPresentedMode::setCRC));
        mapConsumers.put("62", MerchantPresentedModeDecoder.consumerTagLengthValue(AdditionalDataFieldTemplate.class, MerchantPresentedMode::setAdditionalDataField));
        mapConsumers.put("64", MerchantPresentedModeDecoder.consumerTagLengthValue(MerchantInformationLanguageTemplate.class, MerchantPresentedMode::setMerchantInformationLanguage));
        mapConsumers.put("02", MerchantPresentedModeDecoder.consumerTagLengthValue(MerchantAccountInformationTemplate.class, MerchantPresentedMode::addMerchantAccountInformation));
        mapConsumers.put("65", MerchantPresentedModeDecoder.consumerTagLengthValue(TagLengthString.class, MerchantPresentedMode::addRFUforEMVCo));
        mapConsumers.put("80", MerchantPresentedModeDecoder.consumerTagLengthValue(UnreservedTemplate.class, MerchantPresentedMode::addUnreserved));
        mapConsumers.put("63", MerchantPresentedModeDecoder.consumerTagLengthValue(String.class, MerchantPresentedMode::setCRC));
    }
}

