/*
 * Decompiled with CFR 0.152.
 */
package com.emv.qrcode.decoder.mpm;

import com.emv.qrcode.core.model.TagLengthString;
import com.emv.qrcode.decoder.mpm.DecodeMpmIterator;
import com.emv.qrcode.decoder.mpm.DecoderMpm;
import com.emv.qrcode.model.mpm.Unreserved;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;

public final class UnreservedDecoder
extends DecoderMpm<Unreserved> {
    private static final Map<String, Map.Entry<Class<?>, BiConsumer<Unreserved, ?>>> mapConsumers = new HashMap();

    public UnreservedDecoder(String source) {
        super(source);
    }

    @Override
    protected Unreserved decode() {
        Unreserved result = new Unreserved();
        this.iterator.forEachRemaining(value -> {
            String tag = this.derivateId(value.substring(0, DecodeMpmIterator.ID_WORD_COUNT));
            Map.Entry<Class<?>, BiConsumer<Unreserved, ?>> entry = mapConsumers.get(tag);
            Class<?> clazz = entry.getKey();
            BiConsumer<Unreserved, ?> consumer = entry.getValue();
            consumer.accept(result, DecoderMpm.decode(value, clazz));
        });
        return result;
    }

    private String derivateId(String id) {
        if (this.betweenContextSpecificDataRange(id)) {
            return "01";
        }
        return id;
    }

    private boolean betweenContextSpecificDataRange(String value) {
        return value.compareTo("01") >= 0 && value.compareTo("99") <= 0;
    }

    static {
        mapConsumers.put("00", UnreservedDecoder.consumerTagLengthValue(String.class, Unreserved::setGloballyUniqueIdentifier));
        mapConsumers.put("01", UnreservedDecoder.consumerTagLengthValue(TagLengthString.class, Unreserved::addContextSpecificData));
    }
}

