/*
 * Decompiled with CFR 0.152.
 */
package com.emv.qrcode.model.cpm;

import com.emv.qrcode.model.cpm.ApplicationTemplate;
import com.emv.qrcode.model.cpm.CommonDataTemplate;
import com.emv.qrcode.model.cpm.PayloadFormatIndicator;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;

public class ConsumerPresentedMode
implements Serializable {
    private static final long serialVersionUID = -1395429978639674565L;
    private PayloadFormatIndicator payloadFormatIndicator;
    private final List<ApplicationTemplate> applicationTemplates = new LinkedList<ApplicationTemplate>();
    private final List<CommonDataTemplate> commonDataTemplates = new LinkedList<CommonDataTemplate>();

    public void addApplicationTemplate(ApplicationTemplate applicationTemplate) {
        this.applicationTemplates.add(applicationTemplate);
    }

    public void addCommonDataTemplate(CommonDataTemplate commonDataTemplate) {
        this.commonDataTemplates.add(commonDataTemplate);
    }

    public byte[] getBytes() throws IOException {
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            if (Objects.nonNull(this.payloadFormatIndicator)) {
                out.write(this.payloadFormatIndicator.getBytes());
            }
            for (ApplicationTemplate applicationTemplate : this.applicationTemplates) {
                out.write(applicationTemplate.getBytes());
            }
            for (CommonDataTemplate commonDataTemplate : this.commonDataTemplates) {
                out.write(commonDataTemplate.getBytes());
            }
            Object object = out.toByteArray();
            return object;
        }
    }

    public String toBase64() throws IOException {
        return Base64.encodeBase64String((byte[])this.getBytes());
    }

    public String toHex() throws IOException {
        return Hex.encodeHexString((byte[])this.getBytes(), (boolean)false);
    }

    @Generated
    public PayloadFormatIndicator getPayloadFormatIndicator() {
        return this.payloadFormatIndicator;
    }

    @Generated
    public List<ApplicationTemplate> getApplicationTemplates() {
        return this.applicationTemplates;
    }

    @Generated
    public List<CommonDataTemplate> getCommonDataTemplates() {
        return this.commonDataTemplates;
    }

    @Generated
    public void setPayloadFormatIndicator(PayloadFormatIndicator payloadFormatIndicator) {
        this.payloadFormatIndicator = payloadFormatIndicator;
    }
}

