/*
 * Decompiled with CFR 0.152.
 */
package com.emv.qrcode.validators.mpm;

import br.com.fluentvalidator.AbstractValidator;
import br.com.fluentvalidator.Validator;
import br.com.fluentvalidator.builder.WheneverCollection;
import br.com.fluentvalidator.builder.WheneverProperty;
import br.com.fluentvalidator.function.FunctionBuilder;
import br.com.fluentvalidator.predicate.ComparablePredicate;
import br.com.fluentvalidator.predicate.LogicalPredicate;
import br.com.fluentvalidator.predicate.ObjectPredicate;
import br.com.fluentvalidator.predicate.StringPredicate;
import com.emv.qrcode.core.model.TagLengthString;
import com.emv.qrcode.model.mpm.AdditionalDataField;
import com.emv.qrcode.model.mpm.AdditionalDataFieldTemplate;
import com.emv.qrcode.model.mpm.MerchantInformationLanguage;
import com.emv.qrcode.model.mpm.MerchantInformationLanguageTemplate;
import com.emv.qrcode.model.mpm.MerchantPresentedMode;
import com.emv.qrcode.validators.mpm.AdditionalDataFieldTemplateValidator;
import com.emv.qrcode.validators.mpm.MerchantAccountInformationTemplateValidator;
import com.emv.qrcode.validators.mpm.MerchantInformationLanguageTemplateValidator;
import com.emv.qrcode.validators.mpm.TagLengthStringValidator;
import com.emv.qrcode.validators.mpm.UnreservedTemplateValidator;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;

public class MerchantPresentedModeValidator
extends AbstractValidator<MerchantPresentedMode> {
    private static final String REGEX_NUMBER = "^((\\d*)(\\.)?(\\d{0,2})?)$";
    private static final String REGEX_PERCENTAGE = "^(\\d{0,2}(\\.)?(\\.\\d{0,2})?|100(\\.)?(\\.00?)?)$";

    public void rules() {
        this.failFastRule();
        this.ruleFor("PayloadFormatIndicator", MerchantPresentedMode::getPayloadFormatIndicator).must(LogicalPredicate.not((Predicate)StringPredicate.stringEmptyOrNull(TagLengthString::getTag))).withMessage("PayloadFormatIndicator tag is mandatory").withAttempedValue(FunctionBuilder.of(MerchantPresentedMode::getPayloadFormatIndicator).andThen(TagLengthString::getTag)).critical().must(StringPredicate.stringSize(TagLengthString::getTag, (Integer)2)).withMessage("PayloadFormatIndicator tag must be size equal two").withAttempedValue(FunctionBuilder.of(MerchantPresentedMode::getPayloadFormatIndicator).andThen(TagLengthString::getTag)).critical().must(StringPredicate.isNumeric(TagLengthString::getTag)).withMessage("PayloadFormatIndicator tag must be number").withAttempedValue(FunctionBuilder.of(MerchantPresentedMode::getPayloadFormatIndicator).andThen(TagLengthString::getTag)).critical().must(StringPredicate.stringEquals(TagLengthString::getTag, (String)"00")).withMessage(String.format("PayloadFormatIndicator tag must be '%s'", "00")).withAttempedValue(FunctionBuilder.of(MerchantPresentedMode::getPayloadFormatIndicator).andThen(TagLengthString::getTag)).critical().must(LogicalPredicate.not((Predicate)StringPredicate.stringEmptyOrNull(TagLengthString::getValue))).withMessage("PayloadFormatIndicator value is mandatory").withAttempedValue(FunctionBuilder.of(MerchantPresentedMode::getPayloadFormatIndicator).andThen(TagLengthString::getValue)).critical().must(StringPredicate.isNumeric(TagLengthString::getValue)).withMessage("PayloadFormatIndicator value must be number").withAttempedValue(FunctionBuilder.of(MerchantPresentedMode::getPayloadFormatIndicator).andThen(TagLengthString::getValue)).critical().must(StringPredicate.stringSize(TagLengthString::getValue, (Integer)2)).withMessage("PayloadFormatIndicator value must be size equal two").withAttempedValue(FunctionBuilder.of(MerchantPresentedMode::getPayloadFormatIndicator).andThen(TagLengthString::getValue)).critical().must(ComparablePredicate.equalTo(TagLengthString::getValue, (Comparable)((Object)"01"))).withMessage("PayloadFormatIndicator value must be '01'").withAttempedValue(FunctionBuilder.of(MerchantPresentedMode::getPayloadFormatIndicator).andThen(TagLengthString::getValue)).critical();
        this.ruleFor("PointOfInitiationMethod", MerchantPresentedMode::getPointOfInitiationMethod).must(LogicalPredicate.not((Predicate)StringPredicate.stringEmptyOrNull(TagLengthString::getTag))).when(LogicalPredicate.not((Predicate)ObjectPredicate.nullValue())).withMessage("PointOfInitiationMethod tag is mandatory").withAttempedValue(FunctionBuilder.of(MerchantPresentedMode::getPointOfInitiationMethod).andThen(TagLengthString::getTag)).critical().must(StringPredicate.stringSize(TagLengthString::getTag, (Integer)2)).when(LogicalPredicate.not((Predicate)ObjectPredicate.nullValue())).withMessage("PointOfInitiationMethod tag must be size equal two").withAttempedValue(FunctionBuilder.of(MerchantPresentedMode::getPointOfInitiationMethod).andThen(TagLengthString::getTag)).critical().must(StringPredicate.isNumeric(TagLengthString::getTag)).when(LogicalPredicate.not((Predicate)ObjectPredicate.nullValue())).withMessage("PointOfInitiationMethod tag must be number").withAttempedValue(FunctionBuilder.of(MerchantPresentedMode::getPointOfInitiationMethod).andThen(TagLengthString::getTag)).critical().must(StringPredicate.stringEquals(TagLengthString::getTag, (String)"01")).when(LogicalPredicate.not((Predicate)ObjectPredicate.nullValue())).withMessage(String.format("PointOfInitiationMethod tag must be '%s'", "01")).withAttempedValue(FunctionBuilder.of(MerchantPresentedMode::getPointOfInitiationMethod).andThen(TagLengthString::getTag)).critical().must(StringPredicate.isNumeric(TagLengthString::getValue)).when(LogicalPredicate.not((Predicate)ObjectPredicate.nullValue())).withMessage("PointOfInitiationMethod value should be numeric").withAttempedValue(FunctionBuilder.of(MerchantPresentedMode::getPointOfInitiationMethod).andThen(TagLengthString::getValue)).critical().must(StringPredicate.stringSize(TagLengthString::getValue, (Integer)2)).when(LogicalPredicate.not((Predicate)ObjectPredicate.nullValue())).withMessage("PointOfInitiationMethod value must be size equal two").withAttempedValue(FunctionBuilder.of(MerchantPresentedMode::getPointOfInitiationMethod).andThen(TagLengthString::getValue)).critical().must(ComparablePredicate.equalTo(TagLengthString::getValue, (Comparable)((Object)"11")).or(ComparablePredicate.equalTo(TagLengthString::getValue, (Comparable)((Object)"12")))).when(LogicalPredicate.not((Predicate)ObjectPredicate.nullValue())).withMessage("PointOfInitiationMethod value should be '11' or '12'").withAttempedValue(FunctionBuilder.of(MerchantPresentedMode::getPointOfInitiationMethod).andThen(TagLengthString::getValue)).critical();
        this.ruleFor("MerchantCategoryCode", MerchantPresentedMode::getMerchantCategoryCode).must(LogicalPredicate.not((Predicate)StringPredicate.stringEmptyOrNull(TagLengthString::getTag))).withMessage("MerchantCategoryCode tag is mandatory").withAttempedValue(FunctionBuilder.of(MerchantPresentedMode::getMerchantCategoryCode).andThen(TagLengthString::getTag)).critical().must(StringPredicate.stringSize(TagLengthString::getTag, (Integer)2)).withMessage("MerchantCategoryCode tag must be size equal two").withAttempedValue(FunctionBuilder.of(MerchantPresentedMode::getMerchantCategoryCode).andThen(TagLengthString::getTag)).critical().must(StringPredicate.isNumeric(TagLengthString::getTag)).withMessage("MerchantCategoryCode tag must be number").withAttempedValue(FunctionBuilder.of(MerchantPresentedMode::getMerchantCategoryCode).andThen(TagLengthString::getTag)).critical().must(StringPredicate.stringEquals(TagLengthString::getTag, (String)"52")).withMessage(String.format("MerchantCategoryCode tag must be '%s'", "52")).withAttempedValue(FunctionBuilder.of(MerchantPresentedMode::getMerchantCategoryCode).andThen(TagLengthString::getTag)).critical().must(LogicalPredicate.not((Predicate)StringPredicate.stringEmptyOrNull(TagLengthString::getValue))).withMessage("MerchantCategoryCode value is mandatory").withAttempedValue(FunctionBuilder.of(MerchantPresentedMode::getMerchantCategoryCode).andThen(TagLengthString::getValue)).critical().must(StringPredicate.isNumeric(TagLengthString::getValue)).withMessage("MerchantCategoryCode value must be number").withAttempedValue(FunctionBuilder.of(MerchantPresentedMode::getMerchantCategoryCode).andThen(TagLengthString::getValue)).critical().must(StringPredicate.stringSize(TagLengthString::getValue, (Integer)4)).withMessage("MerchantCategoryCode value must be size equal four").withAttempedValue(FunctionBuilder.of(MerchantPresentedMode::getMerchantCategoryCode).andThen(TagLengthString::getValue)).critical();
        this.ruleFor("TransactionCurrency", MerchantPresentedMode::getTransactionCurrency).must(LogicalPredicate.not((Predicate)StringPredicate.stringEmptyOrNull(TagLengthString::getTag))).withMessage("TransactionCurrency tag is mandatory").withAttempedValue(FunctionBuilder.of(MerchantPresentedMode::getTransactionCurrency).andThen(TagLengthString::getTag)).critical().must(StringPredicate.stringSize(TagLengthString::getTag, (Integer)2)).withMessage("TransactionCurrency tag must be size equal two").withAttempedValue(FunctionBuilder.of(MerchantPresentedMode::getTransactionCurrency).andThen(TagLengthString::getTag)).critical().must(StringPredicate.isNumeric(TagLengthString::getTag)).withMessage("TransactionCurrency tag must be number").withAttempedValue(FunctionBuilder.of(MerchantPresentedMode::getTransactionCurrency).andThen(TagLengthString::getTag)).critical().must(StringPredicate.stringEquals(TagLengthString::getTag, (String)"53")).withMessage(String.format("TransactionCurrency tag must be '%s'", "53")).withAttempedValue(FunctionBuilder.of(MerchantPresentedMode::getTransactionCurrency).andThen(TagLengthString::getTag)).critical().must(LogicalPredicate.not((Predicate)StringPredicate.stringEmptyOrNull(TagLengthString::getValue))).withMessage("TransactionCurrency value is mandatory").withAttempedValue(FunctionBuilder.of(MerchantPresentedMode::getTransactionCurrency).andThen(TagLengthString::getValue)).critical().must(StringPredicate.isNumeric(TagLengthString::getValue)).withMessage("TransactionCurrency value must be number").withAttempedValue(FunctionBuilder.of(MerchantPresentedMode::getTransactionCurrency).andThen(TagLengthString::getValue)).critical().must(StringPredicate.stringSize(TagLengthString::getValue, (Integer)3)).withMessage("TransactionCurrency value must be size equal three").withAttempedValue(FunctionBuilder.of(MerchantPresentedMode::getTransactionCurrency).andThen(TagLengthString::getValue)).critical();
        this.ruleFor("TransactionAmount", MerchantPresentedMode::getTransactionAmount).must(LogicalPredicate.not((Predicate)StringPredicate.stringEmptyOrNull(TagLengthString::getTag))).when(LogicalPredicate.not((Predicate)ObjectPredicate.nullValue())).withMessage("TransactionAmount tag is mandatory").withAttempedValue(FunctionBuilder.of(MerchantPresentedMode::getTransactionAmount).andThen(TagLengthString::getTag)).critical().must(StringPredicate.stringSize(TagLengthString::getTag, (Integer)2)).when(LogicalPredicate.not((Predicate)ObjectPredicate.nullValue())).withMessage("TransactionAmount tag must be size equal two").withAttempedValue(FunctionBuilder.of(MerchantPresentedMode::getTransactionAmount).andThen(TagLengthString::getTag)).critical().must(StringPredicate.isNumeric(TagLengthString::getTag)).when(LogicalPredicate.not((Predicate)ObjectPredicate.nullValue())).withMessage("TransactionAmount tag must be number").withAttempedValue(FunctionBuilder.of(MerchantPresentedMode::getTransactionAmount).andThen(TagLengthString::getTag)).critical().must(StringPredicate.stringEquals(TagLengthString::getTag, (String)"54")).when(LogicalPredicate.not((Predicate)ObjectPredicate.nullValue())).withMessage(String.format("TransactionAmount tag must be '%s'", "54")).withAttempedValue(FunctionBuilder.of(MerchantPresentedMode::getTransactionAmount).andThen(TagLengthString::getTag)).critical().must(LogicalPredicate.not((Predicate)StringPredicate.stringEmptyOrNull(TagLengthString::getValue))).when(LogicalPredicate.not((Predicate)ObjectPredicate.nullValue())).withMessage("TransactionAmount value is mandatory").withAttempedValue(FunctionBuilder.of(MerchantPresentedMode::getTransactionAmount).andThen(TagLengthString::getValue)).critical().must(StringPredicate.stringSizeLessThanOrEqual(TagLengthString::getValue, (Integer)13)).when(LogicalPredicate.not((Predicate)ObjectPredicate.nullValue())).withMessage("TransactionAmount value must be less then or equal size thirteen").withAttempedValue(FunctionBuilder.of(MerchantPresentedMode::getTransactionAmount).andThen(TagLengthString::getValue)).critical().must(StringPredicate.stringMatches(TagLengthString::getValue, (String)REGEX_NUMBER)).when(LogicalPredicate.not((Predicate)ObjectPredicate.nullValue())).withMessage("TransactionAmount value must be a valid number").withAttempedValue(FunctionBuilder.of(MerchantPresentedMode::getTransactionAmount).andThen(TagLengthString::getValue)).critical();
        this.ruleFor("TipOrConvenienceIndicator", MerchantPresentedMode::getTipOrConvenienceIndicator).must(LogicalPredicate.not((Predicate)StringPredicate.stringEmptyOrNull(TagLengthString::getTag))).when(LogicalPredicate.not((Predicate)ObjectPredicate.nullValue())).withMessage("TipOrConvenienceIndicator tag is mandatory").withAttempedValue(FunctionBuilder.of(MerchantPresentedMode::getTipOrConvenienceIndicator).andThen(TagLengthString::getTag)).critical().must(StringPredicate.stringSize(TagLengthString::getTag, (Integer)2)).when(LogicalPredicate.not((Predicate)ObjectPredicate.nullValue())).withMessage("TipOrConvenienceIndicator tag must be size equal two").withAttempedValue(FunctionBuilder.of(MerchantPresentedMode::getTipOrConvenienceIndicator).andThen(TagLengthString::getTag)).critical().must(StringPredicate.isNumeric(TagLengthString::getTag)).when(LogicalPredicate.not((Predicate)ObjectPredicate.nullValue())).withMessage("TipOrConvenienceIndicator tag must be number").withAttempedValue(FunctionBuilder.of(MerchantPresentedMode::getTipOrConvenienceIndicator).andThen(TagLengthString::getTag)).critical().must(StringPredicate.stringEquals(TagLengthString::getTag, (String)"55")).when(LogicalPredicate.not((Predicate)ObjectPredicate.nullValue())).withMessage(String.format("TipOrConvenienceIndicator tag must be '%s'", "55")).withAttempedValue(FunctionBuilder.of(MerchantPresentedMode::getTipOrConvenienceIndicator).andThen(TagLengthString::getTag)).critical().must(LogicalPredicate.not((Predicate)StringPredicate.stringEmptyOrNull(TagLengthString::getValue))).when(LogicalPredicate.not((Predicate)ObjectPredicate.nullValue())).withMessage("TipOrConvenienceIndicator value is mandatory").withAttempedValue(FunctionBuilder.of(MerchantPresentedMode::getTipOrConvenienceIndicator).andThen(TagLengthString::getValue)).critical().must(StringPredicate.isNumeric(TagLengthString::getValue)).when(LogicalPredicate.not((Predicate)ObjectPredicate.nullValue())).withMessage("TipOrConvenienceIndicator value must be number").withAttempedValue(FunctionBuilder.of(MerchantPresentedMode::getTipOrConvenienceIndicator).andThen(TagLengthString::getValue)).critical().must(StringPredicate.stringSize(TagLengthString::getValue, (Integer)2)).when(LogicalPredicate.not((Predicate)ObjectPredicate.nullValue())).withMessage("TipOrConvenienceIndicator value must be size equal two").withAttempedValue(FunctionBuilder.of(MerchantPresentedMode::getTipOrConvenienceIndicator).andThen(TagLengthString::getValue)).critical().must(StringPredicate.stringEquals(TagLengthString::getValue, (String)"01").or(StringPredicate.stringEquals(TagLengthString::getValue, (String)"02").or(StringPredicate.stringEquals(TagLengthString::getValue, (String)"03")))).when(LogicalPredicate.not((Predicate)ObjectPredicate.nullValue())).withMessage("TipOrConvenienceIndicator value shall contain a value of '01', '02' or '03'").withAttempedValue(FunctionBuilder.of(MerchantPresentedMode::getTipOrConvenienceIndicator).andThen(TagLengthString::getValue)).critical();
        this.ruleFor("ValueOfConvenienceFeeFixed", MerchantPresentedMode::getValueOfConvenienceFeeFixed).must(LogicalPredicate.not((Predicate)StringPredicate.stringEmptyOrNull(TagLengthString::getTag))).when(LogicalPredicate.not((Predicate)ObjectPredicate.nullValue())).withMessage("ValueOfConvenienceFeeFixed tag is mandatory").withAttempedValue(FunctionBuilder.of(MerchantPresentedMode::getValueOfConvenienceFeeFixed).andThen(TagLengthString::getTag)).critical().must(StringPredicate.stringSize(TagLengthString::getTag, (Integer)2)).when(LogicalPredicate.not((Predicate)ObjectPredicate.nullValue())).withMessage("ValueOfConvenienceFeeFixed tag must be size equal two").withAttempedValue(FunctionBuilder.of(MerchantPresentedMode::getValueOfConvenienceFeeFixed).andThen(TagLengthString::getTag)).critical().must(StringPredicate.isNumeric(TagLengthString::getTag)).when(LogicalPredicate.not((Predicate)ObjectPredicate.nullValue())).withMessage("ValueOfConvenienceFeeFixed tag must be number").withAttempedValue(FunctionBuilder.of(MerchantPresentedMode::getValueOfConvenienceFeeFixed).andThen(TagLengthString::getTag)).critical().must(StringPredicate.stringEquals(TagLengthString::getTag, (String)"56")).when(LogicalPredicate.not((Predicate)ObjectPredicate.nullValue())).withMessage(String.format("ValueOfConvenienceFeeFixed tag must be '%s'", "56")).withAttempedValue(FunctionBuilder.of(MerchantPresentedMode::getValueOfConvenienceFeeFixed).andThen(TagLengthString::getTag)).critical().must(LogicalPredicate.not((Predicate)StringPredicate.stringEmptyOrNull(TagLengthString::getValue))).when(LogicalPredicate.not((Predicate)ObjectPredicate.nullValue())).withMessage("ValueOfConvenienceFeeFixed value is mandatory").withAttempedValue(FunctionBuilder.of(MerchantPresentedMode::getValueOfConvenienceFeeFixed).andThen(TagLengthString::getValue)).critical().must(StringPredicate.stringSizeLessThanOrEqual(TagLengthString::getValue, (Integer)13)).when(LogicalPredicate.not((Predicate)ObjectPredicate.nullValue())).withMessage("ValueOfConvenienceFeeFixed value must be less then or equal size thirteen").withAttempedValue(FunctionBuilder.of(MerchantPresentedMode::getValueOfConvenienceFeeFixed).andThen(TagLengthString::getValue)).critical().must(StringPredicate.stringMatches(TagLengthString::getValue, (String)REGEX_NUMBER)).when(LogicalPredicate.not((Predicate)ObjectPredicate.nullValue())).withMessage("ValueOfConvenienceFeeFixed value must be a valid number").withAttempedValue(FunctionBuilder.of(MerchantPresentedMode::getValueOfConvenienceFeeFixed).andThen(TagLengthString::getValue)).critical();
        this.ruleFor("ValueOfConvenienceFeePercentage", MerchantPresentedMode::getValueOfConvenienceFeePercentage).must(LogicalPredicate.not((Predicate)StringPredicate.stringEmptyOrNull(TagLengthString::getTag))).when(LogicalPredicate.not((Predicate)ObjectPredicate.nullValue())).withMessage("ValueOfConvenienceFeePercentage tag is mandatory").withAttempedValue(FunctionBuilder.of(MerchantPresentedMode::getValueOfConvenienceFeePercentage).andThen(TagLengthString::getTag)).critical().must(StringPredicate.stringSize(TagLengthString::getTag, (Integer)2)).when(LogicalPredicate.not((Predicate)ObjectPredicate.nullValue())).withMessage("ValueOfConvenienceFeePercentage tag must be size equal two").withAttempedValue(FunctionBuilder.of(MerchantPresentedMode::getValueOfConvenienceFeePercentage).andThen(TagLengthString::getTag)).critical().must(StringPredicate.isNumeric(TagLengthString::getTag)).when(LogicalPredicate.not((Predicate)ObjectPredicate.nullValue())).withMessage("ValueOfConvenienceFeePercentage tag must be number").withAttempedValue(FunctionBuilder.of(MerchantPresentedMode::getValueOfConvenienceFeePercentage).andThen(TagLengthString::getTag)).critical().must(StringPredicate.stringEquals(TagLengthString::getTag, (String)"57")).when(LogicalPredicate.not((Predicate)ObjectPredicate.nullValue())).withMessage(String.format("ValueOfConvenienceFeePercentage tag must be '%s'", "57")).withAttempedValue(FunctionBuilder.of(MerchantPresentedMode::getValueOfConvenienceFeePercentage).andThen(TagLengthString::getTag)).critical().must(LogicalPredicate.not((Predicate)StringPredicate.stringEmptyOrNull(TagLengthString::getValue))).when(LogicalPredicate.not((Predicate)ObjectPredicate.nullValue())).withMessage("ValueOfConvenienceFeePercentage value is mandatory").withAttempedValue(FunctionBuilder.of(MerchantPresentedMode::getValueOfConvenienceFeePercentage).andThen(TagLengthString::getValue)).critical().must(StringPredicate.stringSizeLessThanOrEqual(TagLengthString::getValue, (Integer)5)).when(LogicalPredicate.not((Predicate)ObjectPredicate.nullValue())).withMessage("ValueOfConvenienceFeePercentage value must be less then or equal size five").withAttempedValue(FunctionBuilder.of(MerchantPresentedMode::getValueOfConvenienceFeePercentage).andThen(TagLengthString::getValue)).critical().must(StringPredicate.stringMatches(TagLengthString::getValue, (String)REGEX_PERCENTAGE)).when(LogicalPredicate.not((Predicate)ObjectPredicate.nullValue())).withMessage("ValueOfConvenienceFeePercentage value must be a valid percentage").withAttempedValue(FunctionBuilder.of(MerchantPresentedMode::getValueOfConvenienceFeePercentage).andThen(TagLengthString::getValue)).critical().must(ComparablePredicate.betweenInclusive(MerchantPresentedModeValidator.convertToBigDecimal(TagLengthString::getValue), (Comparable)new BigDecimal("00.01"), (Comparable)new BigDecimal("99.99"))).when(LogicalPredicate.not((Predicate)ObjectPredicate.nullValue())).withMessage("ValueOfConvenienceFeePercentage value must be between '00.01' and '99.99'").withAttempedValue(FunctionBuilder.of(MerchantPresentedMode::getValueOfConvenienceFeePercentage).andThen(TagLengthString::getValue)).critical();
        this.ruleFor("CountryCode", MerchantPresentedMode::getCountryCode).must(LogicalPredicate.not((Predicate)StringPredicate.stringEmptyOrNull(TagLengthString::getTag))).withMessage("CountryCode tag is mandatory").withAttempedValue(FunctionBuilder.of(MerchantPresentedMode::getCountryCode).andThen(TagLengthString::getTag)).critical().must(StringPredicate.stringSize(TagLengthString::getTag, (Integer)2)).withMessage("CountryCode tag must be size equal two").withAttempedValue(FunctionBuilder.of(MerchantPresentedMode::getCountryCode).andThen(TagLengthString::getTag)).critical().must(StringPredicate.isNumeric(TagLengthString::getTag)).withMessage("CountryCode tag must be number").withAttempedValue(FunctionBuilder.of(MerchantPresentedMode::getCountryCode).andThen(TagLengthString::getTag)).critical().must(StringPredicate.stringEquals(TagLengthString::getTag, (String)"58")).withMessage(String.format("CountryCode tag must be '%s'", "58")).withAttempedValue(FunctionBuilder.of(MerchantPresentedMode::getCountryCode).andThen(TagLengthString::getTag)).critical().must(LogicalPredicate.not((Predicate)StringPredicate.stringEmptyOrNull(TagLengthString::getValue))).withMessage("CountryCode value is mandatory").withAttempedValue(FunctionBuilder.of(MerchantPresentedMode::getCountryCode).andThen(TagLengthString::getValue)).critical().must(StringPredicate.stringSize(TagLengthString::getValue, (Integer)2)).withMessage("CountryCode value must be size equal two").withAttempedValue(FunctionBuilder.of(MerchantPresentedMode::getCountryCode).andThen(TagLengthString::getValue)).critical();
        this.ruleFor("MerchantName", MerchantPresentedMode::getMerchantName).must(LogicalPredicate.not((Predicate)StringPredicate.stringEmptyOrNull(TagLengthString::getTag))).withMessage("MerchantName tag is mandatory").withAttempedValue(FunctionBuilder.of(MerchantPresentedMode::getMerchantName).andThen(TagLengthString::getTag)).critical().must(StringPredicate.stringSize(TagLengthString::getTag, (Integer)2)).withMessage("MerchantName tag must be size equal two").withAttempedValue(FunctionBuilder.of(MerchantPresentedMode::getMerchantName).andThen(TagLengthString::getTag)).critical().must(StringPredicate.isNumeric(TagLengthString::getTag)).withMessage("MerchantName tag must be number").withAttempedValue(FunctionBuilder.of(MerchantPresentedMode::getMerchantName).andThen(TagLengthString::getTag)).critical().must(StringPredicate.stringEquals(TagLengthString::getTag, (String)"59")).withMessage(String.format("MerchantName tag must be '%s'", "59")).withAttempedValue(FunctionBuilder.of(MerchantPresentedMode::getMerchantName).andThen(TagLengthString::getTag)).critical().must(LogicalPredicate.not((Predicate)StringPredicate.stringEmptyOrNull(TagLengthString::getValue))).withMessage("MerchantName value is mandatory").withAttempedValue(FunctionBuilder.of(MerchantPresentedMode::getMerchantName).andThen(TagLengthString::getValue)).critical().must(StringPredicate.stringSizeLessThanOrEqual(TagLengthString::getValue, (Integer)25)).withMessage("MerchantName value must less than or equal size equal twenty-five").withAttempedValue(FunctionBuilder.of(MerchantPresentedMode::getMerchantName).andThen(TagLengthString::getValue)).critical();
        this.ruleFor("MerchantCity", MerchantPresentedMode::getMerchantCity).must(LogicalPredicate.not((Predicate)StringPredicate.stringEmptyOrNull(TagLengthString::getTag))).withMessage("MerchantCity tag is mandatory").withAttempedValue(FunctionBuilder.of(MerchantPresentedMode::getMerchantCity).andThen(TagLengthString::getTag)).critical().must(StringPredicate.stringSize(TagLengthString::getTag, (Integer)2)).withMessage("MerchantCity tag must be size equal two").withAttempedValue(FunctionBuilder.of(MerchantPresentedMode::getMerchantCity).andThen(TagLengthString::getTag)).critical().must(StringPredicate.isNumeric(TagLengthString::getTag)).withMessage("MerchantCity tag must be number").withAttempedValue(FunctionBuilder.of(MerchantPresentedMode::getMerchantCity).andThen(TagLengthString::getTag)).critical().must(StringPredicate.stringEquals(TagLengthString::getTag, (String)"60")).withMessage(String.format("MerchantCity tag must be '%s'", "60")).withAttempedValue(FunctionBuilder.of(MerchantPresentedMode::getMerchantCity).andThen(TagLengthString::getTag)).critical().must(LogicalPredicate.not((Predicate)StringPredicate.stringEmptyOrNull(TagLengthString::getValue))).withMessage("MerchantCity value is mandatory").withAttempedValue(FunctionBuilder.of(MerchantPresentedMode::getMerchantCity).andThen(TagLengthString::getValue)).critical().must(StringPredicate.stringSizeLessThanOrEqual(TagLengthString::getValue, (Integer)15)).withMessage("MerchantCity value is must less than or equal size fifteen").withAttempedValue(FunctionBuilder.of(MerchantPresentedMode::getMerchantCity).andThen(TagLengthString::getValue)).critical();
        this.ruleFor("PostalCode", MerchantPresentedMode::getPostalCode).must(LogicalPredicate.not((Predicate)StringPredicate.stringEmptyOrNull(TagLengthString::getTag))).when(LogicalPredicate.not((Predicate)ObjectPredicate.nullValue())).withMessage("PostalCode tag is mandatory").withAttempedValue(FunctionBuilder.of(MerchantPresentedMode::getPostalCode).andThen(TagLengthString::getTag)).critical().must(StringPredicate.stringSize(TagLengthString::getTag, (Integer)2)).when(LogicalPredicate.not((Predicate)ObjectPredicate.nullValue())).withMessage("PostalCode tag must be size equal two").withAttempedValue(FunctionBuilder.of(MerchantPresentedMode::getPostalCode).andThen(TagLengthString::getTag)).critical().must(StringPredicate.isNumeric(TagLengthString::getTag)).when(LogicalPredicate.not((Predicate)ObjectPredicate.nullValue())).withMessage("PostalCode tag must be number").withAttempedValue(FunctionBuilder.of(MerchantPresentedMode::getPostalCode).andThen(TagLengthString::getTag)).critical().must(StringPredicate.stringEquals(TagLengthString::getTag, (String)"61")).when(LogicalPredicate.not((Predicate)ObjectPredicate.nullValue())).withMessage(String.format("PostalCode tag must be '%s'", "61")).withAttempedValue(FunctionBuilder.of(MerchantPresentedMode::getPostalCode).andThen(TagLengthString::getTag)).critical().must(LogicalPredicate.not((Predicate)StringPredicate.stringEmptyOrNull(TagLengthString::getValue))).when(LogicalPredicate.not((Predicate)ObjectPredicate.nullValue())).withMessage("PostalCode value is mandatory").withAttempedValue(FunctionBuilder.of(MerchantPresentedMode::getPostalCode).andThen(TagLengthString::getValue)).critical().must(StringPredicate.stringSizeLessThanOrEqual(TagLengthString::getValue, (Integer)10)).when(LogicalPredicate.not((Predicate)ObjectPredicate.nullValue())).withMessage("PostalCode value must less then or equal size ten").withAttempedValue(FunctionBuilder.of(MerchantPresentedMode::getPostalCode).andThen(TagLengthString::getValue)).critical();
        ((WheneverProperty)this.ruleFor("AdditionalDataField", MerchantPresentedMode::getAdditionalDataField).must(LogicalPredicate.not((Predicate)StringPredicate.stringEmptyOrNull(AdditionalDataFieldTemplate::getTag))).when(LogicalPredicate.not((Predicate)ObjectPredicate.nullValue())).withMessage("AdditionalDataField tag is mandatory").withAttempedValue(FunctionBuilder.of(MerchantPresentedMode::getAdditionalDataField).andThen(AdditionalDataFieldTemplate::getTag)).critical().must(StringPredicate.stringSize(AdditionalDataFieldTemplate::getTag, (Integer)2)).when(LogicalPredicate.not((Predicate)ObjectPredicate.nullValue())).withMessage("AdditionalDataField tag must be size equal two").withAttempedValue(FunctionBuilder.of(MerchantPresentedMode::getAdditionalDataField).andThen(AdditionalDataFieldTemplate::getTag)).critical().must(StringPredicate.isNumeric(AdditionalDataFieldTemplate::getTag)).when(LogicalPredicate.not((Predicate)ObjectPredicate.nullValue())).withMessage("AdditionalDataField tag must be number").withAttempedValue(FunctionBuilder.of(MerchantPresentedMode::getAdditionalDataField).andThen(AdditionalDataFieldTemplate::getTag)).critical().must(StringPredicate.stringEquals(AdditionalDataFieldTemplate::getTag, (String)"62")).when(LogicalPredicate.not((Predicate)ObjectPredicate.nullValue())).withMessage(String.format("AdditionalDataField tag must be '%s'", "62")).withAttempedValue(FunctionBuilder.of(MerchantPresentedMode::getAdditionalDataField).andThen(AdditionalDataFieldTemplate::getTag)).critical().must(LogicalPredicate.not((Predicate)ObjectPredicate.nullValue(AdditionalDataFieldTemplate::getValue))).when(LogicalPredicate.not((Predicate)ObjectPredicate.nullValue())).withMessage("AdditionalDataField value must be not null").withAttempedValue(FunctionBuilder.of(MerchantPresentedMode::getAdditionalDataField).andThen(AdditionalDataFieldTemplate::getValue)).critical().must(StringPredicate.stringSizeLessThanOrEqual(FunctionBuilder.of(AdditionalDataFieldTemplate::getValue).andThen(AdditionalDataField::toString), (Integer)99)).when(LogicalPredicate.not((Predicate)ObjectPredicate.nullValue())).withMessage("AdditionalDataField value must less then or equal size ninety-nine").withAttempedValue(FunctionBuilder.of(MerchantPresentedMode::getAdditionalDataField).andThen(AdditionalDataFieldTemplate::toString)).critical().whenever(LogicalPredicate.not((Predicate)ObjectPredicate.nullValue(AdditionalDataFieldTemplate::getValue)))).withValidator((Validator)new AdditionalDataFieldTemplateValidator());
        ((WheneverProperty)this.ruleFor("MerchantInformationLanguage", MerchantPresentedMode::getMerchantInformationLanguage).must(LogicalPredicate.not((Predicate)StringPredicate.stringEmptyOrNull(MerchantInformationLanguageTemplate::getTag))).when(LogicalPredicate.not((Predicate)ObjectPredicate.nullValue())).withMessage("MerchantInformationLanguage tag is mandatory").withAttempedValue(FunctionBuilder.of(MerchantPresentedMode::getMerchantInformationLanguage).andThen(MerchantInformationLanguageTemplate::getTag)).critical().must(StringPredicate.stringSize(MerchantInformationLanguageTemplate::getTag, (Integer)2)).when(LogicalPredicate.not((Predicate)ObjectPredicate.nullValue())).withMessage("MerchantInformationLanguage tag must be size equal two").withAttempedValue(FunctionBuilder.of(MerchantPresentedMode::getMerchantInformationLanguage).andThen(MerchantInformationLanguageTemplate::getTag)).critical().must(StringPredicate.isNumeric(MerchantInformationLanguageTemplate::getTag)).when(LogicalPredicate.not((Predicate)ObjectPredicate.nullValue())).withMessage("MerchantInformationLanguage tag must be number").withAttempedValue(FunctionBuilder.of(MerchantPresentedMode::getMerchantInformationLanguage).andThen(MerchantInformationLanguageTemplate::getTag)).critical().must(StringPredicate.stringEquals(MerchantInformationLanguageTemplate::getTag, (String)"64")).when(LogicalPredicate.not((Predicate)ObjectPredicate.nullValue())).withMessage(String.format("MerchantInformationLanguage tag must be '%s'", "64")).withAttempedValue(FunctionBuilder.of(MerchantPresentedMode::getMerchantInformationLanguage).andThen(MerchantInformationLanguageTemplate::getTag)).critical().must(StringPredicate.stringSizeLessThanOrEqual(FunctionBuilder.of(MerchantInformationLanguageTemplate::getValue).andThen(MerchantInformationLanguage::toString), (Integer)99)).when(LogicalPredicate.not((Predicate)ObjectPredicate.nullValue())).withMessage("MerchantInformationLanguage value must less then or equal size ninety-nine").withAttempedValue(FunctionBuilder.of(MerchantPresentedMode::getAdditionalDataField).andThen(AdditionalDataFieldTemplate::toString)).critical().whenever(LogicalPredicate.not((Predicate)ObjectPredicate.nullValue()))).withValidator((Validator)new MerchantInformationLanguageTemplateValidator());
        this.ruleFor(merchantPresentMode -> merchantPresentMode).must(ObjectPredicate.nullValue((Function)FunctionBuilder.of(MerchantPresentedMode::getValueOfConvenienceFeeFixed)).and(ObjectPredicate.nullValue((Function)FunctionBuilder.of(MerchantPresentedMode::getValueOfConvenienceFeePercentage)))).when(StringPredicate.stringEquals(FunctionBuilder.of(MerchantPresentedMode::getTipOrConvenienceIndicator).andThen(TagLengthString::getValue), (String)"01")).withMessage("When TipOrConvenienceIndicator is '01' ValueOfConvenienceFeeFixed and ValueOfConvenienceFeePercentage must be null").withAttempedValue(merchantPresentMode -> {
            LinkedList attemptedValue = new LinkedList();
            Optional.ofNullable(merchantPresentMode.getValueOfConvenienceFeeFixed()).ifPresent(obj -> attemptedValue.add(obj.toString()));
            Optional.ofNullable(merchantPresentMode.getValueOfConvenienceFeePercentage()).ifPresent(obj -> attemptedValue.add(obj.toString()));
            return attemptedValue;
        }).withFieldName(merchantPresentMode -> {
            LinkedList fieldNames = new LinkedList();
            Optional.ofNullable(merchantPresentMode.getValueOfConvenienceFeeFixed()).ifPresent(obj -> fieldNames.add("ValueOfConvenienceFeeFixed"));
            Optional.ofNullable(merchantPresentMode.getValueOfConvenienceFeePercentage()).ifPresent(obj -> fieldNames.add("ValueOfConvenienceFeePercentage"));
            return String.join((CharSequence)",", fieldNames);
        }).must(ObjectPredicate.nullValue((Function)FunctionBuilder.of(MerchantPresentedMode::getValueOfConvenienceFeePercentage))).when(StringPredicate.stringEquals(FunctionBuilder.of(MerchantPresentedMode::getTipOrConvenienceIndicator).andThen(TagLengthString::getValue), (String)"02")).withMessage("When TipOrConvenienceIndicator is '02' ValueOfConvenienceFeePercentage must be null").withAttempedValue(FunctionBuilder.of(MerchantPresentedMode::getValueOfConvenienceFeePercentage)).withFieldName("ValueOfConvenienceFeePercentage").must(ObjectPredicate.nullValue((Function)FunctionBuilder.of(MerchantPresentedMode::getValueOfConvenienceFeeFixed))).when(StringPredicate.stringEquals(FunctionBuilder.of(MerchantPresentedMode::getTipOrConvenienceIndicator).andThen(TagLengthString::getValue), (String)"03")).withMessage("When TipOrConvenienceIndicator is '03' ValueOfConvenienceFeeFixed must be null").withAttempedValue(FunctionBuilder.of(MerchantPresentedMode::getValueOfConvenienceFeeFixed)).withFieldName("ValueOfConvenienceFeeFixed").must(LogicalPredicate.not((Predicate)ObjectPredicate.nullValue((Function)FunctionBuilder.of(MerchantPresentedMode::getValueOfConvenienceFeeFixed)))).when(StringPredicate.stringEquals(FunctionBuilder.of(MerchantPresentedMode::getTipOrConvenienceIndicator).andThen(TagLengthString::getValue), (String)"02")).withMessage("When TipOrConvenienceIndicator is '02' ValueOfConvenienceFeeFixed is mandatory").withAttempedValue(FunctionBuilder.of(MerchantPresentedMode::getValueOfConvenienceFeeFixed)).withFieldName("ValueOfConvenienceFeeFixed").must(LogicalPredicate.not((Predicate)ObjectPredicate.nullValue((Function)FunctionBuilder.of(MerchantPresentedMode::getValueOfConvenienceFeePercentage)))).when(StringPredicate.stringEquals(FunctionBuilder.of(MerchantPresentedMode::getTipOrConvenienceIndicator).andThen(TagLengthString::getValue), (String)"03")).withMessage("When TipOrConvenienceIndicator is '03' ValueOfConvenienceFeePercentage is mandatory").withAttempedValue(FunctionBuilder.of(MerchantPresentedMode::getValueOfConvenienceFeePercentage)).withFieldName("ValueOfConvenienceFeePercentage");
        this.ruleFor("MerchantAccountInformation", MerchantPresentedMode::getMerchantAccountInformation).must(ComparablePredicate.greaterThan(Map::size, (Comparable)Integer.valueOf(0))).withMessage("MerchantAccountInformation size must have at least one").critical().must(ComparablePredicate.betweenInclusive(Map::size, (Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(49))).when(ComparablePredicate.greaterThan(Map::size, (Comparable)Integer.valueOf(0))).withMessage("MerchantAccountInformation list size must be between one and forty-nine").critical();
        ((WheneverCollection)this.ruleForEach(FunctionBuilder.of(MerchantPresentedMode::getMerchantAccountInformation).andThen(Map::values)).whenever(ComparablePredicate.greaterThan(Collection::size, (Comparable)Integer.valueOf(0)))).withValidator((Validator)new MerchantAccountInformationTemplateValidator("02", "51", 99));
        this.ruleFor("RFUforEMVCo", MerchantPresentedMode::getRFUforEMVCo).must(ComparablePredicate.betweenInclusive(Map::size, (Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(14))).when(ComparablePredicate.greaterThan(Map::size, (Comparable)Integer.valueOf(0))).withMessage("RFUforEMVCo list size must be between one and fourteen").critical();
        ((WheneverCollection)this.ruleForEach("RFUforEMVCo", FunctionBuilder.of(MerchantPresentedMode::getRFUforEMVCo).andThen(Map::values)).whenever(ComparablePredicate.greaterThan(Collection::size, (Comparable)Integer.valueOf(0)))).withValidator((Validator)new TagLengthStringValidator("MerchantPresentedMode.RFUforEMVCo", "65", "79", 99));
        this.ruleFor("Unreserveds", MerchantPresentedMode::getUnreserveds).must(ComparablePredicate.betweenInclusive(Map::size, (Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(19))).when(ComparablePredicate.greaterThan(Map::size, (Comparable)Integer.valueOf(0))).withMessage("Unreserveds list size must be between one and nineteen");
        ((WheneverCollection)this.ruleForEach(FunctionBuilder.of(MerchantPresentedMode::getUnreserveds).andThen(Map::values)).whenever(ComparablePredicate.greaterThan(Collection::size, (Comparable)Integer.valueOf(0)))).withValidator((Validator)new UnreservedTemplateValidator("80", "99", 99));
    }

    private static Function<TagLengthString, BigDecimal> convertToBigDecimal(Function<TagLengthString, String> fnc) {
        return obj -> new BigDecimal((String)fnc.apply((TagLengthString)obj));
    }
}

