/*
 * Decompiled with CFR 0.152.
 */
package com.emv.qrcode.validators.mpm;

import br.com.fluentvalidator.AbstractValidator;
import br.com.fluentvalidator.predicate.ComparablePredicate;
import br.com.fluentvalidator.predicate.LogicalPredicate;
import br.com.fluentvalidator.predicate.StringPredicate;
import com.emv.qrcode.core.model.TagLengthString;
import java.util.function.Predicate;

class TagLengthStringValidator
extends AbstractValidator<TagLengthString> {
    private final String tagStart;
    private final String tagEnd;
    private final Integer maxSizeValue;
    private final String fieldName;

    public TagLengthStringValidator(String fieldName, String tagStart, String tagEnd, Integer maxSizeValue) {
        this.fieldName = fieldName;
        this.tagStart = tagStart;
        this.tagEnd = tagEnd;
        this.maxSizeValue = maxSizeValue;
    }

    public void rules() {
        this.ruleFor(TagLengthString::getTag).must(LogicalPredicate.not((Predicate)StringPredicate.stringEmptyOrNull())).withFieldName("tag").withMessage(String.format("%s tag is mandatory", this.fieldName)).withAttempedValue(TagLengthString::getTag).critical().must(StringPredicate.stringSize((Integer)2)).withFieldName("tag").withMessage(String.format("%s tag must be size equal two", this.fieldName)).withAttempedValue(TagLengthString::getTag).critical().must(StringPredicate.isNumeric()).withFieldName("tag").withMessage(String.format("%s tag must be number", this.fieldName)).withAttempedValue(TagLengthString::getTag).critical().must(ComparablePredicate.betweenInclusive((Object)this.tagStart, (Object)this.tagEnd)).withFieldName("tag").withMessage(String.format("%s tag must be betwwen '%s' and '%s'", this.fieldName, this.tagStart, this.tagEnd)).withAttempedValue(TagLengthString::getTag).critical();
        this.ruleFor(TagLengthString::getValue).must(StringPredicate.stringSizeBetween((Integer)1, (Integer)this.maxSizeValue)).withFieldName("value").withMessage(String.format("%s value must less then or equal size %d", this.fieldName, this.maxSizeValue)).withAttempedValue(TagLengthString::getValue).critical();
    }
}

