/*
 * Decompiled with CFR 0.152.
 */
package com.emv.qrcode.validators.mpm;

import br.com.fluentvalidator.AbstractValidator;
import br.com.fluentvalidator.Validator;
import br.com.fluentvalidator.builder.WheneverProperty;
import br.com.fluentvalidator.function.FunctionBuilder;
import br.com.fluentvalidator.predicate.ComparablePredicate;
import br.com.fluentvalidator.predicate.LogicalPredicate;
import br.com.fluentvalidator.predicate.ObjectPredicate;
import br.com.fluentvalidator.predicate.StringPredicate;
import com.emv.qrcode.model.mpm.Unreserved;
import com.emv.qrcode.model.mpm.UnreservedTemplate;
import com.emv.qrcode.validators.mpm.UnreservedValidator;
import java.util.function.Predicate;

class UnreservedTemplateValidator
extends AbstractValidator<UnreservedTemplate> {
    private final String tagStart;
    private final String tagEnd;
    private final Integer maxSizeValue;

    public UnreservedTemplateValidator(String tagStart, String tagEnd, Integer maxSizeValue) {
        this.tagStart = tagStart;
        this.tagEnd = tagEnd;
        this.maxSizeValue = maxSizeValue;
    }

    public void rules() {
        this.ruleFor("UnreservedTemplate", UnreservedTemplate::getTag).must(ComparablePredicate.betweenInclusive((Object)this.tagStart, (Object)this.tagEnd));
        this.ruleFor("UnreservedTemplate", FunctionBuilder.of(UnreservedTemplate::getValue).andThen(Unreserved::toString)).must(StringPredicate.stringSizeBetween((Integer)1, (Integer)this.maxSizeValue));
        ((WheneverProperty)this.ruleFor(UnreservedTemplate::getValue).whenever(LogicalPredicate.not((Predicate)ObjectPredicate.nullValue()))).withValidator((Validator)new UnreservedValidator());
    }
}

