/*
 * Decompiled with CFR 0.152.
 */
package com.emv.qrcode.core.model.cpm;

import java.io.Serializable;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.binary.Hex;

public class BERTag
implements Serializable {
    private static final long serialVersionUID = -4165695218130492616L;
    private static final int LAST_BYTE_MASK = 128;
    private static final int NEXT_BYTE_BITMASK = 31;
    private static final int CLASS_BITMASK = 192;
    private static final int TYPE_BITMASK = 32;
    private final byte[] bytes;

    public BERTag(byte[] bytes) {
        this.bytes = bytes;
    }

    public TagClass getTagClass() {
        return TagClass.entryOf(this.bytes[0] & 0xC0);
    }

    public TagType getTagType() {
        return TagType.entryOf(this.bytes[0] & 0x20);
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.bytes);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BERTag)) {
            return false;
        }
        BERTag other = (BERTag)obj;
        return Arrays.equals(this.bytes, other.bytes);
    }

    public String toString() {
        return Hex.encodeHexString((byte[])this.bytes, (boolean)false);
    }

    public static boolean hasNextByte(byte value) {
        return 31 == (value & 0x1F);
    }

    public static boolean isNotLastByte(byte value) {
        return 128 == (value & 0x80);
    }

    public static enum TagType {
        PRIMITIVE(0),
        CONSTRUCTED(32);

        private static Map<Integer, TagType> mapInteger;
        private final int value;

        private TagType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static TagType entryOf(int value) {
            return mapInteger.get(value);
        }

        static {
            mapInteger = new HashMap<Integer, TagType>();
            for (TagType tagType : EnumSet.allOf(TagType.class)) {
                mapInteger.put(tagType.getValue(), tagType);
            }
        }
    }

    public static enum TagClass {
        UNIVERSAL(0),
        APPLICATION(64),
        CONTEXT_SPECIFIC(128),
        PRIVATE(192);

        private static Map<Integer, TagClass> mapInteger;
        private final int value;

        private TagClass(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static TagClass entryOf(int value) {
            return mapInteger.get(value);
        }

        static {
            mapInteger = new HashMap<Integer, TagClass>();
            for (TagClass tagClass : EnumSet.allOf(TagClass.class)) {
                mapInteger.put(tagClass.getValue(), tagClass);
            }
        }
    }
}

