/*
 * Decompiled with CFR 0.152.
 */
package com.emv.qrcode.decoder.cpm;

import com.emv.qrcode.core.exception.DuplicateTagException;
import com.emv.qrcode.core.exception.PresentedModeException;
import com.emv.qrcode.core.model.cpm.BERTLAlphanumeric;
import com.emv.qrcode.core.model.cpm.BERTLBinary;
import com.emv.qrcode.core.model.cpm.BERTLCompressedNumeric;
import com.emv.qrcode.core.model.cpm.BERTLNumeric;
import com.emv.qrcode.core.model.cpm.BERTag;
import com.emv.qrcode.core.utils.BERUtils;
import com.emv.qrcode.decoder.cpm.DecoderCpm;
import com.emv.qrcode.model.cpm.AdditionalData;
import com.emv.qrcode.model.cpm.ApplicationSpecificTransparentTemplate;
import com.emv.qrcode.model.cpm.constants.TagTransactionProcessingCodes;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.function.BiConsumer;
import org.apache.commons.codec.binary.Hex;

public final class ApplicationSpecificTransparentTemplateDecoder
extends DecoderCpm<ApplicationSpecificTransparentTemplate> {
    private static final Map.Entry<Class<?>, BiConsumer<ApplicationSpecificTransparentTemplate, ?>> defaultEntry = ApplicationSpecificTransparentTemplateDecoder.consumerTagLengthValue(BERTLBinary.class, AdditionalData::addAdditionalData);
    private static final Map<BERTag, Map.Entry<Class<?>, BiConsumer<ApplicationSpecificTransparentTemplate, ?>>> mapConsumers = new HashMap();

    public ApplicationSpecificTransparentTemplateDecoder(byte[] source) {
        super(BERUtils.valueOf(source));
    }

    @Override
    protected ApplicationSpecificTransparentTemplate decode() throws PresentedModeException {
        HashSet<BERTag> tags = new HashSet<BERTag>();
        ApplicationSpecificTransparentTemplate result = new ApplicationSpecificTransparentTemplate();
        while (this.iterator.hasNext()) {
            byte[] value = (byte[])this.iterator.next();
            BERTag tag = new BERTag(BERUtils.valueOfTag(value));
            if (tags.contains(tag)) {
                throw new DuplicateTagException("ApplicationSpecificTransparentTemplate", tag.toString(), Hex.encodeHexString((byte[])value, (boolean)false));
            }
            tags.add(tag);
            Map.Entry<Class<?>, BiConsumer<ApplicationSpecificTransparentTemplate, ?>> entry = mapConsumers.getOrDefault(tag, defaultEntry);
            Class<?> clazz = entry.getKey();
            BiConsumer<ApplicationSpecificTransparentTemplate, ?> consumer = entry.getValue();
            consumer.accept(result, DecoderCpm.decode(value, clazz));
        }
        return result;
    }

    static {
        mapConsumers.put(TagTransactionProcessingCodes.ID_APPLICATION_DEFINITION_FILE_NAME, ApplicationSpecificTransparentTemplateDecoder.consumerTagLengthValue(BERTLBinary.class, AdditionalData::addAdditionalData));
        mapConsumers.put(TagTransactionProcessingCodes.ID_APPLICATION_LABEL, ApplicationSpecificTransparentTemplateDecoder.consumerTagLengthValue(BERTLAlphanumeric.class, AdditionalData::addAdditionalData));
        mapConsumers.put(TagTransactionProcessingCodes.ID_TRACK_2_EQUIVALENT_DATA, ApplicationSpecificTransparentTemplateDecoder.consumerTagLengthValue(BERTLBinary.class, AdditionalData::addAdditionalData));
        mapConsumers.put(TagTransactionProcessingCodes.ID_APPLICATION_PAN, ApplicationSpecificTransparentTemplateDecoder.consumerTagLengthValue(BERTLCompressedNumeric.class, AdditionalData::addAdditionalData));
        mapConsumers.put(TagTransactionProcessingCodes.ID_CARDHOLDER_NAME, ApplicationSpecificTransparentTemplateDecoder.consumerTagLengthValue(BERTLAlphanumeric.class, AdditionalData::addAdditionalData));
        mapConsumers.put(TagTransactionProcessingCodes.ID_LANGUAGE_PREFERENCE, ApplicationSpecificTransparentTemplateDecoder.consumerTagLengthValue(BERTLAlphanumeric.class, AdditionalData::addAdditionalData));
        mapConsumers.put(TagTransactionProcessingCodes.ID_ISSUER_URL, ApplicationSpecificTransparentTemplateDecoder.consumerTagLengthValue(BERTLAlphanumeric.class, AdditionalData::addAdditionalData));
        mapConsumers.put(TagTransactionProcessingCodes.ID_APPLICATION_VERSION_NUMBER, ApplicationSpecificTransparentTemplateDecoder.consumerTagLengthValue(BERTLBinary.class, AdditionalData::addAdditionalData));
        mapConsumers.put(TagTransactionProcessingCodes.ID_TOKEN_REQUESTOR_ID, ApplicationSpecificTransparentTemplateDecoder.consumerTagLengthValue(BERTLNumeric.class, AdditionalData::addAdditionalData));
        mapConsumers.put(TagTransactionProcessingCodes.ID_PAYMENT_ACCOUNT_REFERENCE, ApplicationSpecificTransparentTemplateDecoder.consumerTagLengthValue(BERTLAlphanumeric.class, AdditionalData::addAdditionalData));
        mapConsumers.put(TagTransactionProcessingCodes.ID_LAST_4_DIGITS_OF_PAN, ApplicationSpecificTransparentTemplateDecoder.consumerTagLengthValue(BERTLNumeric.class, AdditionalData::addAdditionalData));
        mapConsumers.put(TagTransactionProcessingCodes.ID_CRYPTOGRAM_INFORMATION_DATA, ApplicationSpecificTransparentTemplateDecoder.consumerTagLengthValue(BERTLBinary.class, AdditionalData::addAdditionalData));
        mapConsumers.put(TagTransactionProcessingCodes.ID_APPLICATION_TRANSACTION_COUNTER, ApplicationSpecificTransparentTemplateDecoder.consumerTagLengthValue(BERTLNumeric.class, AdditionalData::addAdditionalData));
        mapConsumers.put(TagTransactionProcessingCodes.ID_APPLICATION_CRYPTOGRAM, ApplicationSpecificTransparentTemplateDecoder.consumerTagLengthValue(BERTLBinary.class, AdditionalData::addAdditionalData));
        mapConsumers.put(TagTransactionProcessingCodes.ID_ISSUER_APPLICATION_DATA, ApplicationSpecificTransparentTemplateDecoder.consumerTagLengthValue(BERTLBinary.class, AdditionalData::addAdditionalData));
        mapConsumers.put(TagTransactionProcessingCodes.ID_UNPREDICTABLE_NUMBER, ApplicationSpecificTransparentTemplateDecoder.consumerTagLengthValue(BERTLBinary.class, AdditionalData::addAdditionalData));
    }
}

