/*
 * Decompiled with CFR 0.152.
 */
package com.emv.qrcode.decoder.mpm;

import com.emv.qrcode.core.exception.PresentedModeException;
import com.emv.qrcode.core.utils.TLVUtils;
import com.emv.qrcode.decoder.mpm.DecoderMpm;
import com.emv.qrcode.model.mpm.MerchantAccountInformationReserved;
import com.emv.qrcode.model.mpm.MerchantAccountInformationReservedAdditional;
import com.emv.qrcode.model.mpm.MerchantAccountInformationTemplate;

public final class MerchantAccountInformationTemplateDecoder
extends DecoderMpm<MerchantAccountInformationTemplate> {
    public MerchantAccountInformationTemplateDecoder(String source) {
        super(source);
    }

    @Override
    protected MerchantAccountInformationTemplate decode() throws PresentedModeException {
        MerchantAccountInformationTemplate result = new MerchantAccountInformationTemplate();
        while (this.iterator.hasNext()) {
            String value = (String)this.iterator.next();
            String tag = TLVUtils.valueOfTag(value);
            result.setTag(tag);
            if (this.betweenAccountInformationReservedRange(tag)) {
                result.setValue(DecoderMpm.decode(value, MerchantAccountInformationReserved.class));
            }
            if (!this.betweenAccountInformationaReservedAdditionalRange(tag)) continue;
            result.setValue(DecoderMpm.decode(value, MerchantAccountInformationReservedAdditional.class));
        }
        return result;
    }

    private boolean betweenAccountInformationReservedRange(String value) {
        return value.compareTo("02") >= 0 && value.compareTo("25") <= 0;
    }

    private boolean betweenAccountInformationaReservedAdditionalRange(String value) {
        return value.compareTo("26") >= 0 && value.compareTo("51") <= 0;
    }
}

