/*
 * Decompiled with CFR 0.152.
 */
package com.emv.qrcode.validators.mpm;

import br.com.fluentvalidator.AbstractValidator;
import br.com.fluentvalidator.Validator;
import br.com.fluentvalidator.builder.WheneverCollection;
import br.com.fluentvalidator.function.FunctionBuilder;
import br.com.fluentvalidator.predicate.ComparablePredicate;
import br.com.fluentvalidator.predicate.LogicalPredicate;
import br.com.fluentvalidator.predicate.ObjectPredicate;
import br.com.fluentvalidator.predicate.StringPredicate;
import com.emv.qrcode.core.model.mpm.TagLengthString;
import com.emv.qrcode.model.mpm.MerchantInformationLanguage;
import com.emv.qrcode.validators.mpm.TagLengthStringValidator;
import java.util.Collection;
import java.util.Map;
import java.util.function.Predicate;

class MerchantInformationLanguageValidator
extends AbstractValidator<MerchantInformationLanguage> {
    MerchantInformationLanguageValidator() {
    }

    public void rules() {
        this.ruleFor(MerchantInformationLanguage::getLanguagePreference).must(LogicalPredicate.not((Predicate)StringPredicate.stringEmptyOrNull(TagLengthString::getTag))).withMessage("LanguagePreference tag is mandatory").withAttempedValue(FunctionBuilder.of(MerchantInformationLanguage::getLanguagePreference).andThen(TagLengthString::getTag)).critical().must(StringPredicate.stringSize(TagLengthString::getTag, (Integer)2)).withMessage("LanguagePreference tag must be size equal two").withAttempedValue(FunctionBuilder.of(MerchantInformationLanguage::getLanguagePreference).andThen(TagLengthString::getTag)).critical().must(StringPredicate.isNumeric(TagLengthString::getTag)).withMessage("LanguagePreference tag must be number").withAttempedValue(FunctionBuilder.of(MerchantInformationLanguage::getLanguagePreference).andThen(TagLengthString::getTag)).critical().must(StringPredicate.stringEquals(TagLengthString::getTag, (String)"00")).withMessage(String.format("LanguagePreference tag must be '%s'", "00")).withAttempedValue(FunctionBuilder.of(MerchantInformationLanguage::getLanguagePreference).andThen(TagLengthString::getTag)).critical().must(LogicalPredicate.not((Predicate)StringPredicate.stringEmptyOrNull(TagLengthString::getValue))).withMessage("LanguagePreference value is mandatory").withAttempedValue(FunctionBuilder.of(MerchantInformationLanguage::getLanguagePreference).andThen(TagLengthString::getValue)).critical().must(StringPredicate.stringSize(TagLengthString::getValue, (Integer)2)).withMessage("LanguagePreference value must be equal size two").withAttempedValue(FunctionBuilder.of(MerchantInformationLanguage::getLanguagePreference).andThen(TagLengthString::getValue)).critical();
        this.ruleFor(MerchantInformationLanguage::getMerchantName).must(LogicalPredicate.not((Predicate)StringPredicate.stringEmptyOrNull(TagLengthString::getTag))).withMessage("MerchantName tag is mandatory").withAttempedValue(FunctionBuilder.of(MerchantInformationLanguage::getMerchantName).andThen(TagLengthString::getTag)).critical().must(StringPredicate.stringSize(TagLengthString::getTag, (Integer)2)).withMessage("MerchantName tag must be size equal two").withAttempedValue(FunctionBuilder.of(MerchantInformationLanguage::getMerchantName).andThen(TagLengthString::getTag)).critical().must(StringPredicate.isNumeric(TagLengthString::getTag)).withMessage("MerchantName tag must be number").withAttempedValue(FunctionBuilder.of(MerchantInformationLanguage::getMerchantName).andThen(TagLengthString::getTag)).critical().must(StringPredicate.stringEquals(TagLengthString::getTag, (String)"01")).withMessage(String.format("MerchantName tag must be '%s'", "01")).withAttempedValue(FunctionBuilder.of(MerchantInformationLanguage::getMerchantName).andThen(TagLengthString::getTag)).critical().must(LogicalPredicate.not((Predicate)StringPredicate.stringEmptyOrNull(TagLengthString::getValue))).withMessage("MerchantName value is mandatory").withAttempedValue(FunctionBuilder.of(MerchantInformationLanguage::getMerchantName).andThen(TagLengthString::getValue)).critical().must(StringPredicate.stringSizeLessThanOrEqual(TagLengthString::getValue, (Integer)25)).withMessage("MerchantName value must be equal size twenty-five").withAttempedValue(FunctionBuilder.of(MerchantInformationLanguage::getMerchantName).andThen(TagLengthString::getValue)).critical();
        this.ruleFor(MerchantInformationLanguage::getMerchantCity).must(LogicalPredicate.not((Predicate)StringPredicate.stringEmptyOrNull(TagLengthString::getTag))).when(LogicalPredicate.not((Predicate)ObjectPredicate.nullValue())).withMessage("MerchantCity tag is mandatory").withAttempedValue(FunctionBuilder.of(MerchantInformationLanguage::getMerchantCity).andThen(TagLengthString::getTag)).critical().must(StringPredicate.stringSize(TagLengthString::getTag, (Integer)2)).when(LogicalPredicate.not((Predicate)ObjectPredicate.nullValue())).withMessage("MerchantCity tag must be size equal two").withAttempedValue(FunctionBuilder.of(MerchantInformationLanguage::getMerchantCity).andThen(TagLengthString::getTag)).critical().must(StringPredicate.isNumeric(TagLengthString::getTag)).when(LogicalPredicate.not((Predicate)ObjectPredicate.nullValue())).withMessage("MerchantCity tag must be number").withAttempedValue(FunctionBuilder.of(MerchantInformationLanguage::getMerchantCity).andThen(TagLengthString::getTag)).critical().must(StringPredicate.stringEquals(TagLengthString::getTag, (String)"02")).when(LogicalPredicate.not((Predicate)ObjectPredicate.nullValue())).withMessage(String.format("MerchantCity tag must be '%s'", "02")).withAttempedValue(FunctionBuilder.of(MerchantInformationLanguage::getMerchantCity).andThen(TagLengthString::getTag)).critical().must(LogicalPredicate.not((Predicate)StringPredicate.stringEmptyOrNull(TagLengthString::getValue))).when(LogicalPredicate.not((Predicate)ObjectPredicate.nullValue())).withMessage("MerchantCity value is mandatory").withAttempedValue(FunctionBuilder.of(MerchantInformationLanguage::getMerchantCity).andThen(TagLengthString::getValue)).critical().must(StringPredicate.stringSizeLessThanOrEqual(TagLengthString::getValue, (Integer)15)).when(LogicalPredicate.not((Predicate)ObjectPredicate.nullValue())).withMessage("MerchantCity value must be equal size fifteen").withAttempedValue(FunctionBuilder.of(MerchantInformationLanguage::getMerchantCity).andThen(TagLengthString::getValue)).critical();
        ((WheneverCollection)this.ruleForEach(FunctionBuilder.of(MerchantInformationLanguage::getRFUforEMVCo).andThen(Map::values)).whenever(ComparablePredicate.greaterThan(Collection::size, (Comparable)Integer.valueOf(0)))).withValidator((Validator)new TagLengthStringValidator("MerchantInformationLanguage.RFUforEMVCo", "03", "99", 99));
    }
}

