/*
 * Decompiled with CFR 0.152.
 */
package com.emv.qrcode.validators.mpm;

import br.com.fluentvalidator.AbstractValidator;
import br.com.fluentvalidator.Validator;
import br.com.fluentvalidator.builder.WheneverProperty;
import br.com.fluentvalidator.function.FunctionBuilder;
import br.com.fluentvalidator.predicate.ComparablePredicate;
import br.com.fluentvalidator.predicate.LogicalPredicate;
import br.com.fluentvalidator.predicate.ObjectPredicate;
import br.com.fluentvalidator.predicate.StringPredicate;
import com.emv.qrcode.model.mpm.PaymentSystemSpecific;
import com.emv.qrcode.model.mpm.PaymentSystemSpecificTemplate;
import com.emv.qrcode.validators.mpm.PaymentSystemSpecificValidator;
import java.util.function.Predicate;

class PaymentSystemSpecificTemplateValidator
extends AbstractValidator<PaymentSystemSpecificTemplate> {
    private final String tagStart;
    private final String tagEnd;
    private final Integer maxSizeValue;

    public PaymentSystemSpecificTemplateValidator(String tagStart, String tagEnd, Integer maxSizeValue) {
        this.tagStart = tagStart;
        this.tagEnd = tagEnd;
        this.maxSizeValue = maxSizeValue;
    }

    public void rules() {
        this.ruleFor("PaymentSystemSpecificTemplate", PaymentSystemSpecificTemplate::getTag).must(ComparablePredicate.betweenInclusive((Object)this.tagStart, (Object)this.tagEnd)).critical();
        this.ruleFor("PaymentSystemSpecificTemplate", FunctionBuilder.of(PaymentSystemSpecificTemplate::getValue).andThen(PaymentSystemSpecific::toString)).must(StringPredicate.stringSizeBetween((Integer)1, (Integer)this.maxSizeValue)).critical();
        ((WheneverProperty)this.ruleFor(PaymentSystemSpecificTemplate::getValue).whenever(LogicalPredicate.not((Predicate)ObjectPredicate.nullValue()))).withValidator((Validator)new PaymentSystemSpecificValidator());
    }
}

