/*
 * Decompiled with CFR 0.152.
 */
package com.emv.qrcode.validators.mpm;

import br.com.fluentvalidator.AbstractValidator;
import br.com.fluentvalidator.Validator;
import br.com.fluentvalidator.builder.WheneverCollection;
import br.com.fluentvalidator.function.FunctionBuilder;
import br.com.fluentvalidator.predicate.ComparablePredicate;
import br.com.fluentvalidator.predicate.LogicalPredicate;
import br.com.fluentvalidator.predicate.StringPredicate;
import com.emv.qrcode.core.model.mpm.TagLengthString;
import com.emv.qrcode.model.mpm.Unreserved;
import com.emv.qrcode.validators.mpm.TagLengthStringValidator;
import java.util.Collection;
import java.util.Map;
import java.util.function.Predicate;

class UnreservedValidator
extends AbstractValidator<Unreserved> {
    UnreservedValidator() {
    }

    public void rules() {
        this.ruleFor("GloballyUniqueIdentifier", Unreserved::getGloballyUniqueIdentifier).must(LogicalPredicate.not((Predicate)StringPredicate.stringEmptyOrNull(TagLengthString::getTag))).withMessage("GloballyUniqueIdentifier tag is mandatory").withAttempedValue(FunctionBuilder.of(Unreserved::getGloballyUniqueIdentifier).andThen(TagLengthString::getTag)).critical().must(StringPredicate.stringSize(TagLengthString::getTag, (Integer)2)).withMessage("GloballyUniqueIdentifier tag must be size equal two").withAttempedValue(FunctionBuilder.of(Unreserved::getGloballyUniqueIdentifier).andThen(TagLengthString::getTag)).critical().must(StringPredicate.isNumeric(TagLengthString::getTag)).withMessage("GloballyUniqueIdentifier tag must be number").withAttempedValue(FunctionBuilder.of(Unreserved::getGloballyUniqueIdentifier).andThen(TagLengthString::getTag)).critical().must(StringPredicate.stringEquals(TagLengthString::getTag, (String)"00")).withMessage(String.format("GloballyUniqueIdentifier tag must be '%s'", "00")).withAttempedValue(FunctionBuilder.of(Unreserved::getGloballyUniqueIdentifier).andThen(TagLengthString::getTag)).critical().must(LogicalPredicate.not((Predicate)StringPredicate.stringEmptyOrNull(TagLengthString::getValue))).withMessage("GloballyUniqueIdentifier value is mandatory").withAttempedValue(FunctionBuilder.of(Unreserved::getGloballyUniqueIdentifier).andThen(TagLengthString::getValue)).critical().must(StringPredicate.stringSizeLessThanOrEqual(TagLengthString::getValue, (Integer)32)).withMessage("GloballyUniqueIdentifier value must less then or equal size thirty-two").withAttempedValue(FunctionBuilder.of(Unreserved::getGloballyUniqueIdentifier).andThen(TagLengthString::getValue)).critical();
        ((WheneverCollection)this.ruleForEach(FunctionBuilder.of(Unreserved::getContextSpecificData).andThen(Map::values)).whenever(ComparablePredicate.greaterThan(Collection::size, (Comparable)Integer.valueOf(0)))).withValidator((Validator)new TagLengthStringValidator("Unreserved.ContextSpecificData", "01", "99", 99));
    }
}

