/*
 * Decompiled with CFR 0.152.
 */
package br.com.fluentvalidator.context;

import br.com.fluentvalidator.context.Error;
import br.com.fluentvalidator.exception.ValidationException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;

public final class ValidationResult {
    private final boolean valid;
    private final Collection<Error> errors;

    public static ValidationResult ok() {
        return new ValidationResult(true, new ArrayList<Error>());
    }

    public static ValidationResult fail(Collection<Error> messages) {
        return new ValidationResult(false, Optional.ofNullable(messages).orElse(new ArrayList()));
    }

    private ValidationResult(boolean valid, Collection<Error> messages) {
        this.valid = valid;
        this.errors = Collections.unmodifiableCollection(messages);
    }

    public <T extends ValidationException> void isInvalidThrow(Class<T> clazz) {
        if (!this.isValid()) {
            throw ValidationException.create(clazz, this);
        }
    }

    public boolean isValid() {
        return this.valid;
    }

    public Collection<Error> getErrors() {
        return this.errors;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ValidationResult [valid=");
        builder.append(this.valid);
        builder.append(", ");
        builder.append("errors=");
        builder.append(this.errors);
        builder.append("]");
        return builder.toString();
    }
}

