/*
 * Decompiled with CFR 0.152.
 */
package br.com.fluentvalidator.predicate;

import br.com.fluentvalidator.predicate.LogicalPredicate;
import br.com.fluentvalidator.predicate.ObjectPredicate;
import br.com.fluentvalidator.predicate.PredicateBuilder;
import br.com.fluentvalidator.predicate.StringPredicate;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.function.Function;
import java.util.function.Predicate;

public final class TimePredicate {
    public static <T> Predicate<T> timeBetween(Function<T, String> source, String timeStringMin, String timeStringMax, String pattern) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(obj -> TimePredicate.timeBetween(timeStringMin, timeStringMax, pattern).test((String)source.apply(obj)));
    }

    public static Predicate<String> timeBetween(String timeStringMin, String timeStringMax, String pattern) {
        return PredicateBuilder.from(TimePredicate.timeLessThanOrEqual(timeStringMax, pattern).and(TimePredicate.timeGreaterThanOrEqual(timeStringMin, pattern)));
    }

    public static <T> Predicate<T> timeEqualTo(Function<T, String> source, Function<T, String> target, String pattern) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(obj -> TimePredicate.timeEqualTo((String)target.apply(obj), pattern).test((String)source.apply(obj)));
    }

    public static <T> Predicate<T> timeEqualTo(Function<T, String> source, String target, String pattern) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(obj -> TimePredicate.timeEqualTo(target, pattern).test((String)source.apply(obj)));
    }

    public static Predicate<String> timeEqualTo(String timeString, String pattern) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(timeEqualTo -> LogicalPredicate.not(StringPredicate.stringEmptyOrNull()).test(timeString)).and(timeEqualTo -> LogicalPredicate.not(StringPredicate.stringEmptyOrNull()).test(pattern)).and(timeEqualTo -> {
            try {
                DateTimeFormatter timeFormat = DateTimeFormatter.ofPattern(pattern);
                LocalTime timeTest = LocalTime.parse(timeEqualTo, timeFormat);
                LocalTime time = LocalTime.parse(timeString, timeFormat);
                return timeTest.equals(time);
            }
            catch (IllegalArgumentException | DateTimeParseException runtimeException) {
                return false;
            }
        });
    }

    public static <T> Predicate<T> timeGreaterThan(Function<T, String> source, Function<T, String> target, String pattern) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(obj -> TimePredicate.timeGreaterThan((String)target.apply(obj), pattern).test((String)source.apply(obj)));
    }

    public static <T> Predicate<T> timeGreaterThan(Function<T, String> source, String target, String pattern) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(obj -> TimePredicate.timeGreaterThan(target, pattern).test((String)source.apply(obj)));
    }

    public static Predicate<String> timeGreaterThan(String timeString, String pattern) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(timeGreaterThan -> LogicalPredicate.not(StringPredicate.stringEmptyOrNull()).test(timeString)).and(timeGreaterThan -> LogicalPredicate.not(StringPredicate.stringEmptyOrNull()).test(pattern)).and(timeGreaterThan -> {
            try {
                DateTimeFormatter timeFormat = DateTimeFormatter.ofPattern(pattern);
                LocalTime timeTest = LocalTime.parse(timeGreaterThan, timeFormat);
                LocalTime time = LocalTime.parse(timeString, timeFormat);
                return timeTest.isAfter(time);
            }
            catch (IllegalArgumentException | DateTimeParseException runtimeException) {
                return false;
            }
        });
    }

    public static <T> Predicate<T> timeGreaterThanOrEqual(Function<T, String> source, Function<T, String> target, String pattern) {
        return PredicateBuilder.from(TimePredicate.timeGreaterThan(source, target, pattern).or(TimePredicate.timeEqualTo(source, target, pattern)));
    }

    public static <T> Predicate<T> timeGreaterThanOrEqual(Function<T, String> source, String target, String pattern) {
        return PredicateBuilder.from(TimePredicate.timeGreaterThan(source, target, pattern).or(TimePredicate.timeEqualTo(source, target, pattern)));
    }

    public static Predicate<String> timeGreaterThanOrEqual(String timeString, String pattern) {
        return PredicateBuilder.from(TimePredicate.timeGreaterThan(timeString, pattern).or(TimePredicate.timeEqualTo(timeString, pattern)));
    }

    public static <T> Predicate<T> timeLessThan(Function<T, String> source, Function<T, String> target, String pattern) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(obj -> TimePredicate.timeLessThan((String)target.apply(obj), pattern).test((String)source.apply(obj)));
    }

    public static <T> Predicate<T> timeLessThan(Function<T, String> source, String target, String pattern) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(obj -> TimePredicate.timeLessThan(target, pattern).test((String)source.apply(obj)));
    }

    public static Predicate<String> timeLessThan(String timeString, String pattern) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(timeLessThan -> LogicalPredicate.not(StringPredicate.stringEmptyOrNull()).test(timeString)).and(timeLessThan -> LogicalPredicate.not(StringPredicate.stringEmptyOrNull()).test(pattern)).and(timeLessThan -> {
            try {
                DateTimeFormatter timeFormat = DateTimeFormatter.ofPattern(pattern);
                LocalTime timeTest = LocalTime.parse(timeLessThan, timeFormat);
                LocalTime time = LocalTime.parse(timeString, timeFormat);
                return timeTest.isBefore(time);
            }
            catch (IllegalArgumentException | DateTimeParseException runtimeException) {
                return false;
            }
        });
    }

    public static <T> Predicate<T> timeLessThanOrEqual(Function<T, String> source, Function<T, String> target, String pattern) {
        return PredicateBuilder.from(TimePredicate.timeLessThan(source, target, pattern).or(TimePredicate.timeEqualTo(source, target, pattern)));
    }

    public static <T> Predicate<T> timeLessThanOrEqual(Function<T, String> source, String target, String pattern) {
        return PredicateBuilder.from(TimePredicate.timeLessThan(source, target, pattern).or(TimePredicate.timeEqualTo(source, target, pattern)));
    }

    public static Predicate<String> timeLessThanOrEqual(String timeString, String pattern) {
        return PredicateBuilder.from(TimePredicate.timeLessThan(timeString, pattern).or(TimePredicate.timeEqualTo(timeString, pattern)));
    }

    private TimePredicate() {
    }
}

