/*
 * Decompiled with CFR 0.152.
 */
package br.com.fluentvalidator.predicate;

import br.com.fluentvalidator.predicate.LogicalPredicate;
import br.com.fluentvalidator.predicate.ObjectPredicate;
import br.com.fluentvalidator.predicate.PredicateBuilder;
import br.com.fluentvalidator.predicate.StringPredicate;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.function.Function;
import java.util.function.Predicate;

public final class DatePredicate {
    public static <T> Predicate<T> dateBetween(Function<T, String> source, String dateStringMin, String dateStringMax, String pattern) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(obj -> DatePredicate.dateBetween(dateStringMin, dateStringMax, pattern).test((String)source.apply(obj)));
    }

    public static Predicate<String> dateBetween(String dateStringMin, String dateStringMax, String pattern) {
        return PredicateBuilder.from(DatePredicate.dateLessThanOrEqual(dateStringMax, pattern).and(DatePredicate.dateGreaterThanOrEqual(dateStringMin, pattern)));
    }

    public static <T> Predicate<T> dateEqualTo(Function<T, String> source, Function<T, String> target, String pattern) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(obj -> DatePredicate.dateEqualTo((String)target.apply(obj), pattern).test((String)source.apply(obj)));
    }

    public static <T> Predicate<T> dateEqualTo(Function<T, String> source, String target, String pattern) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(obj -> DatePredicate.dateEqualTo(target, pattern).test((String)source.apply(obj)));
    }

    public static Predicate<String> dateEqualTo(String dateString, String pattern) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(dateEqualTo -> LogicalPredicate.not(StringPredicate.stringEmptyOrNull()).test(dateString)).and(dateEqualTo -> LogicalPredicate.not(StringPredicate.stringEmptyOrNull()).test(pattern)).and(dateEqualTo -> {
            try {
                DateTimeFormatter dateFormat = DateTimeFormatter.ofPattern(pattern);
                LocalDate dateTest = LocalDate.parse(dateEqualTo, dateFormat);
                LocalDate date = LocalDate.parse(dateString, dateFormat);
                return dateTest.isEqual(date);
            }
            catch (IllegalArgumentException | DateTimeParseException ex) {
                return false;
            }
        });
    }

    public static <T> Predicate<T> dateGreaterThan(Function<T, String> source, Function<T, String> target, String pattern) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(obj -> DatePredicate.dateGreaterThan((String)target.apply(obj), pattern).test((String)source.apply(obj)));
    }

    public static <T> Predicate<T> dateGreaterThan(Function<T, String> source, String target, String pattern) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(obj -> DatePredicate.dateGreaterThan(target, pattern).test((String)source.apply(obj)));
    }

    public static Predicate<String> dateGreaterThan(String dateString, String pattern) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(dateGreaterThan -> LogicalPredicate.not(StringPredicate.stringEmptyOrNull()).test(dateString)).and(dateGreaterThan -> LogicalPredicate.not(StringPredicate.stringEmptyOrNull()).test(pattern)).and(dateGreaterThan -> {
            try {
                DateTimeFormatter dateFormat = DateTimeFormatter.ofPattern(pattern);
                LocalDate dateTest = LocalDate.parse(dateGreaterThan, dateFormat);
                LocalDate date = LocalDate.parse(dateString, dateFormat);
                return dateTest.isAfter(date);
            }
            catch (IllegalArgumentException | DateTimeParseException ex) {
                return false;
            }
        });
    }

    public static <T> Predicate<T> dateGreaterThanOrEqual(Function<T, String> source, Function<T, String> target, String pattern) {
        return PredicateBuilder.from(DatePredicate.dateGreaterThan(source, target, pattern).or(DatePredicate.dateEqualTo(source, target, pattern)));
    }

    public static <T> Predicate<T> dateGreaterThanOrEqual(Function<T, String> source, String target, String pattern) {
        return PredicateBuilder.from(DatePredicate.dateGreaterThan(source, target, pattern).or(DatePredicate.dateEqualTo(source, target, pattern)));
    }

    public static Predicate<String> dateGreaterThanOrEqual(String dateString, String pattern) {
        return PredicateBuilder.from(DatePredicate.dateGreaterThan(dateString, pattern).or(DatePredicate.dateEqualTo(dateString, pattern)));
    }

    public static <T> Predicate<T> dateLessThan(Function<T, String> source, Function<T, String> target, String pattern) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(obj -> DatePredicate.dateLessThan((String)target.apply(obj), pattern).test((String)source.apply(obj)));
    }

    public static <T> Predicate<T> dateLessThan(Function<T, String> source, String target, String pattern) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(obj -> DatePredicate.dateLessThan(target, pattern).test((String)source.apply(obj)));
    }

    public static Predicate<String> dateLessThan(String dateString, String pattern) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(dateLessThan -> LogicalPredicate.not(StringPredicate.stringEmptyOrNull()).test(dateString)).and(dateLessThan -> LogicalPredicate.not(StringPredicate.stringEmptyOrNull()).test(pattern)).and(dateLessThan -> {
            try {
                DateTimeFormatter dateFormat = DateTimeFormatter.ofPattern(pattern);
                LocalDate dateTest = LocalDate.parse(dateLessThan, dateFormat);
                LocalDate date = LocalDate.parse(dateString, dateFormat);
                return dateTest.isBefore(date);
            }
            catch (IllegalArgumentException | DateTimeParseException ex) {
                return false;
            }
        });
    }

    public static <T> Predicate<T> dateLessThanOrEqual(Function<T, String> source, Function<T, String> target, String pattern) {
        return PredicateBuilder.from(DatePredicate.dateLessThan(source, target, pattern).or(DatePredicate.dateEqualTo(source, target, pattern)));
    }

    public static <T> Predicate<T> dateLessThanOrEqual(Function<T, String> source, String target, String pattern) {
        return PredicateBuilder.from(DatePredicate.dateLessThan(source, target, pattern).or(DatePredicate.dateEqualTo(source, target, pattern)));
    }

    public static Predicate<String> dateLessThanOrEqual(String dateString, String pattern) {
        return PredicateBuilder.from(DatePredicate.dateLessThan(dateString, pattern).or(DatePredicate.dateEqualTo(dateString, pattern)));
    }

    private DatePredicate() {
    }
}

