/*
 * Decompiled with CFR 0.152.
 */
package br.com.fluentvalidator.predicate;

import br.com.fluentvalidator.predicate.LogicalPredicate;
import br.com.fluentvalidator.predicate.ObjectPredicate;
import br.com.fluentvalidator.predicate.PredicateBuilder;
import java.time.LocalDate;
import java.time.chrono.ChronoLocalDate;
import java.util.function.Function;
import java.util.function.Predicate;

public final class LocalDatePredicate {
    public static <T> Predicate<T> localDateAfter(Function<T, LocalDate> source, Function<T, LocalDate> target) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(LogicalPredicate.not(ObjectPredicate.nullValue(target))).and(obj -> LocalDatePredicate.localDateAfter(source, (LocalDate)target.apply(obj)).test(obj));
    }

    public static <T> Predicate<T> localDateAfter(Function<T, LocalDate> source, LocalDate target) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(LogicalPredicate.not(ObjectPredicate.nullValue(source))).and(obj -> LocalDatePredicate.localDateAfter(target).test(source.apply(obj)));
    }

    public static <T extends LocalDate> Predicate<T> localDateAfter(LocalDate target) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(obj -> LogicalPredicate.not(ObjectPredicate.nullValue()).test(target)).and(obj -> obj.isAfter(target));
    }

    public static <T> Predicate<T> localDateAfterOrEqual(Function<T, LocalDate> source, Function<T, LocalDate> target) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(LogicalPredicate.not(ObjectPredicate.nullValue(target))).and(obj -> LocalDatePredicate.localDateAfterOrEqual(source, (LocalDate)target.apply(obj)).test(obj));
    }

    public static <T> Predicate<T> localDateAfterOrEqual(Function<T, LocalDate> source, LocalDate target) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(LogicalPredicate.not(ObjectPredicate.nullValue(source))).and(obj -> LocalDatePredicate.localDateAfterOrEqual(target).test(source.apply(obj)));
    }

    public static <T extends LocalDate> Predicate<T> localDateAfterOrEqual(LocalDate target) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(obj -> LogicalPredicate.not(ObjectPredicate.nullValue()).test(target)).and(LogicalPredicate.is(LocalDatePredicate.localDateAfter(target)).or(LocalDatePredicate.localDateEqualTo(target)));
    }

    public static <T extends LocalDate> Predicate<T> localDateAfterOrEqualToday() {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(localDate -> localDate.isAfter(LocalDate.now()) || localDate.isEqual(LocalDate.now()));
    }

    public static <T> Predicate<T> localDateAfterOrEqualToday(Function<T, LocalDate> source) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(obj -> LocalDatePredicate.localDateAfterOrEqualToday().test(source.apply(obj)));
    }

    public static <T extends LocalDate> Predicate<T> localDateAfterToday() {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(localDate -> localDate.isAfter(LocalDate.now()));
    }

    public static <T> Predicate<T> localDateAfterToday(Function<T, LocalDate> source) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(obj -> LocalDatePredicate.localDateAfterToday().test(source.apply(obj)));
    }

    public static <T> Predicate<T> localDateBefore(Function<T, LocalDate> source, Function<T, LocalDate> target) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(LogicalPredicate.not(ObjectPredicate.nullValue(target))).and(obj -> LocalDatePredicate.localDateBefore(source, (LocalDate)target.apply(obj)).test(obj));
    }

    public static <T> Predicate<T> localDateBefore(Function<T, LocalDate> source, LocalDate target) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(LogicalPredicate.not(ObjectPredicate.nullValue(source))).and(obj -> LocalDatePredicate.localDateBefore(target).test(source.apply(obj)));
    }

    public static <T extends LocalDate> Predicate<T> localDateBefore(LocalDate target) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(obj -> LogicalPredicate.not(ObjectPredicate.nullValue()).test(target)).and(obj -> obj.isBefore(target));
    }

    public static <T> Predicate<T> localDateBeforeOrEqual(Function<T, LocalDate> source, Function<T, LocalDate> target) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(LogicalPredicate.not(ObjectPredicate.nullValue(target))).and(obj -> LocalDatePredicate.localDateBeforeOrEqual(source, (LocalDate)target.apply(obj)).test(obj));
    }

    public static <T> Predicate<T> localDateBeforeOrEqual(Function<T, LocalDate> source, LocalDate target) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(LogicalPredicate.not(ObjectPredicate.nullValue(source))).and(obj -> LocalDatePredicate.localDateBeforeOrEqual(target).test(source.apply(obj)));
    }

    public static <T extends LocalDate> Predicate<T> localDateBeforeOrEqual(LocalDate target) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(obj -> LogicalPredicate.not(ObjectPredicate.nullValue()).test(target)).and(LogicalPredicate.is(LocalDatePredicate.localDateBefore(target)).or(LocalDatePredicate.localDateEqualTo(target)));
    }

    public static <T extends LocalDate> Predicate<T> localDateBeforeOrEqualToday() {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(localDate -> localDate.isBefore(LocalDate.now()) || localDate.isEqual(LocalDate.now()));
    }

    public static <T> Predicate<T> localDateBeforeOrEqualToday(Function<T, LocalDate> source) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(obj -> LocalDatePredicate.localDateBeforeOrEqualToday().test(source.apply(obj)));
    }

    public static <T extends LocalDate> Predicate<T> localDateBeforeToday() {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(localDate -> localDate.isBefore(LocalDate.now()));
    }

    public static <T> Predicate<T> localDateBeforeToday(Function<T, LocalDate> source) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(obj -> LocalDatePredicate.localDateBeforeToday().test(source.apply(obj)));
    }

    public static <T> Predicate<T> localDateBetween(Function<T, LocalDate> source, Function<T, LocalDate> min, Function<T, LocalDate> max) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(LogicalPredicate.not(ObjectPredicate.nullValue(min))).and(LogicalPredicate.not(ObjectPredicate.nullValue(max))).and(obj -> LocalDatePredicate.localDateBetween(source, (LocalDate)min.apply(obj), (LocalDate)max.apply(obj)).test(obj));
    }

    public static <T> Predicate<T> localDateBetween(Function<T, LocalDate> source, Function<T, LocalDate> min, LocalDate max) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(LogicalPredicate.not(ObjectPredicate.nullValue(min))).and(obj -> LocalDatePredicate.localDateBetween(source, (LocalDate)min.apply(obj), max).test(obj));
    }

    public static <T> Predicate<T> localDateBetween(Function<T, LocalDate> source, LocalDate min, Function<T, LocalDate> max) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(LogicalPredicate.not(ObjectPredicate.nullValue(max))).and(obj -> LocalDatePredicate.localDateBetween(source, min, (LocalDate)max.apply(obj)).test(obj));
    }

    public static <T> Predicate<T> localDateBetween(Function<T, LocalDate> source, LocalDate min, LocalDate max) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(LogicalPredicate.not(ObjectPredicate.nullValue(source))).and(obj -> LocalDatePredicate.localDateBetween(min, max).test(source.apply(obj)));
    }

    public static <T extends LocalDate> Predicate<T> localDateBetween(LocalDate min, LocalDate max) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(LocalDatePredicate.localDateAfter(min).and(LocalDatePredicate.localDateBefore(max)));
    }

    public static <T> Predicate<T> localDateBetweenOrEqual(Function<T, LocalDate> source, Function<T, LocalDate> min, Function<T, LocalDate> max) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(LogicalPredicate.not(ObjectPredicate.nullValue(min))).and(LogicalPredicate.not(ObjectPredicate.nullValue(max))).and(obj -> LocalDatePredicate.localDateBetweenOrEqual(source, (LocalDate)min.apply(obj), (LocalDate)max.apply(obj)).test(obj));
    }

    public static <T> Predicate<T> localDateBetweenOrEqual(Function<T, LocalDate> source, Function<T, LocalDate> min, LocalDate max) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(LogicalPredicate.not(ObjectPredicate.nullValue(min))).and(obj -> LocalDatePredicate.localDateBetweenOrEqual(source, (LocalDate)min.apply(obj), max).test(obj));
    }

    public static <T> Predicate<T> localDateBetweenOrEqual(Function<T, LocalDate> source, LocalDate min, Function<T, LocalDate> max) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(LogicalPredicate.not(ObjectPredicate.nullValue(max))).and(obj -> LocalDatePredicate.localDateBetweenOrEqual(source, min, (LocalDate)max.apply(obj)).test(obj));
    }

    public static <T> Predicate<T> localDateBetweenOrEqual(Function<T, LocalDate> source, LocalDate min, LocalDate max) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(LogicalPredicate.not(ObjectPredicate.nullValue(source))).and(obj -> LocalDatePredicate.localDateBetweenOrEqual(min, max).test(source.apply(obj)));
    }

    public static <T extends LocalDate> Predicate<T> localDateBetweenOrEqual(LocalDate min, LocalDate max) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(LocalDatePredicate.localDateAfterOrEqual(min).and(LocalDatePredicate.localDateBeforeOrEqual(max)));
    }

    public static <T> Predicate<T> localDateEqualTo(Function<T, LocalDate> source, LocalDate localDate) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(LogicalPredicate.not(ObjectPredicate.nullValue(source))).and(obj -> LocalDatePredicate.localDateEqualTo(localDate).test(source.apply(obj)));
    }

    public static <T extends LocalDate> Predicate<T> localDateEqualTo(LocalDate localDate) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(obj -> LogicalPredicate.not(ObjectPredicate.nullValue()).test(localDate)).and(obj -> localDate.isEqual((ChronoLocalDate)obj));
    }

    public static <T extends LocalDate> Predicate<T> localDateIsToday() {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(obj -> obj.isEqual(LocalDate.now()));
    }

    public static <T> Predicate<T> localDateIsToday(Function<T, LocalDate> source) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(LogicalPredicate.not(ObjectPredicate.nullValue(source))).and(obj -> LocalDatePredicate.localDateIsToday().test(source.apply(obj)));
    }

    private LocalDatePredicate() {
    }
}

