/*
 * Decompiled with CFR 0.152.
 */
package br.com.fluentvalidator.predicate;

import br.com.fluentvalidator.predicate.LogicalPredicate;
import br.com.fluentvalidator.predicate.ObjectPredicate;
import br.com.fluentvalidator.predicate.PredicateBuilder;
import java.time.LocalTime;
import java.util.function.Function;
import java.util.function.Predicate;

public final class LocalTimePredicate {
    public static <T extends LocalTime> Predicate<T> localTimeAfterNow() {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(localTime -> LocalTimePredicate.localTimeAfter(LocalTime.now()).test((LocalTime)localTime));
    }

    public static <T> Predicate<T> localTimeAfterNow(Function<T, LocalTime> source) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(LogicalPredicate.not(ObjectPredicate.nullValue(source))).and(obj -> LocalTimePredicate.localTimeAfterNow().test(source.apply(obj)));
    }

    public static <T extends LocalTime> Predicate<T> localTimeBeforeNow() {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(localTime -> LocalTimePredicate.localTimeBefore(LocalTime.now()).test((LocalTime)localTime));
    }

    public static <T> Predicate<T> localTimeBeforeNow(Function<T, LocalTime> source) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(LogicalPredicate.not(ObjectPredicate.nullValue(source))).and(obj -> LocalTimePredicate.localTimeBeforeNow().test(source.apply(obj)));
    }

    public static <T extends LocalTime> Predicate<T> localTimeEqualTo(LocalTime localTime) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(obj -> LogicalPredicate.not(ObjectPredicate.nullValue()).test(localTime)).and(obj -> localTime.compareTo((LocalTime)obj) == 0);
    }

    public static <T> Predicate<T> localTimeEqualTo(Function<T, LocalTime> source, LocalTime localTime) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(LogicalPredicate.not(ObjectPredicate.nullValue(source))).and(obj -> LocalTimePredicate.localTimeEqualTo(localTime).test(source.apply(obj)));
    }

    public static <T extends LocalTime> Predicate<T> localTimeAfter(LocalTime target) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(obj -> LogicalPredicate.not(ObjectPredicate.nullValue()).test(target)).and(obj -> obj.isAfter(target));
    }

    public static <T> Predicate<T> localTimeAfter(Function<T, LocalTime> source, LocalTime target) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(LogicalPredicate.not(ObjectPredicate.nullValue(source))).and(obj -> LocalTimePredicate.localTimeAfter(target).test(source.apply(obj)));
    }

    public static <T> Predicate<T> localTimeAfter(Function<T, LocalTime> source, Function<T, LocalTime> target) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(LogicalPredicate.not(ObjectPredicate.nullValue(target))).and(obj -> LocalTimePredicate.localTimeAfter(source, (LocalTime)target.apply(obj)).test(obj));
    }

    public static <T extends LocalTime> Predicate<T> localTimeAfterOrEqual(LocalTime target) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(obj -> LogicalPredicate.not(ObjectPredicate.nullValue()).test(target)).and(LogicalPredicate.is(LocalTimePredicate.localTimeAfter(target)).or(LocalTimePredicate.localTimeEqualTo(target)));
    }

    public static <T> Predicate<T> localTimeAfterOrEqual(Function<T, LocalTime> source, LocalTime target) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(LogicalPredicate.not(ObjectPredicate.nullValue(source))).and(obj -> LocalTimePredicate.localTimeAfterOrEqual(target).test(source.apply(obj)));
    }

    public static <T> Predicate<T> localTimeAfterOrEqual(Function<T, LocalTime> source, Function<T, LocalTime> target) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(LogicalPredicate.not(ObjectPredicate.nullValue(target))).and(obj -> LocalTimePredicate.localTimeAfterOrEqual(source, (LocalTime)target.apply(obj)).test(obj));
    }

    public static <T extends LocalTime> Predicate<T> localTimeBefore(LocalTime target) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(obj -> LogicalPredicate.not(ObjectPredicate.nullValue()).test(target)).and(obj -> obj.isBefore(target));
    }

    public static <T> Predicate<T> localTimeBefore(Function<T, LocalTime> source, LocalTime target) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(LogicalPredicate.not(ObjectPredicate.nullValue(source))).and(obj -> LocalTimePredicate.localTimeBefore(target).test(source.apply(obj)));
    }

    public static <T> Predicate<T> localTimeBefore(Function<T, LocalTime> source, Function<T, LocalTime> target) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(LogicalPredicate.not(ObjectPredicate.nullValue(target))).and(obj -> LocalTimePredicate.localTimeBefore(source, (LocalTime)target.apply(obj)).test(obj));
    }

    public static <T extends LocalTime> Predicate<T> localTimeBeforeOrEqual(LocalTime target) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(obj -> LogicalPredicate.not(ObjectPredicate.nullValue()).test(target)).and(LogicalPredicate.is(LocalTimePredicate.localTimeBefore(target)).or(LocalTimePredicate.localTimeEqualTo(target)));
    }

    public static <T> Predicate<T> localTimeBeforeOrEqual(Function<T, LocalTime> source, LocalTime target) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(LogicalPredicate.not(ObjectPredicate.nullValue(source))).and(obj -> LocalTimePredicate.localTimeBeforeOrEqual(target).test(source.apply(obj)));
    }

    public static <T> Predicate<T> localTimeBeforeOrEqual(Function<T, LocalTime> source, Function<T, LocalTime> target) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(LogicalPredicate.not(ObjectPredicate.nullValue(target))).and(obj -> LocalTimePredicate.localTimeBeforeOrEqual(source, (LocalTime)target.apply(obj)).test(obj));
    }

    public static <T extends LocalTime> Predicate<T> localTimeBetween(LocalTime min, LocalTime max) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(LocalTimePredicate.localTimeAfter(min).and(LocalTimePredicate.localTimeBefore(max)));
    }

    public static <T> Predicate<T> localTimeBetween(Function<T, LocalTime> source, LocalTime min, LocalTime max) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(LogicalPredicate.not(ObjectPredicate.nullValue(source))).and(obj -> LocalTimePredicate.localTimeBetween(min, max).test(source.apply(obj)));
    }

    public static <T> Predicate<T> localTimeBetween(Function<T, LocalTime> source, Function<T, LocalTime> min, LocalTime max) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(LogicalPredicate.not(ObjectPredicate.nullValue(min))).and(obj -> LocalTimePredicate.localTimeBetween(source, (LocalTime)min.apply(obj), max).test(obj));
    }

    public static <T> Predicate<T> localTimeBetween(Function<T, LocalTime> source, LocalTime min, Function<T, LocalTime> max) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(LogicalPredicate.not(ObjectPredicate.nullValue(max))).and(obj -> LocalTimePredicate.localTimeBetween(source, min, (LocalTime)max.apply(obj)).test(obj));
    }

    public static <T> Predicate<T> localTimeBetween(Function<T, LocalTime> source, Function<T, LocalTime> min, Function<T, LocalTime> max) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(LogicalPredicate.not(ObjectPredicate.nullValue(min))).and(LogicalPredicate.not(ObjectPredicate.nullValue(max))).and(obj -> LocalTimePredicate.localTimeBetween(source, (LocalTime)min.apply(obj), (LocalTime)max.apply(obj)).test(obj));
    }

    public static <T extends LocalTime> Predicate<T> localTimeBetweenOrEqual(LocalTime min, LocalTime max) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(LocalTimePredicate.localTimeAfterOrEqual(min).and(LocalTimePredicate.localTimeBeforeOrEqual(max)));
    }

    public static <T> Predicate<T> localTimeBetweenOrEqual(Function<T, LocalTime> source, LocalTime min, LocalTime max) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(LogicalPredicate.not(ObjectPredicate.nullValue(source))).and(obj -> LocalTimePredicate.localTimeBetweenOrEqual(min, max).test(source.apply(obj)));
    }

    public static <T> Predicate<T> localTimeBetweenOrEqual(Function<T, LocalTime> source, Function<T, LocalTime> min, LocalTime max) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(LogicalPredicate.not(ObjectPredicate.nullValue(min))).and(obj -> LocalTimePredicate.localTimeBetweenOrEqual(source, (LocalTime)min.apply(obj), max).test(obj));
    }

    public static <T> Predicate<T> localTimeBetweenOrEqual(Function<T, LocalTime> source, LocalTime min, Function<T, LocalTime> max) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(LogicalPredicate.not(ObjectPredicate.nullValue(max))).and(obj -> LocalTimePredicate.localTimeBetweenOrEqual(source, min, (LocalTime)max.apply(obj)).test(obj));
    }

    public static <T> Predicate<T> localTimeBetweenOrEqual(Function<T, LocalTime> source, Function<T, LocalTime> min, Function<T, LocalTime> max) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(LogicalPredicate.not(ObjectPredicate.nullValue(min))).and(LogicalPredicate.not(ObjectPredicate.nullValue(max))).and(obj -> LocalTimePredicate.localTimeBetweenOrEqual(source, (LocalTime)min.apply(obj), (LocalTime)max.apply(obj)).test(obj));
    }

    private LocalTimePredicate() {
    }
}

