/*
 * Decompiled with CFR 0.152.
 */
package br.com.fluentvalidator.predicate;

import br.com.fluentvalidator.predicate.ComparablePredicate;
import br.com.fluentvalidator.predicate.LogicalPredicate;
import br.com.fluentvalidator.predicate.ObjectPredicate;
import br.com.fluentvalidator.predicate.PredicateBuilder;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.format.ResolverStyle;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;

public final class StringPredicate {
    public static Predicate<String> isAlpha() {
        return PredicateBuilder.from(LogicalPredicate.not(StringPredicate.stringEmptyOrNull())).and(isNumeric -> isNumeric.chars().allMatch(Character::isLetter));
    }

    public static <T> Predicate<T> isAlpha(Function<T, String> source) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(obj -> StringPredicate.isAlpha().test((String)source.apply(obj)));
    }

    public static Predicate<String> isAlphaNumeric() {
        return PredicateBuilder.from(LogicalPredicate.not(StringPredicate.stringEmptyOrNull())).and(isNumeric -> isNumeric.chars().allMatch(Character::isLetterOrDigit));
    }

    public static <T> Predicate<T> isAlphaNumeric(Function<T, String> source) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(obj -> StringPredicate.isAlphaNumeric().test((String)source.apply(obj)));
    }

    public static <T> Predicate<T> isDate(Function<T, String> source, String pattern) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(obj -> StringPredicate.isDate(pattern).test((String)source.apply(obj)));
    }

    public static Predicate<String> isDate(String pattern) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(isDate -> LogicalPredicate.not(StringPredicate.stringEmptyOrNull()).test(pattern)).and(isDate -> {
            try {
                DateTimeFormatter dateFormat = DateTimeFormatter.ofPattern(pattern).withResolverStyle(ResolverStyle.STRICT);
                return Objects.nonNull(LocalDate.parse(isDate, dateFormat));
            }
            catch (IllegalArgumentException | DateTimeParseException ex) {
                return false;
            }
        });
    }

    public static <T> Predicate<T> isDateTime(Function<T, String> source, String pattern) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(obj -> StringPredicate.isDateTime(pattern).test((String)source.apply(obj)));
    }

    public static Predicate<String> isDateTime(String pattern) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(isDateTime -> LogicalPredicate.not(StringPredicate.stringEmptyOrNull()).test(pattern)).and(isDateTime -> {
            try {
                DateTimeFormatter dateFormat = DateTimeFormatter.ofPattern(pattern).withResolverStyle(ResolverStyle.STRICT);
                return Objects.nonNull(LocalDateTime.parse(isDateTime, dateFormat));
            }
            catch (IllegalArgumentException | DateTimeParseException ex) {
                return false;
            }
        });
    }

    public static Predicate<String> isNumber() {
        return PredicateBuilder.from(LogicalPredicate.not(StringPredicate.stringEmptyOrNull())).and(isNumber -> {
            try {
                new BigDecimal((String)isNumber);
            }
            catch (NumberFormatException e) {
                return false;
            }
            return true;
        });
    }

    public static <T> Predicate<T> isNumber(Function<T, String> source) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(obj -> StringPredicate.isNumber().test((String)source.apply(obj)));
    }

    public static Predicate<String> isNumeric() {
        return PredicateBuilder.from(LogicalPredicate.not(StringPredicate.stringEmptyOrNull())).and(isNumeric -> isNumeric.chars().allMatch(Character::isDigit));
    }

    public static <T> Predicate<T> isNumeric(Function<T, String> source) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(obj -> StringPredicate.isNumeric().test((String)source.apply(obj)));
    }

    public static <T> Predicate<T> isTime(Function<T, String> source, String pattern) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(obj -> StringPredicate.isTime(pattern).test((String)source.apply(obj)));
    }

    public static Predicate<String> isTime(String pattern) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(isTime -> LogicalPredicate.not(StringPredicate.stringEmptyOrNull()).test(pattern)).and(isTime -> {
            try {
                DateTimeFormatter dateFormat = DateTimeFormatter.ofPattern(pattern).withResolverStyle(ResolverStyle.STRICT);
                return Objects.nonNull(LocalTime.parse(isTime, dateFormat));
            }
            catch (IllegalArgumentException | DateTimeParseException ex) {
                return false;
            }
        });
    }

    public static <T> Predicate<T> stringContains(Function<T, String> source, String str) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(obj -> StringPredicate.stringContains(str).test((String)source.apply(obj)));
    }

    public static Predicate<String> stringContains(String str) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(stringContains -> LogicalPredicate.not(ObjectPredicate.nullValue()).test(str)).and(stringContains -> stringContains.contains(str));
    }

    public static Predicate<String> stringEmptyOrNull() {
        return PredicateBuilder.from(LogicalPredicate.is(ObjectPredicate.nullValue())).or(String::isEmpty);
    }

    public static <T> Predicate<T> stringEmptyOrNull(Function<T, String> source) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(obj -> StringPredicate.stringEmptyOrNull().test((String)source.apply(obj)));
    }

    public static <T> Predicate<T> stringEquals(Function<T, String> source, Function<T, String> target) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(obj -> StringPredicate.stringEquals(source, (String)target.apply(obj)).test(obj));
    }

    public static <T> Predicate<T> stringEquals(Function<T, String> source, String value) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(obj -> LogicalPredicate.not(ObjectPredicate.nullValue()).test(source.apply(obj))).and(obj -> StringPredicate.stringEquals(value).test(source.apply(obj)));
    }

    public static <T> Predicate<T> stringEquals(String value) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(obj -> obj.equals(value));
    }

    public static <T> Predicate<T> stringEqualsIgnoreCase(Function<T, String> source, Function<T, String> target) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(obj -> StringPredicate.stringEqualsIgnoreCase(source, (String)target.apply(obj)).test(obj));
    }

    public static <T> Predicate<T> stringEqualsIgnoreCase(Function<T, String> source, String value) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(obj -> LogicalPredicate.not(ObjectPredicate.nullValue()).test(source.apply(obj))).and(obj -> StringPredicate.stringEqualsIgnoreCase(value).test((String)source.apply(obj)));
    }

    public static Predicate<String> stringEqualsIgnoreCase(String value) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(obj -> LogicalPredicate.not(ObjectPredicate.nullValue()).test(value)).and(obj -> obj.equalsIgnoreCase(value));
    }

    public static <T> Predicate<T> stringMatches(Function<T, String> source, String regex) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(obj -> StringPredicate.stringMatches(regex).test((String)source.apply(obj)));
    }

    public static Predicate<String> stringMatches(String regex) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(stringMatches -> LogicalPredicate.not(ObjectPredicate.nullValue()).test(regex)).and(stringMatches -> stringMatches.matches(regex));
    }

    public static <T> Predicate<T> stringSize(Function<T, String> source, Function<T, String> target) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(obj -> LogicalPredicate.not(ObjectPredicate.nullValue()).test(target.apply(obj))).and(obj -> StringPredicate.stringSize(((String)target.apply(obj)).length()).test((String)source.apply(obj)));
    }

    public static <T> Predicate<T> stringSize(Function<T, String> source, Integer size) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(obj -> StringPredicate.stringSize(size).test((String)source.apply(obj)));
    }

    public static Predicate<String> stringSize(Integer size) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(stringSize -> LogicalPredicate.not(ObjectPredicate.nullValue()).test(size)).and(stringSize -> ObjectPredicate.equalObject(size).test(stringSize.length()));
    }

    public static <T> Predicate<T> stringSizeBetween(Function<T, String> source, Integer minSize, Integer maxSize) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(obj -> StringPredicate.stringSizeBetween(minSize, maxSize).test((String)source.apply(obj)));
    }

    public static Predicate<String> stringSizeBetween(Integer minSize, Integer maxSize) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(StringPredicate.stringSizeGreaterThanOrEqual(minSize).and(StringPredicate.stringSizeLessThanOrEqual(maxSize)));
    }

    public static <T> Predicate<T> stringSizeGreaterThan(Function<T, String> source, Function<T, String> target) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(obj -> LogicalPredicate.not(ObjectPredicate.nullValue()).test(target.apply(obj))).and(obj -> StringPredicate.stringSizeGreaterThan(((String)target.apply(obj)).length()).test((String)source.apply(obj)));
    }

    public static <T> Predicate<T> stringSizeGreaterThan(Function<T, String> source, Integer size) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(obj -> StringPredicate.stringSizeGreaterThan(size).test((String)source.apply(obj)));
    }

    public static Predicate<String> stringSizeGreaterThan(Integer size) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(stringSizeGreaterThan -> LogicalPredicate.not(ObjectPredicate.nullValue()).test(size)).and(stringSizeGreaterThan -> ComparablePredicate.greaterThan(size).test(stringSizeGreaterThan.length()));
    }

    public static <T> Predicate<T> stringSizeGreaterThanOrEqual(Function<T, String> source, Function<T, String> target) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(StringPredicate.stringSizeGreaterThan(source, target).or(StringPredicate.stringSize(source, target)));
    }

    public static <T> Predicate<T> stringSizeGreaterThanOrEqual(Function<T, String> source, Integer size) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(StringPredicate.stringSizeGreaterThan(source, size).or(StringPredicate.stringSize(source, size)));
    }

    public static Predicate<String> stringSizeGreaterThanOrEqual(Integer size) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(StringPredicate.stringSizeGreaterThan(size).or(StringPredicate.stringSize(size)));
    }

    public static <T> Predicate<T> stringSizeLessThan(Function<T, String> source, Function<T, String> target) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(obj -> LogicalPredicate.not(ObjectPredicate.nullValue()).test(target.apply(obj))).and(obj -> StringPredicate.stringSizeLessThan(((String)target.apply(obj)).length()).test((String)source.apply(obj)));
    }

    public static <T> Predicate<T> stringSizeLessThan(Function<T, String> source, Integer size) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(obj -> StringPredicate.stringSizeLessThan(size).test((String)source.apply(obj)));
    }

    public static Predicate<String> stringSizeLessThan(Integer size) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(stringSizeLessThan -> LogicalPredicate.not(ObjectPredicate.nullValue()).test(size)).and(stringSizeLessThan -> ComparablePredicate.lessThan(size).test(stringSizeLessThan.length()));
    }

    public static <T> Predicate<T> stringSizeLessThanOrEqual(Function<T, String> source, Function<T, String> target) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(StringPredicate.stringSizeLessThan(source, target).or(StringPredicate.stringSize(source, target)));
    }

    public static <T> Predicate<T> stringSizeLessThanOrEqual(Function<T, String> source, Integer size) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(StringPredicate.stringSizeLessThan(source, size).or(StringPredicate.stringSize(source, size)));
    }

    public static Predicate<String> stringSizeLessThanOrEqual(Integer size) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(StringPredicate.stringSizeLessThan(size).or(StringPredicate.stringSize(size)));
    }

    private StringPredicate() {
    }
}

