/*
 * Decompiled with CFR 0.152.
 */
package br.com.fluentvalidator.predicate;

import br.com.fluentvalidator.predicate.ComparablePredicate;
import br.com.fluentvalidator.predicate.LogicalPredicate;
import br.com.fluentvalidator.predicate.ObjectPredicate;
import br.com.fluentvalidator.predicate.PredicateBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Function;
import java.util.function.Predicate;

public final class CollectionPredicate {
    public static <E, T extends Collection<E>> Predicate<T> empty() {
        return PredicateBuilder.from(LogicalPredicate.is(ObjectPredicate.nullValue())).or(Collection::isEmpty);
    }

    public static <T, E> Predicate<T> empty(Function<T, Collection<E>> source) {
        return PredicateBuilder.from(LogicalPredicate.is(ObjectPredicate.nullValue())).or(obj -> LogicalPredicate.is(ObjectPredicate.nullValue()).test(source.apply(obj))).or(obj -> ((Collection)source.apply(obj)).isEmpty());
    }

    public static <E, T extends Collection<E>> Predicate<T> hasAny(Collection<E> objects) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(obj -> LogicalPredicate.not(ObjectPredicate.nullValue()).test(objects)).and(hasAny -> hasAny.stream().anyMatch(objects::contains));
    }

    public static <E, T extends Collection<E>> Predicate<T> hasAny(E[] objects) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(obj -> LogicalPredicate.not(ObjectPredicate.nullValue()).test(objects)).and(obj -> CollectionPredicate.hasAny(Arrays.asList(objects)).test((Collection)obj));
    }

    public static <T, E> Predicate<T> hasAny(Function<T, Collection<E>> source, Collection<E> objects) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(obj -> CollectionPredicate.hasAny(objects).test(source.apply(obj)));
    }

    public static <T, E> Predicate<T> hasAny(Function<T, Collection<E>> source, E[] objects) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(obj -> CollectionPredicate.hasAny(objects).test(source.apply(obj)));
    }

    public static <E, T extends Collection<E>> Predicate<T> hasItem(E object) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(obj -> obj.contains(object));
    }

    public static <T, E> Predicate<T> hasItem(Function<T, Collection<E>> source, E object) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(obj -> CollectionPredicate.hasItem(object).test(source.apply(obj)));
    }

    public static <E, T extends Collection<E>> Predicate<T> hasItems(Collection<E> objects) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(obj -> LogicalPredicate.not(ObjectPredicate.nullValue()).test(objects)).and(obj -> obj.containsAll(objects));
    }

    public static <E, T extends Collection<E>> Predicate<T> hasItems(E[] objects) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(obj -> LogicalPredicate.not(ObjectPredicate.nullValue()).test(objects)).and(obj -> CollectionPredicate.hasItems(Arrays.asList(objects)).test((Collection)obj));
    }

    public static <T, E> Predicate<T> hasItems(Function<T, Collection<E>> source, Collection<E> objects) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(obj -> CollectionPredicate.hasItems(objects).test(source.apply(obj)));
    }

    public static <T, E> Predicate<T> hasItems(Function<T, Collection<E>> source, E[] objects) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(obj -> CollectionPredicate.hasItems(objects).test(source.apply(obj)));
    }

    public static <T, E> Predicate<T> hasSize(Function<T, Collection<E>> source, Function<T, Integer> size) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(obj -> LogicalPredicate.not(ObjectPredicate.nullValue(size)).test(obj)).and(obj -> LogicalPredicate.not(ObjectPredicate.nullValue(source)).test(obj)).and(obj -> ComparablePredicate.equalTo(size.apply(obj)).test(((Collection)source.apply(obj)).size()));
    }

    public static <T, E> Predicate<T> hasSize(Function<T, Collection<E>> source, Integer size) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(obj -> LogicalPredicate.not(ObjectPredicate.nullValue(source)).test(obj)).and(obj -> ComparablePredicate.equalTo(size).test(((Collection)source.apply(obj)).size()));
    }

    public static <E, T extends Collection<E>> Predicate<T> hasSize(Integer size) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(obj -> ComparablePredicate.equalTo(size).test(obj.size()));
    }

    public static <T, E> Predicate<T> hasSizeBetween(Function<T, Collection<E>> source, Integer min, Integer max) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(obj -> LogicalPredicate.not(ObjectPredicate.nullValue(source)).test(obj)).and(obj -> ComparablePredicate.between(min, max).test(((Collection)source.apply(obj)).size()));
    }

    public static <E, T extends Collection<E>> Predicate<T> hasSizeBetween(Integer min, Integer max) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(ComparablePredicate.between(Collection::size, min, max));
    }

    public static <T, E> Predicate<T> hasSizeBetweenInclusive(Function<T, Collection<E>> source, Integer min, Integer max) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(obj -> LogicalPredicate.not(ObjectPredicate.nullValue(source)).test(obj)).and(obj -> ComparablePredicate.betweenInclusive(min, max).test(((Collection)source.apply(obj)).size()));
    }

    public static <E, T extends Collection<E>> Predicate<T> hasSizeBetweenInclusive(Integer min, Integer max) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(ComparablePredicate.betweenInclusive(Collection::size, min, max));
    }

    private CollectionPredicate() {
    }
}

