/*
 * Decompiled with CFR 0.152.
 */
package br.com.fluentvalidator.predicate;

import br.com.fluentvalidator.function.FunctionBuilder;
import br.com.fluentvalidator.predicate.LogicalPredicate;
import br.com.fluentvalidator.predicate.ObjectPredicate;
import br.com.fluentvalidator.predicate.PredicateBuilder;
import java.util.function.Function;
import java.util.function.Predicate;

public final class ComparablePredicate {
    private static final Integer ZERO = 0;

    public static <E, T extends Comparable<E>> Predicate<T> between(E min, E max) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(ComparablePredicate.lessThan(max).and(ComparablePredicate.greaterThan(min)));
    }

    public static <E, T extends Comparable<E>> Predicate<T> between(E min, Function<T, E> max) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(ComparablePredicate.between(FunctionBuilder.of(fn -> min), max));
    }

    public static <E, T extends Comparable<E>> Predicate<T> between(Function<T, E> min, E max) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(ComparablePredicate.between(min, FunctionBuilder.of(fn -> max)));
    }

    public static <T, E extends Comparable<E>> Predicate<T> between(Function<T, E> source, E min, E max) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(obj -> ComparablePredicate.between(min, max).test(source.apply(obj)));
    }

    public static <T, E extends Comparable<E>> Predicate<T> between(Function<T, E> source, E min, Function<T, E> max) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(ComparablePredicate.between(source, FunctionBuilder.of(fn -> min), max));
    }

    public static <E, T extends Comparable<E>> Predicate<T> between(Function<T, E> min, Function<T, E> max) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(LogicalPredicate.not(ObjectPredicate.nullValue(min))).and(LogicalPredicate.not(ObjectPredicate.nullValue(max))).and(obj -> ComparablePredicate.lessThan(max.apply(obj)).and(ComparablePredicate.greaterThan(min.apply(obj))).test((Comparable)obj));
    }

    public static <T, E extends Comparable<E>> Predicate<T> between(Function<T, E> source, Function<T, E> min, E max) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(ComparablePredicate.between(source, min, FunctionBuilder.of(fn -> max)));
    }

    public static <T, E extends Comparable<E>> Predicate<T> between(Function<T, E> source, Function<T, E> min, Function<T, E> max) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(LogicalPredicate.not(ObjectPredicate.nullValue(source))).and(LogicalPredicate.not(ObjectPredicate.nullValue(min))).and(LogicalPredicate.not(ObjectPredicate.nullValue(max))).and(obj -> ComparablePredicate.lessThan(max.apply(obj)).and(ComparablePredicate.greaterThan(min.apply(obj))).test(source.apply(obj)));
    }

    public static <E, T extends Comparable<E>> Predicate<T> betweenInclusive(E min, E max) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(ComparablePredicate.lessThanOrEqual(max).and(ComparablePredicate.greaterThanOrEqual(min)));
    }

    public static <E, T extends Comparable<E>> Predicate<T> betweenInclusive(E min, Function<T, E> max) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(ComparablePredicate.betweenInclusive(FunctionBuilder.of(fn -> min), max));
    }

    public static <E, T extends Comparable<E>> Predicate<T> betweenInclusive(Function<T, E> min, E max) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(ComparablePredicate.betweenInclusive(min, FunctionBuilder.of(fn -> max)));
    }

    public static <T, E extends Comparable<E>> Predicate<T> betweenInclusive(Function<T, E> source, E min, E max) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(ComparablePredicate.betweenInclusive(source, FunctionBuilder.of(fn -> min), FunctionBuilder.of(fn -> max)));
    }

    public static <T, E extends Comparable<E>> Predicate<T> betweenInclusive(Function<T, E> source, E min, Function<T, E> max) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(ComparablePredicate.betweenInclusive(source, FunctionBuilder.of(fn -> min), max));
    }

    public static <E, T extends Comparable<E>> Predicate<T> betweenInclusive(Function<T, E> min, Function<T, E> max) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(LogicalPredicate.not(ObjectPredicate.nullValue(min))).and(LogicalPredicate.not(ObjectPredicate.nullValue(max))).and(obj -> ComparablePredicate.lessThanOrEqual(max.apply(obj)).and(ComparablePredicate.greaterThanOrEqual(min.apply(obj))).test((Comparable)obj));
    }

    public static <T, E extends Comparable<E>> Predicate<T> betweenInclusive(Function<T, E> source, Function<T, E> min, E max) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(ComparablePredicate.betweenInclusive(source, min, FunctionBuilder.of(fn -> max)));
    }

    public static <T, E extends Comparable<E>> Predicate<T> betweenInclusive(Function<T, E> source, Function<T, E> min, Function<T, E> max) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(LogicalPredicate.not(ObjectPredicate.nullValue(source))).and(LogicalPredicate.not(ObjectPredicate.nullValue(min))).and(LogicalPredicate.not(ObjectPredicate.nullValue(max))).and(obj -> ComparablePredicate.betweenInclusive(min.apply(obj), max.apply(obj)).test(source.apply(obj)));
    }

    public static <E, T extends Comparable<E>> Predicate<T> equalTo(E value) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(LogicalPredicate.not(ObjectPredicate.nullValue(fn -> value))).and(obj -> obj.compareTo(value) == ZERO.intValue());
    }

    public static <T, E extends Comparable<E>> Predicate<T> equalTo(Function<T, E> source, E value) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(ComparablePredicate.equalTo(source, FunctionBuilder.of(fn -> value)));
    }

    public static <T, E extends Comparable<E>> Predicate<T> equalTo(Function<T, E> source, Function<T, E> target) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(LogicalPredicate.not(ObjectPredicate.nullValue(source))).and(LogicalPredicate.not(ObjectPredicate.nullValue(target))).and(obj -> ((Comparable)source.apply(obj)).compareTo(target.apply(obj)) == ZERO.intValue());
    }

    public static <E, T extends Comparable<E>> Predicate<T> greaterThan(E min) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(LogicalPredicate.not(ObjectPredicate.nullValue(fn -> min))).and(obj -> obj.compareTo(min) > ZERO);
    }

    public static <T, E extends Comparable<E>> Predicate<T> greaterThan(Function<T, E> source, E min) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(ComparablePredicate.greaterThan(source, FunctionBuilder.of(fn -> min)));
    }

    public static <T, E extends Comparable<E>> Predicate<T> greaterThan(Function<T, E> source, Function<T, E> target) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(LogicalPredicate.not(ObjectPredicate.nullValue(source))).and(LogicalPredicate.not(ObjectPredicate.nullValue(target))).and(obj -> ((Comparable)source.apply(obj)).compareTo(target.apply(obj)) > ZERO);
    }

    public static <E, T extends Comparable<E>> Predicate<T> greaterThanOrEqual(E min) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(ComparablePredicate.greaterThan(min).or(ComparablePredicate.equalTo(min)));
    }

    public static <T, E extends Comparable<E>> Predicate<T> greaterThanOrEqual(Function<T, E> source, E min) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(ComparablePredicate.greaterThanOrEqual(source, FunctionBuilder.of(fn -> min)));
    }

    public static <T, E extends Comparable<E>> Predicate<T> greaterThanOrEqual(Function<T, E> source, Function<T, E> target) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(LogicalPredicate.not(ObjectPredicate.nullValue(source))).and(LogicalPredicate.not(ObjectPredicate.nullValue(target))).and(ComparablePredicate.greaterThan(source, target).or(ComparablePredicate.equalTo(source, target)));
    }

    public static <E, T extends Comparable<E>> Predicate<T> lessThan(E max) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(LogicalPredicate.not(ObjectPredicate.nullValue(fn -> max))).and(lessThan -> lessThan.compareTo(max) < ZERO);
    }

    public static <T, E extends Comparable<E>> Predicate<T> lessThan(Function<T, E> source, E max) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(ComparablePredicate.lessThan(source, FunctionBuilder.of(fn -> max)));
    }

    public static <T, E extends Comparable<E>> Predicate<T> lessThan(Function<T, E> source, Function<T, E> target) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(LogicalPredicate.not(ObjectPredicate.nullValue(source))).and(LogicalPredicate.not(ObjectPredicate.nullValue(target))).and(obj -> ((Comparable)source.apply(obj)).compareTo(target.apply(obj)) < ZERO);
    }

    public static <E, T extends Comparable<E>> Predicate<T> lessThanOrEqual(E max) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(ComparablePredicate.lessThan(max).or(ComparablePredicate.equalTo(max)));
    }

    public static <T, E extends Comparable<E>> Predicate<T> lessThanOrEqual(Function<T, E> source, E max) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(ComparablePredicate.lessThanOrEqual(source, FunctionBuilder.of(fn -> max)));
    }

    public static <T, E extends Comparable<E>> Predicate<T> lessThanOrEqual(Function<T, E> source, Function<T, E> target) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(LogicalPredicate.not(ObjectPredicate.nullValue(source))).and(LogicalPredicate.not(ObjectPredicate.nullValue(target))).and(ComparablePredicate.lessThan(source, target).or(ComparablePredicate.equalTo(source, target)));
    }

    private ComparablePredicate() {
    }
}

