/*
 * Decompiled with CFR 0.152.
 */
package br.com.fluentvalidator.predicate;

import br.com.fluentvalidator.predicate.LogicalPredicate;
import br.com.fluentvalidator.predicate.ObjectPredicate;
import br.com.fluentvalidator.predicate.PredicateBuilder;
import br.com.fluentvalidator.predicate.StringPredicate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.function.Function;
import java.util.function.Predicate;

public final class DateTimePredicate {
    public static <T> Predicate<T> dateTimeBetween(Function<T, String> source, String dateStringMin, String dateStringMax, String pattern) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(obj -> DateTimePredicate.dateTimeBetween(dateStringMin, dateStringMax, pattern).test((String)source.apply(obj)));
    }

    public static Predicate<String> dateTimeBetween(String dateStringMin, String dateStringMax, String pattern) {
        return PredicateBuilder.from(DateTimePredicate.dateTimeLessThanOrEqual(dateStringMax, pattern).and(DateTimePredicate.dateTimeGreaterThanOrEqual(dateStringMin, pattern)));
    }

    public static <T> Predicate<T> dateTimeEqualTo(Function<T, String> source, Function<T, String> target, String pattern) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(obj -> DateTimePredicate.dateTimeEqualTo((String)target.apply(obj), pattern).test((String)source.apply(obj)));
    }

    public static <T> Predicate<T> dateTimeEqualTo(Function<T, String> source, String target, String pattern) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(obj -> DateTimePredicate.dateTimeEqualTo(target, pattern).test((String)source.apply(obj)));
    }

    public static Predicate<String> dateTimeEqualTo(String dateString, String pattern) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(dateTimeEqualTo -> LogicalPredicate.not(StringPredicate.stringEmptyOrNull()).test(dateString)).and(dateTimeEqualTo -> LogicalPredicate.not(StringPredicate.stringEmptyOrNull()).test(pattern)).and(dateTimeEqualTo -> {
            try {
                DateTimeFormatter dateFormat = DateTimeFormatter.ofPattern(pattern);
                LocalDateTime dateTimeTest = LocalDateTime.parse(dateTimeEqualTo, dateFormat);
                LocalDateTime dateTime = LocalDateTime.parse(dateString, dateFormat);
                return dateTimeTest.isEqual(dateTime);
            }
            catch (IllegalArgumentException | DateTimeParseException ex) {
                return false;
            }
        });
    }

    public static <T> Predicate<T> dateTimeGreaterThan(Function<T, String> source, Function<T, String> target, String pattern) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(obj -> DateTimePredicate.dateTimeGreaterThan((String)target.apply(obj), pattern).test((String)source.apply(obj)));
    }

    public static <T> Predicate<T> dateTimeGreaterThan(Function<T, String> source, String target, String pattern) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(obj -> DateTimePredicate.dateTimeGreaterThan(target, pattern).test((String)source.apply(obj)));
    }

    public static Predicate<String> dateTimeGreaterThan(String dateString, String pattern) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(dateTimeGreaterThan -> LogicalPredicate.not(StringPredicate.stringEmptyOrNull()).test(dateString)).and(dateTimeGreaterThan -> LogicalPredicate.not(StringPredicate.stringEmptyOrNull()).test(pattern)).and(dateTimeGreaterThan -> {
            try {
                DateTimeFormatter dateFormat = DateTimeFormatter.ofPattern(pattern);
                LocalDateTime dateTimeTest = LocalDateTime.parse(dateTimeGreaterThan, dateFormat);
                LocalDateTime dateTime = LocalDateTime.parse(dateString, dateFormat);
                return dateTimeTest.isAfter(dateTime);
            }
            catch (IllegalArgumentException | DateTimeParseException ex) {
                return false;
            }
        });
    }

    public static <T> Predicate<T> dateTimeGreaterThanOrEqual(Function<T, String> source, Function<T, String> target, String pattern) {
        return PredicateBuilder.from(DateTimePredicate.dateTimeGreaterThan(source, target, pattern).or(DateTimePredicate.dateTimeEqualTo(source, target, pattern)));
    }

    public static <T> Predicate<T> dateTimeGreaterThanOrEqual(Function<T, String> source, String target, String pattern) {
        return PredicateBuilder.from(DateTimePredicate.dateTimeGreaterThan(source, target, pattern).or(DateTimePredicate.dateTimeEqualTo(source, target, pattern)));
    }

    public static Predicate<String> dateTimeGreaterThanOrEqual(String dateString, String pattern) {
        return PredicateBuilder.from(DateTimePredicate.dateTimeGreaterThan(dateString, pattern).or(DateTimePredicate.dateTimeEqualTo(dateString, pattern)));
    }

    public static <T> Predicate<T> dateTimeLessThan(Function<T, String> source, Function<T, String> target, String pattern) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(obj -> DateTimePredicate.dateTimeLessThan((String)target.apply(obj), pattern).test((String)source.apply(obj)));
    }

    public static <T> Predicate<T> dateTimeLessThan(Function<T, String> source, String target, String pattern) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(obj -> DateTimePredicate.dateTimeLessThan(target, pattern).test((String)source.apply(obj)));
    }

    public static Predicate<String> dateTimeLessThan(String dateString, String pattern) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(dateTimeLessThan -> LogicalPredicate.not(StringPredicate.stringEmptyOrNull()).test(dateString)).and(dateTimeLessThan -> LogicalPredicate.not(StringPredicate.stringEmptyOrNull()).test(pattern)).and(dateTimeLessThan -> {
            try {
                DateTimeFormatter dateFormat = DateTimeFormatter.ofPattern(pattern);
                LocalDateTime dateTest = LocalDateTime.parse(dateTimeLessThan, dateFormat);
                LocalDateTime date = LocalDateTime.parse(dateString, dateFormat);
                return dateTest.isBefore(date);
            }
            catch (IllegalArgumentException | DateTimeParseException ex) {
                return false;
            }
        });
    }

    public static <T> Predicate<T> dateTimeLessThanOrEqual(Function<T, String> source, Function<T, String> target, String pattern) {
        return PredicateBuilder.from(DateTimePredicate.dateTimeLessThan(source, target, pattern).or(DateTimePredicate.dateTimeEqualTo(source, target, pattern)));
    }

    public static <T> Predicate<T> dateTimeLessThanOrEqual(Function<T, String> source, String target, String pattern) {
        return PredicateBuilder.from(DateTimePredicate.dateTimeLessThan(source, target, pattern).or(DateTimePredicate.dateTimeEqualTo(source, target, pattern)));
    }

    public static Predicate<String> dateTimeLessThanOrEqual(String dateString, String pattern) {
        return PredicateBuilder.from(DateTimePredicate.dateTimeLessThan(dateString, pattern).or(DateTimePredicate.dateTimeEqualTo(dateString, pattern)));
    }

    private DateTimePredicate() {
    }
}

