/*
 * Decompiled with CFR 0.152.
 */
package com.github.mvysny.dynatest.engine;

import com.github.mvysny.dynatest.DynaNodeGroup;
import com.github.mvysny.dynatest.Outcome;
import com.github.mvysny.dynatest.engine.DynaNodeGroupImpl;
import com.github.mvysny.dynatest.engine.DynaNodeImpl;
import com.github.mvysny.dynatest.engine.DynaNodeTestDescriptor;
import com.github.mvysny.dynatest.engine.DynaNodeTestImpl;
import com.github.mvysny.dynatest.engine.DynaTestEngineKt;
import java.util.List;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.descriptor.AbstractTestDescriptor;
import org.junit.platform.engine.support.hierarchical.EngineExecutionContext;
import org.junit.platform.engine.support.hierarchical.Node;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00000\u000fH\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u001a\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u00132\b\u0010\u0019\u001a\u0004\u0018\u00010\u0017J\u0006\u0010\u001a\u001a\u00020\u0013J\u001e\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00130\u001dH\u0002J\u0006\u0010\u001e\u001a\u00020\u0013J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0003H\u0016R\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\""}, d2={"Lcom/github/mvysny/dynatest/engine/DynaNodeTestDescriptor;", "Lorg/junit/platform/engine/support/descriptor/AbstractTestDescriptor;", "Lorg/junit/platform/engine/support/hierarchical/Node;", "Lorg/junit/platform/engine/support/hierarchical/EngineExecutionContext;", "parentId", "Lorg/junit/platform/engine/UniqueId;", "node", "Lcom/github/mvysny/dynatest/engine/DynaNodeImpl;", "(Lorg/junit/platform/engine/UniqueId;Lcom/github/mvysny/dynatest/engine/DynaNodeImpl;)V", "isEnabled", "", "()Z", "getNode", "()Lcom/github/mvysny/dynatest/engine/DynaNodeImpl;", "getPathFromRoot", "", "getType", "Lorg/junit/platform/engine/TestDescriptor$Type;", "runAfterEach", "", "testName", "", "testFailure", "", "runAfterGroup", "t", "runBeforeGroup", "runBlock", "block", "Lkotlin/Function0;", "runTest", "shouldBeSkipped", "Lorg/junit/platform/engine/support/hierarchical/Node$SkipResult;", "context", "dynatest-engine"})
@SourceDebugExtension(value={"SMAP\nDynaTestEngine.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DynaTestEngine.kt\ncom/github/mvysny/dynatest/engine/DynaNodeTestDescriptor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,292:1\n1855#2,2:293\n1855#2,2:295\n1855#2,2:297\n1855#2:299\n1855#2,2:300\n1856#2:302\n1855#2,2:303\n*S KotlinDebug\n*F\n+ 1 DynaTestEngine.kt\ncom/github/mvysny/dynatest/engine/DynaNodeTestDescriptor\n*L\n167#1:293,2\n180#1:295,2\n192#1:297,2\n210#1:299\n213#1:300,2\n210#1:302\n246#1:303,2\n*E\n"})
public final class DynaNodeTestDescriptor
extends AbstractTestDescriptor
implements Node<EngineExecutionContext> {
    @NotNull
    private final DynaNodeImpl node;

    public DynaNodeTestDescriptor(@NotNull UniqueId parentId, @NotNull DynaNodeImpl node) {
        Intrinsics.checkNotNullParameter((Object)parentId, (String)"parentId");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        super(DynaTestEngineKt.access$append(parentId, node), node.getName$dynatest_engine(), node.toTestSource());
        this.node = node;
        if (this.node instanceof DynaNodeGroup) {
            DynaNodeImpl dynaNodeImpl = this.node;
            Intrinsics.checkNotNull((Object)dynaNodeImpl, (String)"null cannot be cast to non-null type com.github.mvysny.dynatest.engine.DynaNodeGroupImpl");
            Iterable $this$forEach$iv = ((DynaNodeGroupImpl)dynaNodeImpl).getChildren$dynatest_engine();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                DynaNodeImpl it = (DynaNodeImpl)element$iv;
                boolean bl = false;
                UniqueId uniqueId = this.getUniqueId();
                Intrinsics.checkNotNullExpressionValue((Object)uniqueId, (String)"getUniqueId(...)");
                this.addChild((TestDescriptor)new DynaNodeTestDescriptor(uniqueId, it));
            }
        }
    }

    @NotNull
    public final DynaNodeImpl getNode() {
        return this.node;
    }

    public final boolean isEnabled() {
        return this.node.getEnabled$dynatest_engine();
    }

    @NotNull
    public TestDescriptor.Type getType() {
        TestDescriptor.Type type;
        DynaNodeImpl dynaNodeImpl = this.node;
        if (dynaNodeImpl instanceof DynaNodeGroupImpl) {
            type = TestDescriptor.Type.CONTAINER;
        } else if (dynaNodeImpl instanceof DynaNodeTestImpl) {
            type = TestDescriptor.Type.TEST;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return type;
    }

    public final void runBeforeGroup() {
        if (this.node instanceof DynaNodeGroup && this.isEnabled()) {
            DynaNodeImpl dynaNodeImpl = this.node;
            Intrinsics.checkNotNull((Object)dynaNodeImpl, (String)"null cannot be cast to non-null type com.github.mvysny.dynatest.engine.DynaNodeGroupImpl");
            Iterable $this$forEach$iv = ((DynaNodeGroupImpl)dynaNodeImpl).getBeforeGroup$dynatest_engine();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Function1 it = (Function1)element$iv;
                boolean bl = false;
                it.invoke((Object)Unit.INSTANCE);
            }
        }
    }

    public final void runAfterGroup(@Nullable Throwable t) {
        Throwable tf = null;
        tf = t;
        if (this.node instanceof DynaNodeGroup && this.isEnabled()) {
            DynaNodeImpl dynaNodeImpl = this.node;
            Intrinsics.checkNotNull((Object)dynaNodeImpl, (String)"null cannot be cast to non-null type com.github.mvysny.dynatest.engine.DynaNodeGroupImpl");
            Iterable $this$forEach$iv = ((DynaNodeGroupImpl)dynaNodeImpl).getAfterGroup$dynatest_engine();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Function2 it = (Function2)element$iv;
                boolean bl = false;
                try {
                    it.invoke((Object)Unit.INSTANCE, (Object)new Outcome(null, tf));
                }
                catch (Throwable ex) {
                    Throwable throwable = tf;
                    if (throwable == null) {
                        tf = ex;
                        continue;
                    }
                    ExceptionsKt.addSuppressed((Throwable)throwable, (Throwable)ex);
                }
            }
        }
        if (tf != null && t == null) {
            throw tf;
        }
    }

    private final void runBlock(String testName, Function0<Unit> block) {
        block5: {
            DynaNodeTestDescriptor lastNodeWithBeforeEachRan = null;
            try {
                Iterable $this$forEach$iv = this.getPathFromRoot();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    DynaNodeTestDescriptor descriptor = (DynaNodeTestDescriptor)((Object)element$iv);
                    boolean bl = false;
                    lastNodeWithBeforeEachRan = descriptor;
                    if (!(descriptor.node instanceof DynaNodeGroup)) continue;
                    DynaNodeImpl dynaNodeImpl = descriptor.node;
                    Intrinsics.checkNotNull((Object)dynaNodeImpl, (String)"null cannot be cast to non-null type com.github.mvysny.dynatest.engine.DynaNodeGroupImpl");
                    Iterable $this$forEach$iv2 = ((DynaNodeGroupImpl)dynaNodeImpl).getBeforeEach$dynatest_engine();
                    boolean $i$f$forEach2 = false;
                    for (Object element$iv2 : $this$forEach$iv2) {
                        Function1 it = (Function1)element$iv2;
                        boolean bl2 = false;
                        it.invoke((Object)Unit.INSTANCE);
                    }
                }
                block.invoke();
            }
            catch (Throwable t) {
                DynaNodeTestDescriptor dynaNodeTestDescriptor = lastNodeWithBeforeEachRan;
                if (dynaNodeTestDescriptor != null) {
                    dynaNodeTestDescriptor.runAfterEach(testName, t);
                }
                throw t;
            }
            DynaNodeTestDescriptor dynaNodeTestDescriptor = lastNodeWithBeforeEachRan;
            if (dynaNodeTestDescriptor == null) break block5;
            dynaNodeTestDescriptor.runAfterEach(testName, null);
        }
    }

    public final void runTest() {
        if (this.isEnabled()) {
            this.runBlock(this.node.getName$dynatest_engine(), (Function0<Unit>)((Function0)new Function0<Unit>(this){
                final /* synthetic */ DynaNodeTestDescriptor this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                public final void invoke() {
                    DynaNodeImpl dynaNodeImpl = this.this$0.getNode();
                    Intrinsics.checkNotNull((Object)dynaNodeImpl, (String)"null cannot be cast to non-null type com.github.mvysny.dynatest.engine.DynaNodeTestImpl");
                    ((DynaNodeTestImpl)dynaNodeImpl).getBody$dynatest_engine().invoke((Object)this.this$0.getNode());
                }
            }));
        }
    }

    private final List<DynaNodeTestDescriptor> getPathFromRoot() {
        return CollectionsKt.reversed((Iterable)SequencesKt.toList((Sequence)SequencesKt.generateSequence((Object)((Object)this), (Function1)getPathFromRoot.1.INSTANCE)));
    }

    private final void runAfterEach(String testName, Throwable testFailure) {
        Throwable tf = null;
        tf = testFailure;
        if (this.isEnabled()) {
            Object var5_6;
            if (this.node instanceof DynaNodeGroup) {
                DynaNodeImpl dynaNodeImpl = this.node;
                Intrinsics.checkNotNull((Object)dynaNodeImpl, (String)"null cannot be cast to non-null type com.github.mvysny.dynatest.engine.DynaNodeGroupImpl");
                Iterable $this$forEach$iv = ((DynaNodeGroupImpl)dynaNodeImpl).getAfterEach$dynatest_engine();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Function2 afterEachBlock = (Function2)element$iv;
                    boolean bl = false;
                    try {
                        afterEachBlock.invoke((Object)Unit.INSTANCE, (Object)new Outcome(testName, tf));
                    }
                    catch (Throwable t) {
                        Throwable throwable = tf;
                        if (throwable == null) {
                            tf = t;
                            continue;
                        }
                        ExceptionsKt.addSuppressed((Throwable)throwable, (Throwable)t);
                    }
                }
            }
            DynaNodeTestDescriptor dynaNodeTestDescriptor = (var5_6 = this.getParent().orElse(null)) instanceof DynaNodeTestDescriptor ? (DynaNodeTestDescriptor)var5_6 : null;
            if (dynaNodeTestDescriptor != null) {
                dynaNodeTestDescriptor.runAfterEach(testName, tf);
            }
        }
        if (testFailure == null && tf != null) {
            throw tf;
        }
    }

    @NotNull
    public Node.SkipResult shouldBeSkipped(@NotNull EngineExecutionContext context) {
        Node.SkipResult skipResult;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (this.node.getEnabled$dynatest_engine()) {
            Node.SkipResult skipResult2 = Node.SkipResult.doNotSkip();
            skipResult = skipResult2;
            Intrinsics.checkNotNullExpressionValue((Object)skipResult2, (String)"doNotSkip(...)");
        } else {
            Node.SkipResult skipResult3 = Node.SkipResult.skip((String)"x");
            skipResult = skipResult3;
            Intrinsics.checkNotNullExpressionValue((Object)skipResult3, (String)"skip(...)");
        }
        return skipResult;
    }
}

