/*
 * Decompiled with CFR 0.152.
 */
package com.github.mvysny.dynatest.engine;

import java.io.File;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\t\u001a\u0004\u0018\u00010\n*\u00020\u000bH\u0000\u001a\u000e\u0010\t\u001a\u0004\u0018\u00010\n*\u00020\fH\u0000\"\u0014\u0010\u0000\u001a\u00020\u00018@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0000\u0010\u0002\"\u001e\u0010\u0003\u001a\u0004\u0018\u00010\u0001X\u0080\u000e\u00a2\u0006\u0010\n\u0002\u0010\b\u001a\u0004\b\u0004\u0010\u0005\"\u0004\b\u0006\u0010\u0007\u00a8\u0006\r"}, d2={"isRunningInsideGradle", "", "()Z", "pretendIsRunningInsideGradle", "getPretendIsRunningInsideGradle", "()Ljava/lang/Boolean;", "setPretendIsRunningInsideGradle", "(Ljava/lang/Boolean;)V", "Ljava/lang/Boolean;", "toFile", "Ljava/io/File;", "Ljava/net/URI;", "Ljava/net/URL;", "dynatest-engine"})
@SourceDebugExtension(value={"SMAP\nUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Utils.kt\ncom/github/mvysny/dynatest/engine/UtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,42:1\n1747#2,3:43\n*S KotlinDebug\n*F\n+ 1 Utils.kt\ncom/github/mvysny/dynatest/engine/UtilsKt\n*L\n22#1:43,3\n*E\n"})
public final class UtilsKt {
    @Nullable
    private static Boolean pretendIsRunningInsideGradle;

    @Nullable
    public static final Boolean getPretendIsRunningInsideGradle() {
        return pretendIsRunningInsideGradle;
    }

    public static final void setPretendIsRunningInsideGradle(@Nullable Boolean bl) {
        pretendIsRunningInsideGradle = bl;
    }

    public static final boolean isRunningInsideGradle() {
        if (pretendIsRunningInsideGradle != null) {
            Boolean bl = pretendIsRunningInsideGradle;
            Intrinsics.checkNotNull((Object)bl);
            return bl;
        }
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            Intrinsics.checkNotNullExpressionValue((Object)classLoader, (String)"getContextClassLoader(...)");
            ClassLoader classLoader2 = classLoader;
            if (classLoader2 instanceof URLClassLoader) {
                boolean bl;
                block7: {
                    URL[] uRLArray = ((URLClassLoader)classLoader2).getURLs();
                    Intrinsics.checkNotNullExpressionValue((Object)uRLArray, (String)"getURLs(...)");
                    List jars = ArraysKt.toList((Object[])uRLArray);
                    Iterable $this$any$iv = jars;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            URL it = (URL)element$iv;
                            boolean bl2 = false;
                            String string = it.toString();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                            if (!StringsKt.contains$default((CharSequence)string, (CharSequence)"gradle-worker.jar", (boolean)false, (int)2, null)) continue;
                            bl = true;
                            break block7;
                        }
                        bl = false;
                    }
                }
                return bl;
            }
            URL workerJar = classLoader2.getResource("worker/org/gradle/api/JavaVersion.class");
            return StringsKt.contains$default((CharSequence)String.valueOf(workerJar), (CharSequence)"gradle-worker.jar", (boolean)false, (int)2, null);
        }
        catch (Throwable t) {
            t.printStackTrace();
            return true;
        }
    }

    @Nullable
    public static final File toFile(@NotNull URI $this$toFile) {
        File file;
        Intrinsics.checkNotNullParameter((Object)$this$toFile, (String)"<this>");
        try {
            file = Paths.get($this$toFile).toFile();
        }
        catch (FileSystemNotFoundException e) {
            file = null;
        }
        return file;
    }

    @Nullable
    public static final File toFile(@NotNull URL $this$toFile) {
        Intrinsics.checkNotNullParameter((Object)$this$toFile, (String)"<this>");
        URI uRI = $this$toFile.toURI();
        Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"toURI(...)");
        return UtilsKt.toFile(uRI);
    }
}

