/*
 * Decompiled with CFR 0.152.
 */
package com.github.mvysny.fakeservlet;

import com.github.mvysny.fakeservlet.FakeHttpEnvironment;
import com.github.mvysny.fakeservlet.FakeHttpEnvironmentKt;
import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpSession;
import jakarta.servlet.http.HttpSessionContext;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\r\b\u0016\u0018\u0000 42\u00020\u00012\u00020\u0002:\u00014B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0004B%\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0006\u0010\u0015\u001a\u00020\u0006J\b\u0010\u0016\u001a\u00020\u0017H\u0002J\u000e\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u0001J\u0006\u0010\u001a\u001a\u00020\u0017J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u001c\u001a\u00020\u0006H\u0016J\u000e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00060\u001eH\u0016J\b\u0010\u001f\u001a\u00020\nH\u0016J\b\u0010 \u001a\u00020\u0006H\u0016J\b\u0010!\u001a\u00020\nH\u0016J\b\u0010\"\u001a\u00020\fH\u0016J\b\u0010#\u001a\u00020\bH\u0016J\n\u0010$\u001a\u0004\u0018\u00010%H\u0017J\u0012\u0010&\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u001c\u001a\u00020\u0006H\u0017J\u0013\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00060(H\u0017\u00a2\u0006\u0002\u0010)J\b\u0010*\u001a\u00020\u0017H\u0016J\b\u0010+\u001a\u00020\u0012H\u0016J\u001a\u0010,\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u00062\b\u0010-\u001a\u0004\u0018\u00010\u0010H\u0017J\u0010\u0010.\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u0006H\u0016J\u0010\u0010/\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u0006H\u0017J\u001a\u00100\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u00062\b\u0010-\u001a\u0004\u0018\u00010\u0010H\u0016J\u0010\u00101\u001a\u00020\u00172\u0006\u00102\u001a\u00020\fH\u0016J\b\u00103\u001a\u00020\u0006H\u0016R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0011\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0013R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lcom/github/mvysny/fakeservlet/FakeHttpSession;", "Ljakarta/servlet/http/HttpSession;", "Ljava/io/Serializable;", "session", "(Ljakarta/servlet/http/HttpSession;)V", "sessionId", "", "servletContext", "Ljakarta/servlet/ServletContext;", "creationTime", "", "maxInactiveInterval", "", "(Ljava/lang/String;Ljakarta/servlet/ServletContext;JI)V", "attributes", "Ljava/util/concurrent/ConcurrentHashMap;", "", "isValid", "", "()Z", "valid", "changeSessionId", "checkValid", "", "copyAttributes", "httpSession", "destroy", "getAttribute", "name", "getAttributeNames", "Ljava/util/Enumeration;", "getCreationTime", "getId", "getLastAccessedTime", "getMaxInactiveInterval", "getServletContext", "getSessionContext", "Ljakarta/servlet/http/HttpSessionContext;", "getValue", "getValueNames", "", "()[Ljava/lang/String;", "invalidate", "isNew", "putValue", "value", "removeAttribute", "removeValue", "setAttribute", "setMaxInactiveInterval", "interval", "toString", "Companion", "fake-servlet5"})
@SourceDebugExtension(value={"SMAP\nFakeHttpSession.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FakeHttpSession.kt\ncom/github/mvysny/fakeservlet/FakeHttpSession\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,151:1\n37#2,2:152\n1855#3,2:154\n*S KotlinDebug\n*F\n+ 1 FakeHttpSession.kt\ncom/github/mvysny/fakeservlet/FakeHttpSession\n*L\n80#1:152,2\n109#1:154,2\n*E\n"})
public class FakeHttpSession
implements HttpSession,
Serializable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private String sessionId;
    @NotNull
    private final ServletContext servletContext;
    private final long creationTime;
    private int maxInactiveInterval;
    @NotNull
    private final ConcurrentHashMap<String, Object> attributes;
    private volatile boolean valid;
    @NotNull
    private static final AtomicInteger sessionIdGenerator = new AtomicInteger();

    public FakeHttpSession(@NotNull String sessionId, @NotNull ServletContext servletContext, long creationTime, int maxInactiveInterval) {
        Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
        Intrinsics.checkNotNullParameter((Object)servletContext, (String)"servletContext");
        this.sessionId = sessionId;
        this.servletContext = servletContext;
        this.creationTime = creationTime;
        this.maxInactiveInterval = maxInactiveInterval;
        this.attributes = new ConcurrentHashMap();
        this.valid = true;
    }

    public final boolean isValid() {
        return this.valid;
    }

    public FakeHttpSession(@NotNull HttpSession session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        String string = session.getId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
        ServletContext servletContext = session.getServletContext();
        Intrinsics.checkNotNullExpressionValue((Object)servletContext, (String)"getServletContext(...)");
        this(string, servletContext, session.getLastAccessedTime(), session.getMaxInactiveInterval());
        this.copyAttributes(session);
    }

    public final void destroy() {
        this.attributes.clear();
    }

    public long getCreationTime() {
        this.checkValid();
        return this.creationTime;
    }

    @NotNull
    public String getId() {
        return this.sessionId;
    }

    public long getLastAccessedTime() {
        this.checkValid();
        return 0L;
    }

    @NotNull
    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public void setMaxInactiveInterval(int interval) {
        this.maxInactiveInterval = interval;
    }

    public int getMaxInactiveInterval() {
        return this.maxInactiveInterval;
    }

    @Deprecated(message="Deprecated in Java")
    @Nullable
    public HttpSessionContext getSessionContext() {
        return null;
    }

    @Nullable
    public Object getAttribute(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.checkValid();
        return this.attributes.get(name);
    }

    @Deprecated(message="Deprecated in Java")
    @Nullable
    public Object getValue(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.getAttribute(name);
    }

    @NotNull
    public Enumeration<String> getAttributeNames() {
        this.checkValid();
        Enumeration<String> enumeration = this.attributes.keys();
        Intrinsics.checkNotNullExpressionValue(enumeration, (String)"keys(...)");
        return enumeration;
    }

    @Deprecated(message="Deprecated in Java")
    @NotNull
    public String[] getValueNames() {
        ArrayList<String> arrayList = Collections.list(this.getAttributeNames());
        Intrinsics.checkNotNullExpressionValue(arrayList, (String)"list(...)");
        Collection $this$toTypedArray$iv = arrayList;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new String[0]);
    }

    public void setAttribute(@NotNull String name, @Nullable Object value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.checkValid();
        FakeHttpEnvironmentKt.putOrRemove(this.attributes, name, value);
    }

    @Deprecated(message="Deprecated in Java")
    public void putValue(@NotNull String name, @Nullable Object value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.setAttribute(name, value);
    }

    public void removeAttribute(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.checkValid();
        this.attributes.remove(name);
    }

    @Deprecated(message="Deprecated in Java")
    public void removeValue(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.removeAttribute(name);
    }

    @NotNull
    public final FakeHttpSession copyAttributes(@NotNull HttpSession httpSession) {
        Intrinsics.checkNotNullParameter((Object)httpSession, (String)"httpSession");
        Enumeration enumeration = httpSession.getAttributeNames();
        Intrinsics.checkNotNullExpressionValue((Object)enumeration, (String)"getAttributeNames(...)");
        ArrayList arrayList = Collections.list(enumeration);
        Intrinsics.checkNotNullExpressionValue(arrayList, (String)"list(...)");
        Iterable $this$forEach$iv = arrayList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object object;
            String it = (String)element$iv;
            boolean bl = false;
            Map map = this.attributes;
            Intrinsics.checkNotNull((Object)it);
            String string = it;
            Intrinsics.checkNotNullExpressionValue((Object)httpSession.getAttribute(it), (String)"getAttribute(...)");
            map.put(string, object);
        }
        return this;
    }

    public void invalidate() {
        this.checkValid();
        this.valid = false;
    }

    public boolean isNew() {
        this.checkValid();
        return false;
    }

    private final void checkValid() {
        if (!this.isValid() && FakeHttpEnvironment.INSTANCE.getStrictSessionValidityChecks()) {
            throw new IllegalStateException("invalidated: " + this);
        }
    }

    @NotNull
    public String toString() {
        return "MockHttpSession(sessionId='" + this.sessionId + "', creationTime=" + this.creationTime + ", maxInactiveInterval=" + this.maxInactiveInterval + ", attributes=" + this.attributes + ", isValid=" + this.isValid() + ')';
    }

    @NotNull
    public final String changeSessionId() {
        this.sessionId = FakeHttpSession.Companion.generateSessionId();
        return this.sessionId;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\b\u0010\t\u001a\u00020\nH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/github/mvysny/fakeservlet/FakeHttpSession$Companion;", "", "()V", "sessionIdGenerator", "Ljava/util/concurrent/atomic/AtomicInteger;", "create", "Lcom/github/mvysny/fakeservlet/FakeHttpSession;", "ctx", "Ljakarta/servlet/ServletContext;", "generateSessionId", "", "fake-servlet5"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FakeHttpSession create(@NotNull ServletContext ctx) {
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            return new FakeHttpSession(this.generateSessionId(), ctx, System.currentTimeMillis(), 30);
        }

        private final String generateSessionId() {
            return String.valueOf(sessionIdGenerator.incrementAndGet());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

